/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.filter.DoubleRange;
import com.espertech.esper.filter.EventEvaluator;
import com.espertech.esper.filter.FilterHandle;
import com.espertech.esper.filter.FilterOperator;
import com.espertech.esper.filter.FilterParamIndexDoubleRangeBase;
import java.util.Collection;
import java.util.Map;
import java.util.SortedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FilterParamIndexDoubleRange
extends FilterParamIndexDoubleRangeBase {
    private static final Log log = LogFactory.getLog(FilterParamIndexDoubleRange.class);

    public FilterParamIndexDoubleRange(String attributeName, FilterOperator filterOperator, EventType eventType) {
        super(attributeName, filterOperator, eventType);
        if (!filterOperator.isRangeOperator()) {
            throw new IllegalArgumentException("Invalid filter operator " + (Object)((Object)filterOperator));
        }
    }

    @Override
    public final void matchEvent(EventBean eventBean, Collection<FilterHandle> matches) {
        Object objAttributeValue = this.getGetter().get(eventBean);
        if (objAttributeValue == null) {
            return;
        }
        double attributeValue = ((Number)objAttributeValue).doubleValue();
        DoubleRange rangeStart = new DoubleRange(attributeValue - this.largestRangeValueDouble, attributeValue);
        DoubleRange rangeEnd = new DoubleRange(attributeValue, (Double)Double.MAX_VALUE);
        SortedMap subMap = this.ranges.subMap(rangeStart, rangeEnd);
        if (this.getFilterOperator() == FilterOperator.RANGE_OPEN) {
            for (Map.Entry entry : subMap.entrySet()) {
                if (!(attributeValue > entry.getKey().getMin()) || !(attributeValue < entry.getKey().getMax())) continue;
                ((EventEvaluator)entry.getValue()).matchEvent(eventBean, matches);
            }
        } else if (this.getFilterOperator() == FilterOperator.RANGE_CLOSED) {
            for (Map.Entry entry : subMap.entrySet()) {
                if (!(attributeValue >= entry.getKey().getMin()) || !(attributeValue <= entry.getKey().getMax())) continue;
                ((EventEvaluator)entry.getValue()).matchEvent(eventBean, matches);
            }
        } else if (this.getFilterOperator() == FilterOperator.RANGE_HALF_CLOSED) {
            for (Map.Entry entry : subMap.entrySet()) {
                if (!(attributeValue > entry.getKey().getMin()) || !(attributeValue <= entry.getKey().getMax())) continue;
                ((EventEvaluator)entry.getValue()).matchEvent(eventBean, matches);
            }
        } else if (this.getFilterOperator() == FilterOperator.RANGE_HALF_OPEN) {
            for (Map.Entry entry : subMap.entrySet()) {
                if (!(attributeValue >= entry.getKey().getMin()) || !(attributeValue < entry.getKey().getMax())) continue;
                ((EventEvaluator)entry.getValue()).matchEvent(eventBean, matches);
            }
        } else {
            throw new IllegalStateException("Invalid filter operator " + (Object)((Object)this.getFilterOperator()));
        }
    }
}

