/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventType;
import com.espertech.esper.filter.EventEvaluator;
import com.espertech.esper.filter.FilterOperator;
import com.espertech.esper.filter.FilterParamIndexPropBase;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class FilterParamIndexEqualsBase
extends FilterParamIndexPropBase {
    protected final Map<Object, EventEvaluator> constantsMap = new HashMap<Object, EventEvaluator>();
    protected final ReadWriteLock constantsMapRWLock = new ReentrantReadWriteLock();

    public FilterParamIndexEqualsBase(String propertyName, FilterOperator filterOperator, EventType eventType) {
        super(propertyName, filterOperator, eventType);
    }

    @Override
    public final EventEvaluator get(Object filterConstant) {
        this.checkType(filterConstant);
        return this.constantsMap.get(filterConstant);
    }

    @Override
    public final void put(Object filterConstant, EventEvaluator evaluator) {
        this.checkType(filterConstant);
        this.constantsMap.put(filterConstant, evaluator);
    }

    @Override
    public final boolean remove(Object filterConstant) {
        return this.constantsMap.remove(filterConstant) != null;
    }

    @Override
    public final int size() {
        return this.constantsMap.size();
    }

    @Override
    public final ReadWriteLock getReadWriteLock() {
        return this.constantsMapRWLock;
    }

    protected void checkType(Object filterConstant) {
        if (filterConstant != null && this.getPropertyBoxedType() != filterConstant.getClass() && !this.getPropertyBoxedType().isAssignableFrom(filterConstant.getClass())) {
            throw new IllegalArgumentException("Invalid type of filter constant of " + filterConstant.getClass().getName() + " for property " + this.getPropertyName());
        }
    }
}

