/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.filter.EventEvaluator;
import com.espertech.esper.filter.FilterHandle;
import com.espertech.esper.filter.FilterOperator;
import com.espertech.esper.filter.FilterParamIndexPropBase;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FilterParamIndexIn
extends FilterParamIndexPropBase {
    private final Map<Object, List<EventEvaluator>> constantsMap = new HashMap<Object, List<EventEvaluator>>();
    private final Map<MultiKeyUntyped, EventEvaluator> evaluatorsMap = new HashMap<MultiKeyUntyped, EventEvaluator>();
    private final ReadWriteLock constantsMapRWLock = new ReentrantReadWriteLock();
    private static final Log log = LogFactory.getLog(FilterParamIndexIn.class);

    public FilterParamIndexIn(String propertyName, EventType eventType) {
        super(propertyName, FilterOperator.IN_LIST_OF_VALUES, eventType);
    }

    @Override
    public final EventEvaluator get(Object filterConstant) {
        MultiKeyUntyped keyValues = (MultiKeyUntyped)filterConstant;
        return this.evaluatorsMap.get(keyValues);
    }

    @Override
    public final void put(Object filterConstant, EventEvaluator evaluator) {
        MultiKeyUntyped keys = (MultiKeyUntyped)filterConstant;
        EventEvaluator oldEvaluator = this.evaluatorsMap.put(keys, evaluator);
        Object[] keyValues = keys.getKeys();
        for (int i = 0; i < keyValues.length; ++i) {
            List<EventEvaluator> evaluators = this.constantsMap.get(keyValues[i]);
            if (evaluators == null) {
                evaluators = new LinkedList<EventEvaluator>();
                this.constantsMap.put(keyValues[i], evaluators);
            } else if (oldEvaluator != null) {
                evaluators.remove(oldEvaluator);
            }
            evaluators.add(evaluator);
        }
    }

    @Override
    public final boolean remove(Object filterConstant) {
        MultiKeyUntyped keys = (MultiKeyUntyped)filterConstant;
        EventEvaluator eval = this.evaluatorsMap.remove(keys);
        boolean isRemoved = false;
        if (eval != null) {
            isRemoved = true;
        }
        Object[] keyValues = keys.getKeys();
        for (int i = 0; i < keyValues.length; ++i) {
            List<EventEvaluator> evaluators = this.constantsMap.get(keyValues[i]);
            if (evaluators == null) continue;
            evaluators.remove(eval);
            if (!evaluators.isEmpty()) continue;
            this.constantsMap.remove(keyValues[i]);
        }
        return isRemoved;
    }

    @Override
    public final int size() {
        return this.constantsMap.size();
    }

    @Override
    public final ReadWriteLock getReadWriteLock() {
        return this.constantsMapRWLock;
    }

    @Override
    public final void matchEvent(EventBean eventBean, Collection<FilterHandle> matches) {
        Object attributeValue = this.getGetter().get(eventBean);
        if (attributeValue == null) {
            return;
        }
        this.constantsMapRWLock.readLock().lock();
        List<EventEvaluator> evaluators = this.constantsMap.get(attributeValue);
        if (evaluators == null) {
            this.constantsMapRWLock.readLock().unlock();
            return;
        }
        for (EventEvaluator evaluator : evaluators) {
            evaluator.matchEvent(eventBean, matches);
        }
        this.constantsMapRWLock.readLock().unlock();
    }
}

