/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.filter.EventEvaluator;
import com.espertech.esper.filter.FilterHandle;
import com.espertech.esper.filter.FilterOperator;
import com.espertech.esper.filter.FilterParamIndexPropBase;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FilterParamIndexNotIn
extends FilterParamIndexPropBase {
    private final Map<Object, Set<EventEvaluator>> constantsMap = new HashMap<Object, Set<EventEvaluator>>();
    private final Map<MultiKeyUntyped, EventEvaluator> filterValueEvaluators = new HashMap<MultiKeyUntyped, EventEvaluator>();
    private final Set<EventEvaluator> evaluatorsSet = new HashSet<EventEvaluator>();
    private final ReadWriteLock constantsMapRWLock = new ReentrantReadWriteLock();
    private static final Log log = LogFactory.getLog(FilterParamIndexNotIn.class);

    public FilterParamIndexNotIn(String propertyName, EventType eventType) {
        super(propertyName, FilterOperator.NOT_IN_LIST_OF_VALUES, eventType);
    }

    @Override
    public final EventEvaluator get(Object filterConstant) {
        MultiKeyUntyped keyValues = (MultiKeyUntyped)filterConstant;
        return this.filterValueEvaluators.get(keyValues);
    }

    @Override
    public final void put(Object filterConstant, EventEvaluator evaluator) {
        Object[] keyValues;
        MultiKeyUntyped keys = (MultiKeyUntyped)filterConstant;
        this.filterValueEvaluators.put(keys, evaluator);
        this.evaluatorsSet.add(evaluator);
        for (Object keyValue : keyValues = keys.getKeys()) {
            Set<EventEvaluator> evaluators = this.constantsMap.get(keyValue);
            if (evaluators == null) {
                evaluators = new HashSet<EventEvaluator>();
                this.constantsMap.put(keyValue, evaluators);
            }
            evaluators.add(evaluator);
        }
    }

    @Override
    public final boolean remove(Object filterConstant) {
        Object[] keyValues;
        MultiKeyUntyped keys = (MultiKeyUntyped)filterConstant;
        EventEvaluator eval = this.filterValueEvaluators.remove(keys);
        this.evaluatorsSet.remove(eval);
        boolean isRemoved = false;
        if (eval != null) {
            isRemoved = true;
        }
        for (Object keyValue : keyValues = keys.getKeys()) {
            Set<EventEvaluator> evaluators = this.constantsMap.get(keyValue);
            if (evaluators == null) continue;
            evaluators.remove(eval);
            if (!evaluators.isEmpty()) continue;
            this.constantsMap.remove(keyValue);
        }
        return isRemoved;
    }

    @Override
    public final int size() {
        return this.constantsMap.size();
    }

    @Override
    public final ReadWriteLock getReadWriteLock() {
        return this.constantsMapRWLock;
    }

    @Override
    public final void matchEvent(EventBean eventBean, Collection<FilterHandle> matches) {
        Object attributeValue = this.getGetter().get(eventBean);
        if (attributeValue == null) {
            return;
        }
        this.constantsMapRWLock.readLock().lock();
        Set<EventEvaluator> evalNotMatching = this.constantsMap.get(attributeValue);
        if (evalNotMatching == null) {
            for (EventEvaluator eval : this.evaluatorsSet) {
                eval.matchEvent(eventBean, matches);
            }
            this.constantsMapRWLock.readLock().unlock();
            return;
        }
        if (evalNotMatching.size() == this.evaluatorsSet.size()) {
            this.constantsMapRWLock.readLock().unlock();
            return;
        }
        for (EventEvaluator eval : this.evaluatorsSet) {
            if (evalNotMatching.contains(eval)) continue;
            eval.matchEvent(eventBean, matches);
        }
        this.constantsMapRWLock.readLock().unlock();
    }
}

