/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.filter.EventEvaluator;
import com.espertech.esper.filter.FilterHandle;
import com.espertech.esper.filter.FilterOperator;
import com.espertech.esper.filter.FilterParamIndexStringRangeBase;
import com.espertech.esper.filter.StringRange;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FilterParamIndexStringRangeInverted
extends FilterParamIndexStringRangeBase {
    private static final Log log = LogFactory.getLog(FilterParamIndexStringRangeInverted.class);

    public FilterParamIndexStringRangeInverted(String attributeName, FilterOperator filterOperator, EventType eventType) {
        super(attributeName, filterOperator, eventType);
        if (!filterOperator.isInvertedRangeOperator()) {
            throw new IllegalArgumentException("Invalid filter operator " + (Object)((Object)filterOperator));
        }
    }

    @Override
    public final void matchEvent(EventBean eventBean, Collection<FilterHandle> matches) {
        Object objAttributeValue = this.getGetter().get(eventBean);
        if (objAttributeValue == null) {
            return;
        }
        String attributeValue = (String)objAttributeValue;
        if (this.getFilterOperator() == FilterOperator.NOT_RANGE_CLOSED) {
            for (Map.Entry entry : this.ranges.entrySet()) {
                if (((StringRange)entry.getKey()).getMin().compareTo(attributeValue) <= 0 && ((StringRange)entry.getKey()).getMax().compareTo(attributeValue) >= 0) continue;
                ((EventEvaluator)entry.getValue()).matchEvent(eventBean, matches);
            }
        } else if (this.getFilterOperator() == FilterOperator.NOT_RANGE_OPEN) {
            for (Map.Entry entry : this.ranges.entrySet()) {
                if (((StringRange)entry.getKey()).getMin().compareTo(attributeValue) < 0 && ((StringRange)entry.getKey()).getMax().compareTo(attributeValue) > 0) continue;
                ((EventEvaluator)entry.getValue()).matchEvent(eventBean, matches);
            }
        } else if (this.getFilterOperator() == FilterOperator.NOT_RANGE_HALF_CLOSED) {
            for (Map.Entry entry : this.ranges.entrySet()) {
                if (((StringRange)entry.getKey()).getMin().compareTo(attributeValue) < 0 && ((StringRange)entry.getKey()).getMax().compareTo(attributeValue) >= 0) continue;
                ((EventEvaluator)entry.getValue()).matchEvent(eventBean, matches);
            }
        } else if (this.getFilterOperator() == FilterOperator.NOT_RANGE_HALF_OPEN) {
            for (Map.Entry entry : this.ranges.entrySet()) {
                if (((StringRange)entry.getKey()).getMin().compareTo(attributeValue) <= 0 && ((StringRange)entry.getKey()).getMax().compareTo(attributeValue) > 0) continue;
                ((EventEvaluator)entry.getValue()).matchEvent(eventBean, matches);
            }
        } else {
            throw new IllegalStateException("Invalid filter operator " + (Object)((Object)this.getFilterOperator()));
        }
    }
}

