/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.property.PropertyEvaluator;
import com.espertech.esper.filter.FilterSpecParam;
import com.espertech.esper.filter.FilterSpecParamComparator;
import com.espertech.esper.filter.FilterValueSet;
import com.espertech.esper.filter.FilterValueSetImpl;
import com.espertech.esper.filter.FilterValueSetParam;
import com.espertech.esper.filter.FilterValueSetParamImpl;
import com.espertech.esper.pattern.MatchedEventMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class FilterSpecCompiled {
    private static final ArrayDeque<FilterSpecParam> EMPTY_LIST = new ArrayDeque();
    private static final FilterSpecParamComparator COMPARATOR_PARAMETERS = new FilterSpecParamComparator();
    private final EventType filterForEventType;
    private final String filterForEventTypeName;
    private final ArrayDeque<FilterSpecParam> parameters;
    private final PropertyEvaluator optionalPropertyEvaluator;

    public FilterSpecCompiled(EventType eventType, String eventTypeName, List<FilterSpecParam> filterParameters, PropertyEvaluator optionalPropertyEvaluator) {
        this.filterForEventType = eventType;
        this.filterForEventTypeName = eventTypeName;
        this.parameters = FilterSpecCompiled.sortRemoveDups(filterParameters);
        this.optionalPropertyEvaluator = optionalPropertyEvaluator;
    }

    public final EventType getFilterForEventType() {
        return this.filterForEventType;
    }

    public final ArrayDeque<FilterSpecParam> getParameters() {
        return this.parameters;
    }

    public String getFilterForEventTypeName() {
        return this.filterForEventTypeName;
    }

    public PropertyEvaluator getOptionalPropertyEvaluator() {
        return this.optionalPropertyEvaluator;
    }

    public EventType getResultEventType() {
        if (this.optionalPropertyEvaluator != null) {
            return this.optionalPropertyEvaluator.getFragmentEventType();
        }
        return this.filterForEventType;
    }

    public FilterValueSet getValueSet(MatchedEventMap matchedEvents, ExprEvaluatorContext evaluatorContext, List<FilterValueSetParam> addendum) {
        ArrayDeque<FilterValueSetParam> valueList;
        if (addendum != null) {
            valueList = new ArrayDeque(this.parameters.size() + addendum.size());
            valueList.addAll(addendum);
        } else {
            valueList = new ArrayDeque<FilterValueSetParam>(this.parameters.size());
        }
        this.populateValueSet(valueList, matchedEvents, evaluatorContext);
        return new FilterValueSetImpl(this.filterForEventType, valueList);
    }

    private void populateValueSet(ArrayDeque<FilterValueSetParam> valueList, MatchedEventMap matchedEvents, ExprEvaluatorContext exprEvaluatorContext) {
        for (FilterSpecParam specParam : this.parameters) {
            Object filterForValue = specParam.getFilterValue(matchedEvents, exprEvaluatorContext);
            FilterValueSetParamImpl valueParam = new FilterValueSetParamImpl(specParam.getPropertyName(), specParam.getFilterOperator(), filterForValue);
            valueList.add(valueParam);
        }
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("FilterSpecCompiled type=" + this.filterForEventType);
        buffer.append(" parameters=" + Arrays.toString(this.parameters.toArray()));
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FilterSpecCompiled)) {
            return false;
        }
        FilterSpecCompiled other = (FilterSpecCompiled)obj;
        if (!this.equalsTypeAndFilter(other)) {
            return false;
        }
        if (this.optionalPropertyEvaluator == null && other.optionalPropertyEvaluator == null) {
            return true;
        }
        if (this.optionalPropertyEvaluator != null && other.optionalPropertyEvaluator == null) {
            return false;
        }
        if (this.optionalPropertyEvaluator == null && other.optionalPropertyEvaluator != null) {
            return false;
        }
        return this.optionalPropertyEvaluator.compareTo(other.optionalPropertyEvaluator);
    }

    public boolean equalsTypeAndFilter(FilterSpecCompiled other) {
        if (this.filterForEventType != other.filterForEventType) {
            return false;
        }
        if (this.parameters.size() != other.parameters.size()) {
            return false;
        }
        Iterator<FilterSpecParam> iterOne = this.parameters.iterator();
        Iterator<FilterSpecParam> iterOther = other.parameters.iterator();
        while (iterOne.hasNext()) {
            if (iterOne.next().equals(iterOther.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = this.filterForEventType.hashCode();
        for (FilterSpecParam param : this.parameters) {
            hashCode = 31 * hashCode;
            hashCode ^= param.getPropertyName().hashCode();
            hashCode ^= 31 * param.getFilterHash();
        }
        return hashCode;
    }

    protected static ArrayDeque<FilterSpecParam> sortRemoveDups(List<FilterSpecParam> parameters) {
        if (parameters.isEmpty()) {
            return EMPTY_LIST;
        }
        ArrayDeque<FilterSpecParam> result = new ArrayDeque<FilterSpecParam>();
        if (parameters.size() == 1) {
            result.addAll(parameters);
            return result;
        }
        TreeMap map = new TreeMap(COMPARATOR_PARAMETERS);
        for (FilterSpecParam filterSpecParam : parameters) {
            ArrayList<FilterSpecParam> list = (ArrayList<FilterSpecParam>)map.get((Object)filterSpecParam.getFilterOperator());
            if (list == null) {
                list = new ArrayList<FilterSpecParam>();
                map.put(filterSpecParam.getFilterOperator(), list);
            }
            boolean hasDuplicate = false;
            for (FilterSpecParam existing : list) {
                if (!existing.getPropertyName().equals(filterSpecParam.propertyName)) continue;
                hasDuplicate = true;
                break;
            }
            if (hasDuplicate) continue;
            list.add(filterSpecParam);
        }
        for (Map.Entry entry : map.entrySet()) {
            result.addAll((Collection)entry.getValue());
        }
        return result;
    }
}

