/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.ConfigurationInformation;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.context.util.ContextDescriptor;
import com.espertech.esper.core.service.ExprEvaluatorContextStatement;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.start.EPStatementStartMethodHelperValidate;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.core.ViewResourceDelegateUnverified;
import com.espertech.esper.epl.expression.ExprAggregateNode;
import com.espertech.esper.epl.expression.ExprAggregateNodeUtil;
import com.espertech.esper.epl.expression.ExprAndNode;
import com.espertech.esper.epl.expression.ExprAndNodeImpl;
import com.espertech.esper.epl.expression.ExprBetweenNode;
import com.espertech.esper.epl.expression.ExprConstantNode;
import com.espertech.esper.epl.expression.ExprContextPropertyNode;
import com.espertech.esper.epl.expression.ExprEqualsNode;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprIdentNode;
import com.espertech.esper.epl.expression.ExprInNode;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeSubselectVisitor;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprRelationalOpNode;
import com.espertech.esper.epl.expression.ExprSubselectNode;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.named.NamedWindowProcessor;
import com.espertech.esper.epl.property.PropertyEvaluator;
import com.espertech.esper.epl.property.PropertyEvaluatorFactory;
import com.espertech.esper.epl.spec.FilterStreamSpecCompiled;
import com.espertech.esper.epl.spec.NamedWindowConsumerStreamSpec;
import com.espertech.esper.epl.spec.PropertyEvalSpec;
import com.espertech.esper.epl.spec.SelectClauseElementCompiled;
import com.espertech.esper.epl.spec.SelectClauseExprCompiledSpec;
import com.espertech.esper.epl.spec.SelectClauseSpecCompiled;
import com.espertech.esper.epl.spec.StatementSpecCompiled;
import com.espertech.esper.epl.spec.StreamSpecCompiled;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.property.IndexedProperty;
import com.espertech.esper.event.property.NestedProperty;
import com.espertech.esper.event.property.Property;
import com.espertech.esper.event.property.PropertyParser;
import com.espertech.esper.filter.FilterOperator;
import com.espertech.esper.filter.FilterParamExprMap;
import com.espertech.esper.filter.FilterSpecCompiled;
import com.espertech.esper.filter.FilterSpecParam;
import com.espertech.esper.filter.FilterSpecParamConstant;
import com.espertech.esper.filter.FilterSpecParamContextProp;
import com.espertech.esper.filter.FilterSpecParamEventProp;
import com.espertech.esper.filter.FilterSpecParamEventPropIndexed;
import com.espertech.esper.filter.FilterSpecParamExprNode;
import com.espertech.esper.filter.FilterSpecParamIn;
import com.espertech.esper.filter.FilterSpecParamInValue;
import com.espertech.esper.filter.FilterSpecParamRange;
import com.espertech.esper.filter.FilterSpecParamRangeValue;
import com.espertech.esper.filter.InSetOfValuesConstant;
import com.espertech.esper.filter.InSetOfValuesContextProp;
import com.espertech.esper.filter.InSetOfValuesEventProp;
import com.espertech.esper.filter.InSetOfValuesEventPropIndexed;
import com.espertech.esper.filter.RangeValueContextProp;
import com.espertech.esper.filter.RangeValueDouble;
import com.espertech.esper.filter.RangeValueEventProp;
import com.espertech.esper.filter.RangeValueEventPropIndexed;
import com.espertech.esper.filter.RangeValueString;
import com.espertech.esper.schedule.TimeProvider;
import com.espertech.esper.type.RelationalOpEnum;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.SimpleNumberCoercer;
import com.espertech.esper.util.SimpleNumberCoercerFactory;
import com.espertech.esper.view.ViewFactoryChain;
import com.espertech.esper.view.ViewProcessingException;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FilterSpecCompiler {
    private static final Log log = LogFactory.getLog(FilterSpecCompiler.class);
    public static final String PROPERTY_NAME_BOOLEAN_EXPRESSION = ".boolean_expression";

    public static FilterSpecCompiled makeFilterSpec(EventType eventType, String eventTypeName, List<ExprNode> filterExpessions, PropertyEvalSpec optionalPropertyEvalSpec, LinkedHashMap<String, Pair<EventType, String>> taggedEventTypes, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, TimeProvider timeProvider, VariableService variableService, EventAdapterService eventAdapterService, String engineURI, String optionalStreamName, StatementContext statementContext, Collection<Integer> assignedTypeNumberStack, ContextDescriptor contextDescriptor, ConfigurationInformation configurationInformation) throws ExprValidationException {
        List<ExprNode> validatedNodes = FilterSpecCompiler.validateAllowSubquery(filterExpessions, streamTypeService, statementContext, taggedEventTypes, arrayEventTypes);
        ExprEvaluatorContextStatement evaluatorContextStmt = new ExprEvaluatorContextStatement(statementContext);
        return FilterSpecCompiler.build(validatedNodes, eventType, eventTypeName, optionalPropertyEvalSpec, taggedEventTypes, arrayEventTypes, streamTypeService, methodResolutionService, timeProvider, variableService, eventAdapterService, engineURI, optionalStreamName, evaluatorContextStmt, statementContext.getStatementId(), statementContext.getStatementName(), statementContext.getAnnotations(), assignedTypeNumberStack, statementContext.getContextDescriptor(), statementContext.getConfigSnapshot());
    }

    public static FilterSpecCompiled build(List<ExprNode> validatedNodes, EventType eventType, String eventTypeName, PropertyEvalSpec optionalPropertyEvalSpec, LinkedHashMap<String, Pair<EventType, String>> taggedEventTypes, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, TimeProvider timeProvider, VariableService variableService, EventAdapterService eventAdapterService, String engineURI, String optionalStreamName, ExprEvaluatorContext exprEvaluatorContext, String statementId, String statementName, Annotation[] annotations, Collection<Integer> assignedTypeNumberStack, ContextDescriptor contextDescriptor, ConfigurationInformation configurationInformation) throws ExprValidationException {
        List<ExprNode> constituents = FilterSpecCompiler.decomposeCheckAggregation(validatedNodes);
        FilterParamExprMap filterParamExprMap = new FilterParamExprMap();
        for (ExprNode constituent : constituents) {
            FilterSpecParam param = FilterSpecCompiler.makeFilterParam(constituent, taggedEventTypes, arrayEventTypes, exprEvaluatorContext, statementName);
            filterParamExprMap.put(constituent, param);
        }
        FilterSpecCompiler.consolidate(filterParamExprMap, statementName);
        ArrayList<FilterSpecParam> filterParams = new ArrayList<FilterSpecParam>();
        filterParams.addAll(filterParamExprMap.getFilterParams());
        List<ExprNode> remainingExprNodes = filterParamExprMap.getUnassignedExpressions();
        ExprNode exprNode = null;
        if (!remainingExprNodes.isEmpty()) {
            if (remainingExprNodes.size() == 1) {
                exprNode = remainingExprNodes.get(0);
            } else {
                ExprAndNodeImpl andNode = new ExprAndNodeImpl();
                for (ExprNode unoptimized : remainingExprNodes) {
                    andNode.addChildNode(unoptimized);
                }
                ExprValidationContext validationContext = new ExprValidationContext(streamTypeService, methodResolutionService, null, timeProvider, variableService, exprEvaluatorContext, eventAdapterService, statementName, statementId, annotations, contextDescriptor);
                andNode.validate(validationContext);
                exprNode = andNode;
            }
        }
        if (exprNode != null) {
            FilterSpecParamExprNode param = new FilterSpecParamExprNode(PROPERTY_NAME_BOOLEAN_EXPRESSION, FilterOperator.BOOLEAN_EXPRESSION, exprNode, taggedEventTypes, arrayEventTypes, variableService, eventAdapterService, configurationInformation);
            filterParams.add(param);
        }
        PropertyEvaluator optionalPropertyEvaluator = null;
        if (optionalPropertyEvalSpec != null) {
            optionalPropertyEvaluator = PropertyEvaluatorFactory.makeEvaluator(optionalPropertyEvalSpec, eventType, optionalStreamName, eventAdapterService, methodResolutionService, timeProvider, variableService, engineURI, statementId, statementName, annotations, assignedTypeNumberStack);
        }
        FilterSpecCompiled spec = new FilterSpecCompiled(eventType, eventTypeName, filterParams, optionalPropertyEvaluator);
        if (log.isDebugEnabled()) {
            log.debug((Object)(".makeFilterSpec spec=" + spec));
        }
        return spec;
    }

    private static void consolidate(List<FilterSpecParam> items, FilterParamExprMap filterParamExprMap, String statementName) {
        FilterOperator op = items.get(0).getFilterOperator();
        if (op == FilterOperator.NOT_EQUAL) {
            FilterSpecCompiler.handleConsolidateNotEqual(items, filterParamExprMap, statementName);
        } else {
            for (int i = 1; i < items.size(); ++i) {
                filterParamExprMap.removeValue(items.get(i));
            }
        }
    }

    public static List<ExprNode> validateAllowSubquery(List<ExprNode> exprNodes, StreamTypeService streamTypeService, StatementContext statementContext, LinkedHashMap<String, Pair<EventType, String>> taggedEventTypes, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes) throws ExprValidationException {
        ArrayList<ExprNode> validatedNodes = new ArrayList<ExprNode>();
        ExprEvaluatorContextStatement evaluatorContextStmt = new ExprEvaluatorContextStatement(statementContext);
        ExprValidationContext validationContext = new ExprValidationContext(streamTypeService, statementContext.getMethodResolutionService(), null, statementContext.getTimeProvider(), statementContext.getVariableService(), evaluatorContextStmt, statementContext.getEventAdapterService(), statementContext.getStatementName(), statementContext.getStatementId(), statementContext.getAnnotations(), statementContext.getContextDescriptor());
        for (ExprNode node : exprNodes) {
            ExprNodeSubselectVisitor visitor = new ExprNodeSubselectVisitor();
            node.accept(visitor);
            if (!visitor.getSubselects().isEmpty()) {
                int subselectStreamNumber = 2048;
                for (ExprSubselectNode subselect : visitor.getSubselects()) {
                    FilterSpecCompiler.handleSubselectSelectClauses(++subselectStreamNumber, statementContext, subselect, streamTypeService.getEventTypes()[0], streamTypeService.getStreamNames()[0], streamTypeService.getStreamNames()[0], taggedEventTypes, arrayEventTypes);
                }
            }
            ExprNode validated = ExprNodeUtility.getValidatedSubtree(node, validationContext);
            validatedNodes.add(validated);
            if (validated.getExprEvaluator().getType() == Boolean.class || validated.getExprEvaluator().getType() == Boolean.TYPE) continue;
            throw new ExprValidationException("Filter expression not returning a boolean value: '" + validated.toExpressionString() + "'");
        }
        return validatedNodes;
    }

    private static void handleSubselectSelectClauses(int subselectStreamNumber, StatementContext statementContext, ExprSubselectNode subselect, EventType outerEventType, String outerEventTypeName, String outerStreamName, LinkedHashMap<String, Pair<EventType, String>> taggedEventTypes, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes) throws ExprValidationException {
        ViewFactoryChain viewFactoryChain;
        StatementSpecCompiled statementSpec = subselect.getStatementSpecCompiled();
        StreamSpecCompiled filterStreamSpec = statementSpec.getStreamSpecs().get(0);
        String subselecteventTypeName = null;
        try {
            if (statementSpec.getStreamSpecs().get(0) instanceof FilterStreamSpecCompiled) {
                FilterStreamSpecCompiled filterStreamSpecCompiled = (FilterStreamSpecCompiled)statementSpec.getStreamSpecs().get(0);
                subselecteventTypeName = filterStreamSpecCompiled.getFilterSpec().getFilterForEventTypeName();
                if (filterStreamSpec.getViewSpecs().size() == 0) {
                    throw new ExprValidationException("Subqueries require one or more views to limit the stream, consider declaring a length or time window");
                }
                viewFactoryChain = statementContext.getViewService().createFactories(subselectStreamNumber, filterStreamSpecCompiled.getFilterSpec().getResultEventType(), filterStreamSpec.getViewSpecs(), filterStreamSpec.getOptions(), statementContext);
                subselect.setRawEventType(viewFactoryChain.getEventType());
            } else {
                NamedWindowConsumerStreamSpec namedSpec = (NamedWindowConsumerStreamSpec)statementSpec.getStreamSpecs().get(0);
                NamedWindowProcessor processor = statementContext.getNamedWindowService().getProcessor(namedSpec.getWindowName());
                viewFactoryChain = statementContext.getViewService().createFactories(0, processor.getNamedWindowType(), namedSpec.getViewSpecs(), namedSpec.getOptions(), statementContext);
                subselecteventTypeName = namedSpec.getWindowName();
            }
        }
        catch (ViewProcessingException ex) {
            throw new ExprValidationException("Error validating subexpression: " + ex.getMessage(), ex);
        }
        EventType eventType = viewFactoryChain.getEventType();
        String subexpressionStreamName = filterStreamSpec.getOptionalStreamName();
        if (subexpressionStreamName == null) {
            subexpressionStreamName = "$subselect_" + subselectStreamNumber;
        }
        if (filterStreamSpec instanceof NamedWindowConsumerStreamSpec) {
            EPStatementStartMethodHelperValidate.validateNoDataWindowOnNamedWindow(viewFactoryChain.getViewFactoryChain());
        }
        LinkedHashMap<String, Pair<EventType, String>> namesAndTypes = new LinkedHashMap<String, Pair<EventType, String>>();
        namesAndTypes.put(subexpressionStreamName, new Pair<EventType, String>(eventType, subselecteventTypeName));
        namesAndTypes.put(outerStreamName, new Pair<EventType, String>(outerEventType, outerEventTypeName));
        if (taggedEventTypes != null) {
            for (Map.Entry<String, Pair<EventType, String>> entry : taggedEventTypes.entrySet()) {
                namesAndTypes.put(entry.getKey(), new Pair<EventType, String>(entry.getValue().getFirst(), entry.getValue().getSecond()));
            }
        }
        if (arrayEventTypes != null) {
            for (Map.Entry<String, Pair<EventType, String>> entry : arrayEventTypes.entrySet()) {
                namesAndTypes.put(entry.getKey(), new Pair<EventType, String>(entry.getValue().getFirst(), entry.getValue().getSecond()));
            }
        }
        StreamTypeServiceImpl subselectTypeService = new StreamTypeServiceImpl(namesAndTypes, statementContext.getEngineURI(), true, true);
        ViewResourceDelegateUnverified viewResourceDelegateSubselect = new ViewResourceDelegateUnverified();
        subselect.setFilterSubqueryStreamTypes(subselectTypeService);
        SelectClauseSpecCompiled selectClauseSpec = subselect.getStatementSpecCompiled().getSelectClauseSpec();
        if (selectClauseSpec.getSelectExprList().size() > 0) {
            if (selectClauseSpec.getSelectExprList().size() > 1) {
                throw new ExprValidationException("Subquery multi-column select is not allowed in this context.");
            }
            SelectClauseElementCompiled element = selectClauseSpec.getSelectExprList().get(0);
            if (element instanceof SelectClauseExprCompiledSpec) {
                SelectClauseExprCompiledSpec compiled = (SelectClauseExprCompiledSpec)element;
                ExprNode selectExpression = compiled.getSelectExpression();
                ExprEvaluatorContextStatement evaluatorContextStmt = new ExprEvaluatorContextStatement(statementContext);
                ExprValidationContext validationContext = new ExprValidationContext(subselectTypeService, statementContext.getMethodResolutionService(), viewResourceDelegateSubselect, statementContext.getSchedulingService(), statementContext.getVariableService(), evaluatorContextStmt, statementContext.getEventAdapterService(), statementContext.getStatementName(), statementContext.getStatementId(), statementContext.getAnnotations(), statementContext.getContextDescriptor());
                selectExpression = ExprNodeUtility.getValidatedSubtree(selectExpression, validationContext);
                subselect.setSelectClause(new ExprNode[]{selectExpression});
                subselect.setSelectAsNames(new String[]{compiled.getAssignedName()});
                LinkedList<ExprAggregateNode> aggExprNodes = new LinkedList<ExprAggregateNode>();
                ExprAggregateNodeUtil.getAggregatesBottomUp(selectExpression, aggExprNodes);
                if (aggExprNodes.size() > 0) {
                    for (ExprAggregateNode aggNode : aggExprNodes) {
                        List<Pair<Integer, String>> propertiesNodesAggregated = ExprNodeUtility.getExpressionProperties(aggNode, true);
                        for (Pair<Integer, String> pair : propertiesNodesAggregated) {
                            if (pair.getFirst() == 0) continue;
                            throw new ExprValidationException("Subselect aggregation function cannot aggregate across correlated properties");
                        }
                    }
                    List<Pair<Integer, String>> propertiesNotAggregated = ExprNodeUtility.getExpressionProperties(selectExpression, false);
                    for (Pair<Integer, String> pair : propertiesNotAggregated) {
                        if (pair.getFirst() != 0) continue;
                        throw new ExprValidationException("Subselect properties must all be within aggregation functions");
                    }
                }
            }
        }
    }

    public static List<ExprNode> decomposeCheckAggregation(List<ExprNode> validatedNodes) throws ExprValidationException {
        ArrayList<ExprNode> constituents = new ArrayList<ExprNode>();
        for (ExprNode validated : validatedNodes) {
            if (validated instanceof ExprAndNode) {
                FilterSpecCompiler.recursiveAndConstituents(constituents, validated);
            } else {
                constituents.add(validated);
            }
            LinkedList<ExprAggregateNode> aggregateExprNodes = new LinkedList<ExprAggregateNode>();
            ExprAggregateNodeUtil.getAggregatesBottomUp(validated, aggregateExprNodes);
            if (aggregateExprNodes.isEmpty()) continue;
            throw new ExprValidationException("Aggregation functions not allowed within filters");
        }
        return constituents;
    }

    private static void consolidate(FilterParamExprMap filterParamExprMap, String statementName) {
        boolean haveConsolidated;
        HashMap<Pair<String, FilterOperator>, ArrayList<FilterSpecParam>> mapOfParams = new HashMap<Pair<String, FilterOperator>, ArrayList<FilterSpecParam>>();
        do {
            haveConsolidated = false;
            mapOfParams.clear();
            for (FilterSpecParam currentParam : filterParamExprMap.getFilterParams()) {
                FilterOperator op;
                String propName = currentParam.getPropertyName();
                Pair<String, FilterOperator> key = new Pair<String, FilterOperator>(propName, op = currentParam.getFilterOperator());
                ArrayList<FilterSpecParam> existingParam = (ArrayList<FilterSpecParam>)mapOfParams.get(key);
                if (existingParam == null) {
                    existingParam = new ArrayList<FilterSpecParam>();
                    mapOfParams.put(key, existingParam);
                }
                existingParam.add(currentParam);
            }
            for (List entry : mapOfParams.values()) {
                if (entry.size() <= 1) continue;
                haveConsolidated = true;
                FilterSpecCompiler.consolidate(entry, filterParamExprMap, statementName);
            }
        } while (haveConsolidated);
    }

    private static void handleConsolidateNotEqual(List<FilterSpecParam> params, FilterParamExprMap filterParamExprMap, String statementName) {
        ArrayList<FilterSpecParamInValue> values = new ArrayList<FilterSpecParamInValue>();
        ExprNode lastNotEqualsExprNode = null;
        for (FilterSpecParam param : params) {
            FilterSpecParam eventProp;
            if (param instanceof FilterSpecParamConstant) {
                FilterSpecParamConstant constantParam = (FilterSpecParamConstant)param;
                Object constant = constantParam.getFilterConstant();
                values.add(new InSetOfValuesConstant(constant));
            } else if (param instanceof FilterSpecParamEventProp) {
                eventProp = (FilterSpecParamEventProp)param;
                values.add(new InSetOfValuesEventProp(((FilterSpecParamEventProp)eventProp).getResultEventAsName(), ((FilterSpecParamEventProp)eventProp).getResultEventProperty(), ((FilterSpecParamEventProp)eventProp).isMustCoerce(), JavaClassHelper.getBoxedType(((FilterSpecParamEventProp)eventProp).getCoercionType())));
            } else if (param instanceof FilterSpecParamEventPropIndexed) {
                eventProp = (FilterSpecParamEventPropIndexed)param;
                values.add(new InSetOfValuesEventPropIndexed(((FilterSpecParamEventPropIndexed)eventProp).getResultEventAsName(), ((FilterSpecParamEventPropIndexed)eventProp).getResultEventIndex(), ((FilterSpecParamEventPropIndexed)eventProp).getResultEventProperty(), ((FilterSpecParamEventPropIndexed)eventProp).isMustCoerce(), JavaClassHelper.getBoxedType(((FilterSpecParamEventPropIndexed)eventProp).getCoercionType()), statementName));
            } else {
                throw new IllegalArgumentException("Unknown filter parameter:" + param.toString());
            }
            lastNotEqualsExprNode = filterParamExprMap.removeEntry(param);
        }
        FilterSpecParamIn param = new FilterSpecParamIn(params.get(0).getPropertyName(), FilterOperator.NOT_IN_LIST_OF_VALUES, values);
        filterParamExprMap.put(lastNotEqualsExprNode, param);
    }

    protected static FilterSpecParam makeFilterParam(ExprNode constituent, LinkedHashMap<String, Pair<EventType, String>> taggedEventTypes, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, ExprEvaluatorContext exprEvaluatorContext, String statementName) throws ExprValidationException {
        FilterSpecParam param;
        if ((constituent instanceof ExprEqualsNode || constituent instanceof ExprRelationalOpNode) && (param = FilterSpecCompiler.handleEqualsAndRelOp(constituent, arrayEventTypes, exprEvaluatorContext, statementName)) != null) {
            return param;
        }
        if (constituent instanceof ExprInNode && (param = FilterSpecCompiler.handleInSetNode((ExprInNode)constituent, arrayEventTypes, exprEvaluatorContext, statementName)) != null) {
            return param;
        }
        if (constituent instanceof ExprBetweenNode && (param = FilterSpecCompiler.handleRangeNode((ExprBetweenNode)constituent, arrayEventTypes, exprEvaluatorContext, statementName)) != null) {
            return param;
        }
        return null;
    }

    private static FilterSpecParam handleRangeNode(ExprBetweenNode betweenNode, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, ExprEvaluatorContext exprEvaluatorContext, String statementName) {
        ExprNode left = betweenNode.getChildNodes().get(0);
        if (left instanceof ExprIdentNode) {
            ExprIdentNode identNode = (ExprIdentNode)left;
            String propertyName = identNode.getResolvedPropertyName();
            FilterOperator op = FilterOperator.parseRangeOperator(betweenNode.isLowEndpointIncluded(), betweenNode.isHighEndpointIncluded(), betweenNode.isNotBetween());
            FilterSpecParamRangeValue low = FilterSpecCompiler.handleRangeNodeEndpoint(betweenNode.getChildNodes().get(1), arrayEventTypes, exprEvaluatorContext, statementName);
            FilterSpecParamRangeValue high = FilterSpecCompiler.handleRangeNodeEndpoint(betweenNode.getChildNodes().get(2), arrayEventTypes, exprEvaluatorContext, statementName);
            if (low != null && high != null) {
                return new FilterSpecParamRange(propertyName, op, low, high, identNode.getExprEvaluator().getType());
            }
        }
        return null;
    }

    private static FilterSpecParamRangeValue handleRangeNodeEndpoint(ExprNode endpoint, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, ExprEvaluatorContext exprEvaluatorContext, String statementName) {
        if (endpoint instanceof ExprConstantNode) {
            ExprConstantNode node = (ExprConstantNode)endpoint;
            Object value = node.evaluate(null, true, exprEvaluatorContext);
            if (value instanceof String) {
                return new RangeValueString((String)value);
            }
            return new RangeValueDouble(((Number)value).doubleValue());
        }
        if (endpoint instanceof ExprContextPropertyNode) {
            ExprContextPropertyNode node = (ExprContextPropertyNode)endpoint;
            return new RangeValueContextProp(node.getPropertyName(), node.getGetter());
        }
        if (endpoint instanceof ExprIdentNode) {
            ExprIdentNode identNodeInner = (ExprIdentNode)endpoint;
            if (identNodeInner.getStreamId() == 0) {
                return null;
            }
            if (!arrayEventTypes.isEmpty() && arrayEventTypes.containsKey(identNodeInner.getResolvedStreamName())) {
                Pair<Integer, String> indexAndProp = FilterSpecCompiler.getStreamIndex(identNodeInner.getResolvedPropertyName());
                return new RangeValueEventPropIndexed(identNodeInner.getResolvedStreamName(), indexAndProp.getFirst(), indexAndProp.getSecond(), statementName);
            }
            return new RangeValueEventProp(identNodeInner.getResolvedStreamName(), identNodeInner.getResolvedPropertyName());
        }
        return null;
    }

    private static FilterSpecParam handleInSetNode(ExprInNode constituent, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, ExprEvaluatorContext exprEvaluatorContext, String statementName) throws ExprValidationException {
        ExprNode left = constituent.getChildNodes().get(0);
        if (left instanceof ExprIdentNode) {
            ExprIdentNode identNodeInSet = (ExprIdentNode)left;
            String propertyName = identNodeInSet.getResolvedPropertyName();
            FilterOperator op = FilterOperator.IN_LIST_OF_VALUES;
            if (constituent.isNotIn()) {
                op = FilterOperator.NOT_IN_LIST_OF_VALUES;
            }
            ArrayList<FilterSpecParamInValue> listofValues = new ArrayList<FilterSpecParamInValue>();
            Iterator<ExprNode> it = constituent.getChildNodes().iterator();
            it.next();
            while (it.hasNext()) {
                FilterSpecParamInValue inValue;
                ExprNode subNode = it.next();
                if (subNode instanceof ExprConstantNode) {
                    ExprConstantNode constantNode = (ExprConstantNode)subNode;
                    Object constant = constantNode.evaluate(null, true, exprEvaluatorContext);
                    if (constant instanceof Collection) {
                        return null;
                    }
                    if (constant instanceof Map) {
                        return null;
                    }
                    if (constant != null && constant.getClass().isArray()) {
                        return null;
                    }
                    constant = FilterSpecCompiler.handleConstantsCoercion(identNodeInSet, constant);
                    listofValues.add(new InSetOfValuesConstant(constant));
                }
                if (subNode instanceof ExprContextPropertyNode) {
                    ExprContextPropertyNode contextPropertyNode = (ExprContextPropertyNode)subNode;
                    Class returnType = contextPropertyNode.getType();
                    if (JavaClassHelper.isImplementsInterface(contextPropertyNode.getType(), Collection.class) || JavaClassHelper.isImplementsInterface(contextPropertyNode.getType(), Map.class)) {
                        return null;
                    }
                    if (returnType != null && returnType.getClass().isArray()) {
                        return null;
                    }
                    SimpleNumberCoercer coercer = FilterSpecCompiler.getNumberCoercer(left.getExprEvaluator().getType(), contextPropertyNode.getType(), propertyName);
                    listofValues.add(new InSetOfValuesContextProp(contextPropertyNode.getPropertyName(), contextPropertyNode.getGetter(), coercer));
                }
                if (!(subNode instanceof ExprIdentNode)) continue;
                ExprIdentNode identNodeInner = (ExprIdentNode)subNode;
                if (identNodeInner.getStreamId() == 0) break;
                boolean isMustCoerce = false;
                Class numericCoercionType = JavaClassHelper.getBoxedType(identNodeInSet.getExprEvaluator().getType());
                if (identNodeInner.getExprEvaluator().getType() != identNodeInSet.getExprEvaluator().getType()) {
                    if (!JavaClassHelper.isNumeric(identNodeInSet.getExprEvaluator().getType())) break;
                    if (!JavaClassHelper.canCoerce(identNodeInner.getExprEvaluator().getType(), identNodeInSet.getExprEvaluator().getType())) {
                        FilterSpecCompiler.throwConversionError(identNodeInner.getExprEvaluator().getType(), identNodeInSet.getExprEvaluator().getType(), identNodeInSet.getResolvedPropertyName());
                    }
                    isMustCoerce = true;
                }
                String streamName = identNodeInner.getResolvedStreamName();
                if (!arrayEventTypes.isEmpty() && arrayEventTypes.containsKey(streamName)) {
                    Pair<Integer, String> indexAndProp = FilterSpecCompiler.getStreamIndex(identNodeInner.getResolvedPropertyName());
                    inValue = new InSetOfValuesEventPropIndexed(identNodeInner.getResolvedStreamName(), indexAndProp.getFirst(), indexAndProp.getSecond(), isMustCoerce, numericCoercionType, statementName);
                } else {
                    inValue = new InSetOfValuesEventProp(identNodeInner.getResolvedStreamName(), identNodeInner.getResolvedPropertyName(), isMustCoerce, numericCoercionType);
                }
                listofValues.add(inValue);
            }
            if (listofValues.size() == constituent.getChildNodes().size() - 1) {
                return new FilterSpecParamIn(propertyName, op, listofValues);
            }
        }
        return null;
    }

    private static FilterSpecParam handleEqualsAndRelOp(ExprNode constituent, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, ExprEvaluatorContext exprEvaluatorContext, String statementName) throws ExprValidationException {
        ExprContextPropertyNode ctxNode;
        ExprIdentNode identNodeLeft;
        FilterOperator op;
        if (constituent instanceof ExprEqualsNode) {
            ExprEqualsNode equalsNode = (ExprEqualsNode)constituent;
            if (!equalsNode.isIs()) {
                op = FilterOperator.EQUAL;
                if (equalsNode.isNotEquals()) {
                    op = FilterOperator.NOT_EQUAL;
                }
            } else {
                op = FilterOperator.IS;
                if (equalsNode.isNotEquals()) {
                    op = FilterOperator.IS_NOT;
                }
            }
        } else {
            ExprRelationalOpNode relNode = (ExprRelationalOpNode)constituent;
            if (relNode.getRelationalOpEnum() == RelationalOpEnum.GT) {
                op = FilterOperator.GREATER;
            } else if (relNode.getRelationalOpEnum() == RelationalOpEnum.LT) {
                op = FilterOperator.LESS;
            } else if (relNode.getRelationalOpEnum() == RelationalOpEnum.LE) {
                op = FilterOperator.LESS_OR_EQUAL;
            } else if (relNode.getRelationalOpEnum() == RelationalOpEnum.GE) {
                op = FilterOperator.GREATER_OR_EQUAL;
            } else {
                throw new IllegalStateException("Opertor '" + (Object)((Object)relNode.getRelationalOpEnum()) + "' not mapped");
            }
        }
        ExprNode left = constituent.getChildNodes().get(0);
        ExprNode right = constituent.getChildNodes().get(1);
        if (right instanceof ExprConstantNode && left instanceof ExprIdentNode) {
            ExprIdentNode identNode = (ExprIdentNode)left;
            ExprConstantNode constantNode = (ExprConstantNode)right;
            String propertyName = identNode.getResolvedPropertyName();
            Object constant = constantNode.evaluate(null, true, exprEvaluatorContext);
            constant = FilterSpecCompiler.handleConstantsCoercion(identNode, constant);
            return new FilterSpecParamConstant(propertyName, op, constant);
        }
        if (left instanceof ExprConstantNode && right instanceof ExprIdentNode) {
            ExprIdentNode identNode = (ExprIdentNode)right;
            ExprConstantNode constantNode = (ExprConstantNode)left;
            String propertyName = identNode.getResolvedPropertyName();
            Object constant = constantNode.evaluate(null, true, exprEvaluatorContext);
            constant = FilterSpecCompiler.handleConstantsCoercion(identNode, constant);
            FilterOperator opReversed = op.isComparisonOperator() ? op.reversedRelationalOp() : op;
            return new FilterSpecParamConstant(propertyName, opReversed, constant);
        }
        if (left instanceof ExprIdentNode && right instanceof ExprIdentNode) {
            identNodeLeft = (ExprIdentNode)left;
            ExprIdentNode identNodeRight = (ExprIdentNode)right;
            if (identNodeLeft.getStreamId() == 0 && identNodeRight.getStreamId() != 0) {
                return FilterSpecCompiler.handleProperty(op, identNodeLeft, identNodeRight, arrayEventTypes, statementName);
            }
            if (identNodeRight.getStreamId() == 0 && identNodeLeft.getStreamId() != 0) {
                op = FilterSpecCompiler.getReversedOperator(constituent, op);
                return FilterSpecCompiler.handleProperty(op, identNodeRight, identNodeLeft, arrayEventTypes, statementName);
            }
        }
        if (left instanceof ExprIdentNode && right instanceof ExprContextPropertyNode) {
            identNodeLeft = (ExprIdentNode)left;
            ctxNode = (ExprContextPropertyNode)right;
            if (identNodeLeft.getStreamId() == 0) {
                SimpleNumberCoercer numberCoercer = FilterSpecCompiler.getNumberCoercer(identNodeLeft.getExprEvaluator().getType(), ctxNode.getType(), identNodeLeft.getResolvedPropertyName());
                return new FilterSpecParamContextProp(identNodeLeft.getResolvedPropertyName(), op, ctxNode.getGetter(), numberCoercer);
            }
        }
        if (left instanceof ExprContextPropertyNode && right instanceof ExprIdentNode) {
            ExprIdentNode identNodeRight = (ExprIdentNode)right;
            ctxNode = (ExprContextPropertyNode)left;
            if (identNodeRight.getStreamId() == 0) {
                op = FilterSpecCompiler.getReversedOperator(constituent, op);
                SimpleNumberCoercer numberCoercer = FilterSpecCompiler.getNumberCoercer(identNodeRight.getExprEvaluator().getType(), ctxNode.getType(), identNodeRight.getResolvedPropertyName());
                return new FilterSpecParamContextProp(identNodeRight.getResolvedPropertyName(), op, ctxNode.getGetter(), numberCoercer);
            }
        }
        return null;
    }

    private static FilterOperator getReversedOperator(ExprNode constituent, FilterOperator op) {
        if (!(constituent instanceof ExprRelationalOpNode)) {
            return op;
        }
        ExprRelationalOpNode relNode = (ExprRelationalOpNode)constituent;
        RelationalOpEnum relationalOpEnum = relNode.getRelationalOpEnum();
        if (relationalOpEnum == RelationalOpEnum.GT) {
            return FilterOperator.LESS;
        }
        if (relationalOpEnum == RelationalOpEnum.LT) {
            return FilterOperator.GREATER;
        }
        if (relationalOpEnum == RelationalOpEnum.LE) {
            return FilterOperator.GREATER_OR_EQUAL;
        }
        if (relationalOpEnum == RelationalOpEnum.GE) {
            return FilterOperator.LESS_OR_EQUAL;
        }
        return op;
    }

    private static FilterSpecParam handleProperty(FilterOperator op, ExprIdentNode identNodeLeft, ExprIdentNode identNodeRight, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, String statementName) throws ExprValidationException {
        Class rightType;
        String propertyName = identNodeLeft.getResolvedPropertyName();
        Class leftType = identNodeLeft.getExprEvaluator().getType();
        SimpleNumberCoercer numberCoercer = FilterSpecCompiler.getNumberCoercer(leftType, rightType = identNodeRight.getExprEvaluator().getType(), propertyName);
        boolean isMustCoerce = numberCoercer != null;
        Class numericCoercionType = JavaClassHelper.getBoxedType(leftType);
        String streamName = identNodeRight.getResolvedStreamName();
        if (!arrayEventTypes.isEmpty() && arrayEventTypes.containsKey(streamName)) {
            Pair<Integer, String> indexAndProp = FilterSpecCompiler.getStreamIndex(identNodeRight.getResolvedPropertyName());
            return new FilterSpecParamEventPropIndexed(propertyName, op, identNodeRight.getResolvedStreamName(), indexAndProp.getFirst(), indexAndProp.getSecond(), isMustCoerce, numberCoercer, numericCoercionType, statementName);
        }
        return new FilterSpecParamEventProp(propertyName, op, identNodeRight.getResolvedStreamName(), identNodeRight.getResolvedPropertyName(), isMustCoerce, numberCoercer, numericCoercionType, statementName);
    }

    private static SimpleNumberCoercer getNumberCoercer(Class leftType, Class rightType, String propertyName) throws ExprValidationException {
        Class numericCoercionType = JavaClassHelper.getBoxedType(leftType);
        if (rightType != leftType && JavaClassHelper.isNumeric(rightType)) {
            if (!JavaClassHelper.canCoerce(rightType, leftType)) {
                FilterSpecCompiler.throwConversionError(rightType, leftType, propertyName);
            }
            return SimpleNumberCoercerFactory.getCoercer(rightType, numericCoercionType);
        }
        return null;
    }

    private static Pair<Integer, String> getStreamIndex(String resolvedPropertyName) {
        Property property = PropertyParser.parse(resolvedPropertyName, false);
        if (!(property instanceof NestedProperty)) {
            throw new IllegalStateException("Expected a nested property providing an index for array match '" + resolvedPropertyName + "'");
        }
        NestedProperty nested = (NestedProperty)property;
        if (nested.getProperties().size() < 2) {
            throw new IllegalStateException("Expected a nested property name for array match '" + resolvedPropertyName + "', none found");
        }
        if (!(nested.getProperties().get(0) instanceof IndexedProperty)) {
            throw new IllegalStateException("Expected an indexed property for array match '" + resolvedPropertyName + "', please provide an index");
        }
        int index = ((IndexedProperty)nested.getProperties().get(0)).getIndex();
        nested.getProperties().remove(0);
        StringWriter writer = new StringWriter();
        nested.toPropertyEPL(writer);
        return new Pair<Integer, String>(index, writer.toString());
    }

    private static void throwConversionError(Class fromType, Class toType, String propertyName) throws ExprValidationException {
        String text = "Implicit conversion from datatype '" + fromType.getSimpleName() + "' to '" + toType.getSimpleName() + "' for property '" + propertyName + "' is not allowed (strict filter type coercion)";
        throw new ExprValidationException(text);
    }

    private static Object handleConstantsCoercion(ExprIdentNode identNode, Object constant) throws ExprValidationException {
        Class identNodeType = identNode.getExprEvaluator().getType();
        if (!JavaClassHelper.isNumeric(identNodeType)) {
            return constant;
        }
        if (constant == null) {
            return null;
        }
        if (!JavaClassHelper.canCoerce(constant.getClass(), identNodeType)) {
            FilterSpecCompiler.throwConversionError(constant.getClass(), identNodeType, identNode.getResolvedPropertyName());
        }
        Class identNodeTypeBoxed = JavaClassHelper.getBoxedType(identNodeType);
        return JavaClassHelper.coerceBoxed((Number)constant, identNodeTypeBoxed);
    }

    private static void recursiveAndConstituents(List<ExprNode> constituents, ExprNode exprNode) {
        for (ExprNode inner : exprNode.getChildNodes()) {
            if (inner instanceof ExprAndNode) {
                FilterSpecCompiler.recursiveAndConstituents(constituents, inner);
                continue;
            }
            constituents.add(inner);
        }
    }
}

