/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.filter.FilterOperator;
import com.espertech.esper.filter.FilterSpecParam;
import com.espertech.esper.filter.FilterSpecParamInValue;
import com.espertech.esper.filter.InSetOfValuesContextProp;
import com.espertech.esper.filter.InSetOfValuesEventProp;
import com.espertech.esper.pattern.MatchedEventMap;
import java.util.Arrays;
import java.util.List;

public final class FilterSpecParamIn
extends FilterSpecParam {
    private final List<FilterSpecParamInValue> listOfValues;
    private MultiKeyUntyped inListConstantsOnly;
    private static final long serialVersionUID = 1723225284589047752L;

    public FilterSpecParamIn(String propertyName, FilterOperator filterOperator, List<FilterSpecParamInValue> listofValues) throws IllegalArgumentException {
        super(propertyName, filterOperator);
        this.listOfValues = listofValues;
        boolean isAllConstants = false;
        for (FilterSpecParamInValue value : listofValues) {
            if (!(value instanceof InSetOfValuesEventProp) && !(value instanceof InSetOfValuesContextProp)) continue;
            isAllConstants = false;
            break;
        }
        if (isAllConstants) {
            Object[] constants = new Object[this.listOfValues.size()];
            int count = 0;
            for (FilterSpecParamInValue valuePlaceholder : this.listOfValues) {
                constants[count++] = valuePlaceholder.getFilterValue(null, null);
            }
            this.inListConstantsOnly = new MultiKeyUntyped(constants);
        }
        if (filterOperator != FilterOperator.IN_LIST_OF_VALUES && filterOperator != FilterOperator.NOT_IN_LIST_OF_VALUES) {
            throw new IllegalArgumentException("Illegal filter operator " + (Object)((Object)filterOperator) + " supplied to " + "in-values filter parameter");
        }
    }

    @Override
    public final Object getFilterValue(MatchedEventMap matchedEvents, ExprEvaluatorContext evaluatorContext) {
        if (this.inListConstantsOnly != null) {
            return this.inListConstantsOnly;
        }
        Object[] actualValues = new Object[this.listOfValues.size()];
        int count = 0;
        for (FilterSpecParamInValue valuePlaceholder : this.listOfValues) {
            actualValues[count++] = valuePlaceholder.getFilterValue(matchedEvents, evaluatorContext);
        }
        return new MultiKeyUntyped(actualValues);
    }

    public List<FilterSpecParamInValue> getListOfValues() {
        return this.listOfValues;
    }

    @Override
    public final String toString() {
        return super.toString() + "  in=(listOfValues=" + this.listOfValues.toString() + ')';
    }

    @Override
    public int getFilterHash() {
        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FilterSpecParamIn)) {
            return false;
        }
        FilterSpecParamIn other = (FilterSpecParamIn)obj;
        if (!super.equals(other)) {
            return false;
        }
        if (this.listOfValues.size() != other.listOfValues.size()) {
            return false;
        }
        return Arrays.deepEquals(this.listOfValues.toArray(), other.listOfValues.toArray());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.listOfValues != null ? ((Object)this.listOfValues).hashCode() : 0);
        return result;
    }
}

