/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.filter.DoubleRange;
import com.espertech.esper.filter.FilterOperator;
import com.espertech.esper.filter.FilterSpecParam;
import com.espertech.esper.filter.FilterSpecParamRangeValue;
import com.espertech.esper.filter.StringRange;
import com.espertech.esper.pattern.MatchedEventMap;

public final class FilterSpecParamRange
extends FilterSpecParam {
    private final FilterSpecParamRangeValue min;
    private final FilterSpecParamRangeValue max;
    private final Class type;
    private static final long serialVersionUID = -3381167844631490119L;

    public FilterSpecParamRange(String propertyName, FilterOperator filterOperator, FilterSpecParamRangeValue min, FilterSpecParamRangeValue max, Class type) throws IllegalArgumentException {
        super(propertyName, filterOperator);
        this.min = min;
        this.max = max;
        this.type = type;
        if (!filterOperator.isRangeOperator() && !filterOperator.isInvertedRangeOperator()) {
            throw new IllegalArgumentException("Illegal filter operator " + (Object)((Object)filterOperator) + " supplied to " + "range filter parameter");
        }
    }

    @Override
    public final Object getFilterValue(MatchedEventMap matchedEvents, ExprEvaluatorContext evaluatorContext) {
        if (this.type == String.class) {
            return new StringRange((String)this.min.getFilterValue(matchedEvents, evaluatorContext), (String)this.max.getFilterValue(matchedEvents, evaluatorContext));
        }
        Double begin = (Double)this.min.getFilterValue(matchedEvents, evaluatorContext);
        Double end = (Double)this.max.getFilterValue(matchedEvents, evaluatorContext);
        return new DoubleRange(begin, end);
    }

    public FilterSpecParamRangeValue getMin() {
        return this.min;
    }

    public FilterSpecParamRangeValue getMax() {
        return this.max;
    }

    @Override
    public final String toString() {
        return super.toString() + "  range=(min=" + this.min.toString() + ",max=" + this.max.toString() + ')';
    }

    @Override
    public int getFilterHash() {
        return this.min.getFilterHash() + 31 * this.max.getFilterHash();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FilterSpecParamRange)) {
            return false;
        }
        FilterSpecParamRange other = (FilterSpecParamRange)obj;
        if (!super.equals(other)) {
            return false;
        }
        return this.min.equals(other.min) && this.max.equals(other.max);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
        result = 31 * result + (this.max != null ? this.max.hashCode() : 0);
        return result;
    }
}

