/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventType;
import com.espertech.esper.filter.FilterOperator;
import com.espertech.esper.filter.FilterParamIndexBase;
import com.espertech.esper.filter.FilterParamIndexBooleanExpr;
import com.espertech.esper.filter.FilterParamIndexCompare;
import com.espertech.esper.filter.FilterParamIndexCompareString;
import com.espertech.esper.filter.FilterParamIndexDoubleRange;
import com.espertech.esper.filter.FilterParamIndexDoubleRangeInverted;
import com.espertech.esper.filter.FilterParamIndexEquals;
import com.espertech.esper.filter.FilterParamIndexEqualsIs;
import com.espertech.esper.filter.FilterParamIndexIn;
import com.espertech.esper.filter.FilterParamIndexNotEquals;
import com.espertech.esper.filter.FilterParamIndexNotEqualsIs;
import com.espertech.esper.filter.FilterParamIndexNotIn;
import com.espertech.esper.filter.FilterParamIndexPropBase;
import com.espertech.esper.filter.FilterParamIndexStringRange;
import com.espertech.esper.filter.FilterParamIndexStringRangeInverted;

public class IndexFactory {
    public static FilterParamIndexBase createIndex(EventType eventType, String propertyName, FilterOperator filterOperator) {
        if (filterOperator == FilterOperator.EQUAL) {
            FilterParamIndexEquals index = new FilterParamIndexEquals(propertyName, eventType);
            return index;
        }
        if (filterOperator == FilterOperator.NOT_EQUAL) {
            FilterParamIndexNotEquals index = new FilterParamIndexNotEquals(propertyName, eventType);
            return index;
        }
        if (filterOperator == FilterOperator.IS) {
            FilterParamIndexEqualsIs index = new FilterParamIndexEqualsIs(propertyName, eventType);
            return index;
        }
        if (filterOperator == FilterOperator.IS_NOT) {
            FilterParamIndexNotEqualsIs index = new FilterParamIndexNotEqualsIs(propertyName, eventType);
            return index;
        }
        if (filterOperator == FilterOperator.GREATER || filterOperator == FilterOperator.GREATER_OR_EQUAL || filterOperator == FilterOperator.LESS || filterOperator == FilterOperator.LESS_OR_EQUAL) {
            Class type = eventType.getPropertyType(propertyName);
            FilterParamIndexPropBase index = type != String.class ? new FilterParamIndexCompare(propertyName, filterOperator, eventType) : new FilterParamIndexCompareString(propertyName, filterOperator, eventType);
            return index;
        }
        if (filterOperator.isRangeOperator()) {
            Class type = eventType.getPropertyType(propertyName);
            FilterParamIndexPropBase index = type != String.class ? new FilterParamIndexDoubleRange(propertyName, filterOperator, eventType) : new FilterParamIndexStringRange(propertyName, filterOperator, eventType);
            return index;
        }
        if (filterOperator.isInvertedRangeOperator()) {
            Class type = eventType.getPropertyType(propertyName);
            if (type != String.class) {
                return new FilterParamIndexDoubleRangeInverted(propertyName, filterOperator, eventType);
            }
            return new FilterParamIndexStringRangeInverted(propertyName, filterOperator, eventType);
        }
        if (filterOperator == FilterOperator.IN_LIST_OF_VALUES) {
            return new FilterParamIndexIn(propertyName, eventType);
        }
        if (filterOperator == FilterOperator.NOT_IN_LIST_OF_VALUES) {
            return new FilterParamIndexNotIn(propertyName, eventType);
        }
        if (filterOperator == FilterOperator.BOOLEAN_EXPRESSION) {
            return new FilterParamIndexBooleanExpr();
        }
        throw new IllegalArgumentException("Cannot create filter index instance for filter operator " + (Object)((Object)filterOperator));
    }
}

