/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.filter.FilterSpecParamRangeValue;
import com.espertech.esper.pattern.MatchedEventMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RangeValueEventPropIndexed
implements FilterSpecParamRangeValue {
    private static final Log log = LogFactory.getLog(RangeValueEventPropIndexed.class);
    private final String resultEventAsName;
    private final int resultEventIndex;
    private final String resultEventProperty;
    private final String statementName;
    private static final long serialVersionUID = -2443484252813342579L;

    public RangeValueEventPropIndexed(String resultEventAsName, int resultEventIndex, String resultEventProperty, String statementName) {
        this.resultEventAsName = resultEventAsName;
        this.resultEventIndex = resultEventIndex;
        this.resultEventProperty = resultEventProperty;
        this.statementName = statementName;
    }

    @Override
    public int getFilterHash() {
        return this.resultEventProperty.hashCode();
    }

    public int getResultEventIndex() {
        return this.resultEventIndex;
    }

    @Override
    public final Double getFilterValue(MatchedEventMap matchedEvents, ExprEvaluatorContext exprEvaluatorContext) {
        EventBean[] events = (EventBean[])matchedEvents.getMatchingEventAsObject(this.resultEventAsName);
        if (events == null) {
            log.warn((Object)("Matching events for tag '" + this.resultEventAsName + "' returned a null result, using null value in filter criteria, for statement '" + this.statementName + "'"));
            return null;
        }
        if (this.resultEventIndex > events.length - 1) {
            log.warn((Object)("Matching events for tag '" + this.resultEventAsName + "' returned no result for index " + this.resultEventIndex + " at array length " + events.length + ", using null value in filter criteria, for statement '" + this.statementName + "'"));
            return null;
        }
        Number value = (Number)events[this.resultEventIndex].get(this.resultEventProperty);
        if (value == null) {
            return null;
        }
        return value.doubleValue();
    }

    public String getResultEventAsName() {
        return this.resultEventAsName;
    }

    public String getResultEventProperty() {
        return this.resultEventProperty;
    }

    public final String toString() {
        return "resultEventProp=" + this.resultEventAsName + '.' + this.resultEventProperty;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RangeValueEventPropIndexed)) {
            return false;
        }
        RangeValueEventPropIndexed other = (RangeValueEventPropIndexed)obj;
        return other.resultEventAsName.equals(this.resultEventAsName) && other.resultEventProperty.equals(this.resultEventProperty) && other.resultEventIndex == this.resultEventIndex;
    }

    public int hashCode() {
        return this.resultEventProperty.hashCode();
    }
}

