/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.pattern.EvalAndNode;
import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalStateNode;
import com.espertech.esper.pattern.EvalStateNodeVisitor;
import com.espertech.esper.pattern.Evaluator;
import com.espertech.esper.pattern.MatchedEventMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EvalAndStateNode
extends EvalStateNode
implements Evaluator {
    private final EvalAndNode evalAndNode;
    private final List<EvalStateNode> activeChildNodes;
    private Map<EvalStateNode, List<MatchedEventMap>> eventsPerChild;
    private static final Log log = LogFactory.getLog(EvalAndStateNode.class);

    public EvalAndStateNode(Evaluator parentNode, EvalAndNode evalAndNode, MatchedEventMap beginState) {
        super(parentNode, null);
        this.evalAndNode = evalAndNode;
        this.activeChildNodes = new LinkedList<EvalStateNode>();
        this.eventsPerChild = new HashMap<EvalStateNode, List<MatchedEventMap>>();
        for (EvalNode node : evalAndNode.getChildNodes()) {
            EvalStateNode childState = node.newState(this, beginState, null);
            this.activeChildNodes.add(childState);
        }
    }

    @Override
    public EvalNode getFactoryNode() {
        return this.evalAndNode;
    }

    @Override
    public final void start() {
        EvalStateNode[] activeChildNodesArray;
        if (this.activeChildNodes.size() < 2) {
            throw new IllegalStateException("AND state node is inactive");
        }
        for (EvalStateNode child : activeChildNodesArray = this.activeChildNodes.toArray(new EvalStateNode[this.activeChildNodes.size()])) {
            child.start();
        }
    }

    @Override
    public boolean isFilterStateNode() {
        return false;
    }

    @Override
    public boolean isNotOperator() {
        return false;
    }

    @Override
    public boolean isFilterChildNonQuitting() {
        return false;
    }

    @Override
    public final void evaluateTrue(MatchedEventMap matchEvent, EvalStateNode fromNode, boolean isQuitted) {
        if (isQuitted) {
            this.activeChildNodes.remove(fromNode);
        }
        if (this.eventsPerChild == null) {
            return;
        }
        List<MatchedEventMap> eventList = this.eventsPerChild.get(fromNode);
        if (eventList == null) {
            eventList = new LinkedList<MatchedEventMap>();
            this.eventsPerChild.put(fromNode, eventList);
        }
        eventList.add(matchEvent);
        if (this.eventsPerChild.size() < this.evalAndNode.getChildNodes().length) {
            return;
        }
        List<MatchedEventMap> result = EvalAndStateNode.generateMatchEvents(matchEvent, fromNode, this.eventsPerChild);
        boolean quitted = true;
        if (!this.activeChildNodes.isEmpty()) {
            for (EvalStateNode stateNode : this.activeChildNodes) {
                if (stateNode.isNotOperator()) continue;
                quitted = false;
            }
        }
        if (quitted) {
            this.quit();
        }
        for (MatchedEventMap event : result) {
            this.getParentEvaluator().evaluateTrue(event, this, quitted);
        }
    }

    @Override
    public final void evaluateFalse(EvalStateNode fromNode) {
        if (this.eventsPerChild != null) {
            this.eventsPerChild.remove(fromNode);
        }
        this.getParentEvaluator().evaluateFalse(this);
        this.quit();
    }

    protected static List<MatchedEventMap> generateMatchEvents(MatchedEventMap matchEvent, EvalStateNode fromNode, Map<EvalStateNode, List<MatchedEventMap>> eventsPerChild) {
        ArrayList<List<MatchedEventMap>> listArray = new ArrayList<List<MatchedEventMap>>();
        int index = 0;
        for (Map.Entry<EvalStateNode, List<MatchedEventMap>> entry : eventsPerChild.entrySet()) {
            if (fromNode == entry.getKey()) continue;
            listArray.add(index++, entry.getValue());
        }
        LinkedList<MatchedEventMap> results = new LinkedList<MatchedEventMap>();
        EvalAndStateNode.generateMatchEvents(listArray, 0, results, matchEvent);
        return results;
    }

    protected static void generateMatchEvents(ArrayList<List<MatchedEventMap>> eventList, int index, List<MatchedEventMap> result, MatchedEventMap matchEvent) {
        List<MatchedEventMap> events = eventList.get(index);
        for (MatchedEventMap event : events) {
            MatchedEventMap current = matchEvent.shallowCopy();
            current.merge(event);
            if (index + 1 == eventList.size()) {
                result.add(current);
                continue;
            }
            EvalAndStateNode.generateMatchEvents(eventList, index + 1, result, current);
        }
    }

    @Override
    public final void quit() {
        for (EvalStateNode child : this.activeChildNodes) {
            child.quit();
        }
        this.activeChildNodes.clear();
        this.eventsPerChild = null;
    }

    @Override
    public final Object accept(EvalStateNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public final Object childrenAccept(EvalStateNodeVisitor visitor, Object data) {
        for (EvalStateNode node : this.activeChildNodes) {
            node.accept(visitor, data);
        }
        return data;
    }

    public final String toString() {
        return "EvalAndStateNode nodes=" + this.activeChildNodes.size();
    }
}

