/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.pattern.EvalAuditStateNode;
import com.espertech.esper.pattern.EvalFactoryNode;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EvalAuditInstanceCount {
    private static final Log auditLog = LogFactory.getLog((String)"com.espertech.esper.audit");
    private final Map<EvalFactoryNode, Integer> counts = new HashMap<EvalFactoryNode, Integer>();

    public void decreaseRefCount(EvalFactoryNode evalNode, EvalAuditStateNode current, String patternExpr, String statementName) {
        Integer count = this.counts.get(evalNode);
        if (count == null) {
            return;
        }
        Integer n = count;
        Integer n2 = count = Integer.valueOf(count - 1);
        if (count <= 0) {
            this.counts.remove(evalNode);
            EvalAuditInstanceCount.print(current, patternExpr, statementName, false, 0);
            return;
        }
        this.counts.put(evalNode, count);
        EvalAuditInstanceCount.print(current, patternExpr, statementName, false, count);
    }

    public void increaseRefCount(EvalFactoryNode evalNode, EvalAuditStateNode current, String patternExpr, String statementName) {
        Integer count = this.counts.get(evalNode);
        if (count == null) {
            count = 1;
        } else {
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
        }
        this.counts.put(evalNode, count);
        EvalAuditInstanceCount.print(current, patternExpr, statementName, true, count);
    }

    private static void print(EvalAuditStateNode current, String patternExpression, String statementName, boolean added, int count) {
        if (!auditLog.isInfoEnabled()) {
            return;
        }
        StringWriter writer = new StringWriter();
        writer.write("Statement ");
        writer.write(statementName);
        writer.write(" pattern-instance ");
        EvalAuditStateNode.writePatternExpr(current, patternExpression, writer);
        if (added) {
            writer.write(" increased to " + count);
        } else {
            writer.write(" decreased to " + count);
        }
        auditLog.info((Object)writer.toString());
    }
}

