/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.pattern.EvalAuditNode;
import com.espertech.esper.pattern.EvalFilterNode;
import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalNotNode;
import com.espertech.esper.pattern.EvalStateNode;
import com.espertech.esper.pattern.EvalStateNodeVisitor;
import com.espertech.esper.pattern.Evaluator;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EvalAuditStateNode
extends EvalStateNode
implements Evaluator {
    private static final Log auditLog = LogFactory.getLog((String)"com.espertech.esper.audit");
    private final EvalAuditNode evalAuditNode;
    private EvalStateNode childState;
    private static final Log log = LogFactory.getLog(EvalAuditStateNode.class);

    public EvalAuditStateNode(Evaluator parentNode, EvalAuditNode evalAuditNode, MatchedEventMap beginState) {
        super(parentNode, null);
        EvalStateNode childState;
        this.evalAuditNode = evalAuditNode;
        EvalNode child = evalAuditNode.getChildNode();
        this.childState = childState = child.newState(this, beginState, null);
    }

    @Override
    public EvalNode getFactoryNode() {
        return this.evalAuditNode;
    }

    @Override
    public final void start() {
        this.childState.start();
        this.evalAuditNode.getFactoryNode().increaseRefCount(this, this.evalAuditNode.getContext().getPatternContext());
    }

    @Override
    public final void evaluateTrue(MatchedEventMap matchEvent, EvalStateNode fromNode, boolean isQuitted) {
        if (this.evalAuditNode.getFactoryNode().isAuditPattern() && auditLog.isInfoEnabled()) {
            auditLog.info((Object)EvalAuditStateNode.toStringEvaluateTrue(this, this.evalAuditNode.getFactoryNode().getPatternExpr(), this.evalAuditNode.getContext().getPatternContext().getStatementName(), matchEvent, fromNode, isQuitted));
        }
        if (isQuitted) {
            this.childState = null;
            this.evalAuditNode.getFactoryNode().decreaseRefCount(this, this.evalAuditNode.getContext().getPatternContext());
        }
        this.getParentEvaluator().evaluateTrue(matchEvent, this, isQuitted);
    }

    @Override
    public final void evaluateFalse(EvalStateNode fromNode) {
        if (this.evalAuditNode.getFactoryNode().isAuditPattern() && auditLog.isInfoEnabled()) {
            auditLog.info((Object)this.toStringEvaluateFalse(this, this.evalAuditNode.getFactoryNode().getPatternExpr(), this.evalAuditNode.getContext().getPatternContext().getStatementName(), fromNode));
        }
        this.getParentEvaluator().evaluateFalse(this);
    }

    @Override
    public final void quit() {
        if (this.childState != null) {
            this.childState.quit();
        }
        this.childState = null;
        this.evalAuditNode.getFactoryNode().decreaseRefCount(this, this.evalAuditNode.getContext().getPatternContext());
    }

    @Override
    public final Object accept(EvalStateNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public final Object childrenAccept(EvalStateNodeVisitor visitor, Object data) {
        if (this.childState != null) {
            this.childState.accept(visitor, data);
        }
        return data;
    }

    public final String toString() {
        return "EvalAuditStateNode";
    }

    @Override
    public boolean isNotOperator() {
        EvalNode evalNode = this.evalAuditNode.getChildNode();
        return evalNode instanceof EvalNotNode;
    }

    @Override
    public boolean isFilterChildNonQuitting() {
        return this.evalAuditNode.getFactoryNode().isFilterChildNonQuitting();
    }

    @Override
    public boolean isFilterStateNode() {
        return this.evalAuditNode.getChildNode() instanceof EvalFilterNode;
    }

    private static String toStringEvaluateTrue(EvalAuditStateNode current, String patternExpression, String statementName, MatchedEventMap matchEvent, EvalStateNode fromNode, boolean isQuitted) {
        StringWriter writer = new StringWriter();
        writer.write("Statement ");
        writer.write(statementName);
        writer.write(" pattern ");
        EvalAuditStateNode.writePatternExpr(current, patternExpression, writer);
        writer.write(" evaluate-true {");
        writer.write(" from: ");
        JavaClassHelper.writeInstance(writer, fromNode, false);
        writer.write(" map: {");
        String delimiter = "";
        Iterator i$ = matchEvent.getMatchingEvents().entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry entryObj;
            Map.Entry entry = entryObj = i$.next();
            writer.write(delimiter);
            writer.write((String)entry.getKey());
            writer.write("=");
            if (entry.getValue() instanceof EventBean) {
                writer.write(((EventBean)entry.getValue()).getUnderlying().toString());
            } else if (entry.getValue() instanceof EventBean[]) {
                writer.write(EventBeanUtility.summarize((EventBean[])entry.getValue()));
            }
            delimiter = ", ";
        }
        writer.write("} quitted: ");
        writer.write(Boolean.toString(isQuitted));
        writer.write("}");
        return writer.toString();
    }

    private String toStringEvaluateFalse(EvalAuditStateNode current, String patternExpression, String statementName, EvalStateNode fromNode) {
        StringWriter writer = new StringWriter();
        writer.write("Statement ");
        writer.write(statementName);
        writer.write(" pattern ");
        EvalAuditStateNode.writePatternExpr(current, patternExpression, writer);
        writer.write(" evaluate-false {");
        writer.write(" from ");
        JavaClassHelper.writeInstance(writer, fromNode, false);
        writer.write("}");
        return writer.toString();
    }

    protected static void writePatternExpr(EvalAuditStateNode current, String patternExpression, StringWriter writer) {
        if (patternExpression != null) {
            writer.write(40);
            writer.write(patternExpression);
            writer.write(41);
        } else {
            JavaClassHelper.writeInstance(writer, "subexr", current);
        }
    }
}

