/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.pattern.EvalEveryDistinctNode;
import com.espertech.esper.pattern.EvalEveryNode;
import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalNodeFactoryBase;
import com.espertech.esper.pattern.EvalNodeUtil;
import com.espertech.esper.pattern.MatchedEventConvertor;
import com.espertech.esper.pattern.PatternAgentInstanceContext;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EvalEveryDistinctFactoryNode
extends EvalNodeFactoryBase {
    protected List<ExprNode> expressions;
    protected transient ExprEvaluator[] expressionsArray;
    private transient MatchedEventConvertor convertor;
    private Long msecToExpire;
    private static final long serialVersionUID = 7455570958072753956L;
    private static final Log log = LogFactory.getLog(EvalEveryNode.class);

    protected EvalEveryDistinctFactoryNode(List<ExprNode> expressions) {
        this.expressions = expressions;
    }

    @Override
    public EvalNode makeEvalNode(PatternAgentInstanceContext agentInstanceContext) {
        if (this.expressionsArray == null) {
            this.expressionsArray = ExprNodeUtility.getEvaluators(this.expressions);
        }
        EvalNode child = EvalNodeUtil.makeEvalNodeSingleChild(this.getChildNodes(), agentInstanceContext);
        return new EvalEveryDistinctNode(this, child, agentInstanceContext);
    }

    public ExprEvaluator[] getExpressionsArray() {
        return this.expressionsArray;
    }

    public MatchedEventConvertor getConvertor() {
        return this.convertor;
    }

    public Long getMsecToExpire() {
        return this.msecToExpire;
    }

    public final String toString() {
        return "EvalEveryNode children=" + this.getChildNodes().size();
    }

    public List<ExprNode> getExpressions() {
        return this.expressions;
    }

    public void setConvertor(MatchedEventConvertor convertor) {
        this.convertor = convertor;
    }

    public void setExpressions(List<ExprNode> expressions, Long msecToExpire) {
        this.expressions = expressions;
        this.msecToExpire = msecToExpire;
    }

    @Override
    public boolean isFilterChildNonQuitting() {
        return true;
    }
}

