/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.pattern.EvalEveryDistinctNode;
import com.espertech.esper.pattern.EvalEveryStateNode;
import com.espertech.esper.pattern.EvalEveryStateSpawnEvaluator;
import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalStateNode;
import com.espertech.esper.pattern.EvalStateNodeVisitor;
import com.espertech.esper.pattern.Evaluator;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.pattern.PatternExpressionUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EvalEveryDistinctStateExpireKeyNode
extends EvalStateNode
implements Evaluator {
    private final EvalEveryDistinctNode everyNode;
    private final Map<EvalStateNode, LinkedHashMap<MultiKeyUntyped, Long>> spawnedNodes;
    private final MatchedEventMap beginState;
    private static final Log log = LogFactory.getLog(EvalEveryStateNode.class);

    public EvalEveryDistinctStateExpireKeyNode(Evaluator parentNode, EvalEveryDistinctNode everyNode, MatchedEventMap beginState) {
        super(parentNode, null);
        this.everyNode = everyNode;
        this.spawnedNodes = new LinkedHashMap<EvalStateNode, LinkedHashMap<MultiKeyUntyped, Long>>();
        this.beginState = beginState.shallowCopy();
        EvalStateNode child = everyNode.getChildNode().newState(this, beginState, null);
        this.spawnedNodes.put(child, new LinkedHashMap());
    }

    @Override
    public EvalNode getFactoryNode() {
        return this.everyNode;
    }

    @Override
    public final void start() {
        if (this.spawnedNodes.size() != 1) {
            throw new IllegalStateException("EVERY state node is expected to have single child state node");
        }
        EvalEveryStateSpawnEvaluator spawnEvaluator = new EvalEveryStateSpawnEvaluator(this.everyNode.getContext().getPatternContext().getStatementName());
        EvalStateNode child = this.spawnedNodes.keySet().iterator().next();
        child.setParentEvaluator(spawnEvaluator);
        child.start();
        if (spawnEvaluator.isEvaluatedTrue()) {
            child.quit();
        } else {
            child.setParentEvaluator(this);
        }
    }

    @Override
    public final void evaluateFalse(EvalStateNode fromNode) {
        fromNode.quit();
        this.spawnedNodes.remove(fromNode);
        EvalEveryStateSpawnEvaluator spawnEvaluator = new EvalEveryStateSpawnEvaluator(this.everyNode.getContext().getPatternContext().getStatementName());
        EvalStateNode spawned = this.everyNode.getChildNode().newState(spawnEvaluator, this.beginState, null);
        spawned.start();
        if (spawnEvaluator.isEvaluatedTrue()) {
            spawned.quit();
        } else {
            this.spawnedNodes.put(spawned, new LinkedHashMap());
            spawned.setParentEvaluator(this);
        }
    }

    @Override
    public final void evaluateTrue(MatchedEventMap matchEvent, EvalStateNode fromNode, boolean isQuitted) {
        MultiKeyUntyped matchEventKey = PatternExpressionUtil.getKeys(matchEvent, this.everyNode);
        boolean haveSeenThis = false;
        LinkedHashMap<MultiKeyUntyped, Long> keysFromNode = this.spawnedNodes.get(fromNode);
        if (keysFromNode != null) {
            Map.Entry<MultiKeyUntyped, Long> entry;
            Iterator<Map.Entry<MultiKeyUntyped, Long>> it = keysFromNode.entrySet().iterator();
            long currentTime = this.everyNode.getContext().getPatternContext().getTimeProvider().getTime();
            while (it.hasNext() && currentTime - (entry = it.next()).getValue() >= this.everyNode.getFactoryNode().getMsecToExpire()) {
                it.remove();
            }
            if (keysFromNode.containsKey(matchEventKey)) {
                haveSeenThis = true;
            } else {
                keysFromNode.put(matchEventKey, currentTime);
            }
        }
        if (isQuitted) {
            this.spawnedNodes.remove(fromNode);
        }
        if (!fromNode.isFilterStateNode()) {
            EvalEveryStateSpawnEvaluator spawnEvaluator = new EvalEveryStateSpawnEvaluator(this.everyNode.getContext().getPatternContext().getStatementName());
            EvalStateNode spawned = this.everyNode.getChildNode().newState(spawnEvaluator, this.beginState, null);
            spawned.start();
            if (spawnEvaluator.isEvaluatedTrue()) {
                spawned.quit();
            } else {
                LinkedHashMap<MultiKeyUntyped, Long> keyset = new LinkedHashMap<MultiKeyUntyped, Long>();
                if (keysFromNode != null) {
                    keyset.putAll(keysFromNode);
                }
                this.spawnedNodes.put(spawned, keyset);
                spawned.setParentEvaluator(this);
            }
        }
        if (!haveSeenThis) {
            this.getParentEvaluator().evaluateTrue(matchEvent, this, false);
        }
    }

    @Override
    public final void quit() {
        for (EvalStateNode child : this.spawnedNodes.keySet()) {
            child.quit();
        }
    }

    @Override
    public final Object accept(EvalStateNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public final Object childrenAccept(EvalStateNodeVisitor visitor, Object data) {
        for (EvalStateNode spawnedNode : this.spawnedNodes.keySet()) {
            spawnedNode.accept(visitor, data);
        }
        return data;
    }

    @Override
    public boolean isNotOperator() {
        return false;
    }

    @Override
    public boolean isFilterStateNode() {
        return false;
    }

    @Override
    public boolean isFilterChildNonQuitting() {
        return true;
    }

    public final String toString() {
        return "EvalEveryStateNode spawnedChildren=" + this.spawnedNodes.size();
    }
}

