/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.pattern.EvalEveryNode;
import com.espertech.esper.pattern.EvalEveryStateSpawnEvaluator;
import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalStateNode;
import com.espertech.esper.pattern.EvalStateNodeVisitor;
import com.espertech.esper.pattern.Evaluator;
import com.espertech.esper.pattern.MatchedEventMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EvalEveryStateNode
extends EvalStateNode
implements Evaluator {
    private final EvalEveryNode evalEveryNode;
    private final List<EvalStateNode> spawnedNodes;
    private final MatchedEventMap beginState;
    private static final Log log = LogFactory.getLog(EvalEveryStateNode.class);

    public EvalEveryStateNode(Evaluator parentNode, EvalEveryNode evalEveryNode, MatchedEventMap beginState) {
        super(parentNode, null);
        this.evalEveryNode = evalEveryNode;
        this.spawnedNodes = new LinkedList<EvalStateNode>();
        this.beginState = beginState.shallowCopy();
        EvalStateNode child = evalEveryNode.getChildNode().newState(this, beginState, null);
        this.spawnedNodes.add(child);
    }

    @Override
    public EvalNode getFactoryNode() {
        return this.evalEveryNode;
    }

    @Override
    public final void start() {
        if (this.spawnedNodes.size() != 1) {
            throw new IllegalStateException("EVERY state node is expected to have single child state node");
        }
        EvalEveryStateSpawnEvaluator spawnEvaluator = new EvalEveryStateSpawnEvaluator(this.evalEveryNode.getContext().getPatternContext().getStatementName());
        EvalStateNode child = this.spawnedNodes.get(0);
        child.setParentEvaluator(spawnEvaluator);
        child.start();
        if (spawnEvaluator.isEvaluatedTrue()) {
            child.quit();
        } else {
            child.setParentEvaluator(this);
        }
    }

    @Override
    public final void evaluateFalse(EvalStateNode fromNode) {
        fromNode.quit();
        this.spawnedNodes.remove(fromNode);
        EvalEveryStateSpawnEvaluator spawnEvaluator = new EvalEveryStateSpawnEvaluator(this.evalEveryNode.getContext().getPatternContext().getStatementName());
        EvalStateNode spawned = this.evalEveryNode.getChildNode().newState(spawnEvaluator, this.beginState, null);
        spawned.start();
        if (spawnEvaluator.isEvaluatedTrue()) {
            spawned.quit();
        } else {
            this.spawnedNodes.add(spawned);
            spawned.setParentEvaluator(this);
        }
    }

    @Override
    public final void evaluateTrue(MatchedEventMap matchEvent, EvalStateNode fromNode, boolean isQuitted) {
        if (isQuitted) {
            this.spawnedNodes.remove(fromNode);
        }
        if (!fromNode.isFilterStateNode()) {
            EvalEveryStateSpawnEvaluator spawnEvaluator = new EvalEveryStateSpawnEvaluator(this.evalEveryNode.getContext().getPatternContext().getStatementName());
            EvalStateNode spawned = this.evalEveryNode.getChildNode().newState(spawnEvaluator, this.beginState, null);
            spawned.start();
            if (spawnEvaluator.isEvaluatedTrue()) {
                spawned.quit();
            } else {
                this.spawnedNodes.add(spawned);
                spawned.setParentEvaluator(this);
            }
        }
        this.getParentEvaluator().evaluateTrue(matchEvent, this, false);
    }

    @Override
    public final void quit() {
        for (EvalStateNode child : this.spawnedNodes) {
            child.quit();
        }
    }

    @Override
    public final Object accept(EvalStateNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public final Object childrenAccept(EvalStateNodeVisitor visitor, Object data) {
        for (EvalStateNode spawnedNode : this.spawnedNodes) {
            spawnedNode.accept(visitor, data);
        }
        return data;
    }

    @Override
    public boolean isNotOperator() {
        return false;
    }

    @Override
    public boolean isFilterStateNode() {
        return false;
    }

    @Override
    public boolean isFilterChildNonQuitting() {
        return true;
    }

    public final String toString() {
        return "EvalEveryStateNode spawnedChildren=" + this.spawnedNodes.size();
    }
}

