/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.filter.FilterHandleCallback;
import com.espertech.esper.filter.FilterService;
import com.espertech.esper.filter.FilterValueSet;
import com.espertech.esper.pattern.EvalFilterNode;
import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalStateNode;
import com.espertech.esper.pattern.EvalStateNodeVisitor;
import com.espertech.esper.pattern.Evaluator;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.pattern.PatternContext;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EvalFilterStateNode
extends EvalStateNode
implements FilterHandleCallback {
    private final EvalFilterNode evalFilterNode;
    private final MatchedEventMap beginState;
    private boolean isStarted;
    private EPStatementHandleCallback handle;
    private static final Log log = LogFactory.getLog(EvalFilterStateNode.class);

    public EvalFilterStateNode(Evaluator parentNode, EvalFilterNode evalFilterNode, MatchedEventMap beginState) {
        super(parentNode, null);
        this.evalFilterNode = evalFilterNode;
        this.beginState = beginState;
    }

    @Override
    public EvalNode getFactoryNode() {
        return this.evalFilterNode;
    }

    @Override
    public String getStatementId() {
        return this.evalFilterNode.getContext().getPatternContext().getStatementId();
    }

    @Override
    public final void start() {
        if (this.isStarted) {
            throw new IllegalStateException("Filter state node already active");
        }
        this.isStarted = true;
        this.startFiltering();
    }

    @Override
    public final void quit() {
        this.isStarted = false;
        this.stopFiltering();
    }

    private void evaluateTrue(MatchedEventMap event, boolean isQuitted) {
        this.getParentEvaluator().evaluateTrue(event, this, isQuitted);
    }

    public EvalFilterNode getEvalFilterNode() {
        return this.evalFilterNode;
    }

    @Override
    public void matchFound(EventBean event, Collection<FilterHandleCallback> allStmtMatches) {
        if (!this.isStarted) {
            return;
        }
        MatchedEventMap passUp = this.beginState.shallowCopy();
        if (this.evalFilterNode.getFactoryNode().getFilterSpec().getOptionalPropertyEvaluator() != null) {
            EventBean[] propertyEvents = this.evalFilterNode.getFactoryNode().getFilterSpec().getOptionalPropertyEvaluator().getProperty(event, this.evalFilterNode.getContext().getAgentInstanceContext());
            if (propertyEvents == null) {
                return;
            }
            if (this.evalFilterNode.getFactoryNode().getEventAsName() != null) {
                passUp.add(this.evalFilterNode.getFactoryNode().getEventAsName(), propertyEvents);
            }
        } else if (this.evalFilterNode.getFactoryNode().getEventAsName() != null) {
            passUp.add(this.evalFilterNode.getFactoryNode().getEventAsName(), event);
        }
        boolean isQuitted = false;
        if (!this.getParentEvaluator().isFilterChildNonQuitting()) {
            this.stopFiltering();
            isQuitted = true;
        }
        this.evaluateTrue(passUp, isQuitted);
    }

    @Override
    public final Object accept(EvalStateNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public final Object childrenAccept(EvalStateNodeVisitor visitor, Object data) {
        return data;
    }

    @Override
    public boolean isSubSelect() {
        return false;
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("EvalFilterStateNode");
        buffer.append(" tag=");
        buffer.append(this.evalFilterNode.getFactoryNode().getFilterSpec());
        buffer.append(" spec=");
        buffer.append(this.evalFilterNode.getFactoryNode().getFilterSpec());
        return buffer.toString();
    }

    @Override
    public boolean isFilterStateNode() {
        return true;
    }

    @Override
    public boolean isNotOperator() {
        return false;
    }

    private void startFiltering() {
        FilterService filterService = this.evalFilterNode.getContext().getPatternContext().getFilterService();
        this.handle = new EPStatementHandleCallback(this.evalFilterNode.getContext().getAgentInstanceContext().getEpStatementAgentInstanceHandle(), this);
        FilterValueSet filterValues = this.evalFilterNode.getFactoryNode().getFilterSpec().getValueSet(this.beginState, this.evalFilterNode.getContext().getAgentInstanceContext(), this.evalFilterNode.getAddendumFilters());
        filterService.add(filterValues, this.handle);
        long filtersVersion = filterService.getFiltersVersion();
        this.evalFilterNode.getContext().getAgentInstanceContext().getEpStatementAgentInstanceHandle().getStatementFilterVersion().setStmtFilterVersion(filtersVersion);
    }

    private void stopFiltering() {
        PatternContext context = this.evalFilterNode.getContext().getPatternContext();
        if (this.handle != null) {
            context.getFilterService().remove(this.handle);
        }
        this.handle = null;
        this.isStarted = false;
        long filtersVersion = context.getFilterService().getFiltersVersion();
        this.evalFilterNode.getContext().getAgentInstanceContext().getEpStatementAgentInstanceHandle().getStatementFilterVersion().setStmtFilterVersion(filtersVersion);
    }
}

