/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.pattern.EvalFollowedByNode;
import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalStateNode;
import com.espertech.esper.pattern.EvalStateNodeVisitor;
import com.espertech.esper.pattern.Evaluator;
import com.espertech.esper.pattern.MatchedEventMap;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EvalFollowedByStateNode
extends EvalStateNode
implements Evaluator {
    private final EvalFollowedByNode evalFollowedByNode;
    private final HashMap<EvalStateNode, Integer> nodes;
    private static final Log log = LogFactory.getLog(EvalFollowedByStateNode.class);

    public EvalFollowedByStateNode(Evaluator parentNode, EvalFollowedByNode evalFollowedByNode, MatchedEventMap beginState) {
        super(parentNode, null);
        this.evalFollowedByNode = evalFollowedByNode;
        this.nodes = new HashMap();
        EvalNode child = evalFollowedByNode.getChildNodes()[0];
        EvalStateNode childState = child.newState(this, beginState, null);
        this.nodes.put(childState, 0);
    }

    @Override
    public EvalNode getFactoryNode() {
        return this.evalFollowedByNode;
    }

    @Override
    public final void start() {
        if (this.nodes.isEmpty()) {
            throw new IllegalStateException("Followed by state node is inactive");
        }
        for (EvalStateNode child : this.nodes.keySet()) {
            child.start();
        }
    }

    @Override
    public final void evaluateTrue(MatchedEventMap matchEvent, EvalStateNode fromNode, boolean isQuitted) {
        Integer index = this.nodes.get(fromNode);
        if (isQuitted) {
            this.nodes.remove(fromNode);
        }
        if (index == null) {
            return;
        }
        int numChildNodes = this.evalFollowedByNode.getChildNodes().length;
        if (index == numChildNodes - 1) {
            boolean isFollowedByQuitted = false;
            if (this.nodes.isEmpty()) {
                isFollowedByQuitted = true;
            }
            this.getParentEvaluator().evaluateTrue(matchEvent, this, isFollowedByQuitted);
        } else {
            EvalNode child = this.evalFollowedByNode.getChildNodes()[index + 1];
            EvalStateNode childState = child.newState(this, matchEvent, null);
            this.nodes.put(childState, index + 1);
            childState.start();
        }
    }

    @Override
    public final void evaluateFalse(EvalStateNode fromNode) {
        fromNode.quit();
        this.nodes.remove(fromNode);
        if (this.nodes.isEmpty()) {
            this.getParentEvaluator().evaluateFalse(this);
            this.quit();
        }
    }

    @Override
    public final void quit() {
        for (EvalStateNode child : this.nodes.keySet()) {
            child.quit();
        }
    }

    @Override
    public final Object accept(EvalStateNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public final Object childrenAccept(EvalStateNodeVisitor visitor, Object data) {
        for (EvalStateNode node : this.nodes.keySet()) {
            node.accept(visitor, data);
        }
        return data;
    }

    @Override
    public boolean isNotOperator() {
        return false;
    }

    @Override
    public boolean isFilterStateNode() {
        return false;
    }

    @Override
    public boolean isFilterChildNonQuitting() {
        return false;
    }

    public final String toString() {
        return "EvalFollowedByStateNode nodes=" + this.nodes.size();
    }
}

