/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.pattern.EvalFollowedByNode;
import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalStateNode;
import com.espertech.esper.pattern.EvalStateNodeVisitor;
import com.espertech.esper.pattern.Evaluator;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.pattern.pool.PatternSubexpressionPoolStmtSvc;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EvalFollowedByStateNodeManaged
extends EvalStateNode
implements Evaluator {
    private final EvalFollowedByNode evalFollowedByNode;
    private final HashMap<EvalStateNode, Integer> nodes;
    private static final Log log = LogFactory.getLog(EvalFollowedByStateNodeManaged.class);

    public EvalFollowedByStateNodeManaged(Evaluator parentNode, EvalFollowedByNode evalFollowedByNode, MatchedEventMap beginState) {
        super(parentNode, null);
        this.evalFollowedByNode = evalFollowedByNode;
        this.nodes = new HashMap();
        EvalNode child = evalFollowedByNode.getChildNodes()[0];
        EvalStateNode childState = child.newState(this, beginState, null);
        this.nodes.put(childState, 0);
    }

    @Override
    public EvalNode getFactoryNode() {
        return this.evalFollowedByNode;
    }

    @Override
    public final void start() {
        if (this.nodes.isEmpty()) {
            throw new IllegalStateException("Followed by state node is inactive");
        }
        for (EvalStateNode child : this.nodes.keySet()) {
            child.start();
        }
    }

    @Override
    public final void evaluateTrue(MatchedEventMap matchEvent, EvalStateNode fromNode, boolean isQuitted) {
        Integer index = this.nodes.get(fromNode);
        if (isQuitted) {
            this.nodes.remove(fromNode);
            if (index != null && index > 0) {
                PatternSubexpressionPoolStmtSvc poolSvc = this.evalFollowedByNode.getContext().getStatementContext().getPatternSubexpressionPoolSvc();
                poolSvc.getEngineSvc().decreaseCount(this.evalFollowedByNode);
                poolSvc.getStmtHandler().decreaseCount();
            }
        }
        if (index == null) {
            return;
        }
        int numChildNodes = this.evalFollowedByNode.getChildNodes().length;
        if (index == numChildNodes - 1) {
            boolean isFollowedByQuitted = false;
            if (this.nodes.isEmpty()) {
                isFollowedByQuitted = true;
            }
            this.getParentEvaluator().evaluateTrue(matchEvent, this, isFollowedByQuitted);
        } else {
            PatternSubexpressionPoolStmtSvc poolSvc = this.evalFollowedByNode.getContext().getStatementContext().getPatternSubexpressionPoolSvc();
            boolean allow = poolSvc.getEngineSvc().tryIncreaseCount(this.evalFollowedByNode);
            if (!allow) {
                return;
            }
            poolSvc.getStmtHandler().increaseCount();
            EvalNode child = this.evalFollowedByNode.getChildNodes()[index + 1];
            EvalStateNode childState = child.newState(this, matchEvent, null);
            this.nodes.put(childState, index + 1);
            childState.start();
        }
    }

    @Override
    public final void evaluateFalse(EvalStateNode fromNode) {
        fromNode.quit();
        Integer index = this.nodes.remove(fromNode);
        if (index != null && index > 0) {
            PatternSubexpressionPoolStmtSvc poolSvc = this.evalFollowedByNode.getContext().getStatementContext().getPatternSubexpressionPoolSvc();
            poolSvc.getEngineSvc().decreaseCount(this.evalFollowedByNode);
            poolSvc.getStmtHandler().decreaseCount();
        }
        if (this.nodes.isEmpty()) {
            this.getParentEvaluator().evaluateFalse(this);
            this.quit();
        }
    }

    @Override
    public final void quit() {
        for (Map.Entry<EvalStateNode, Integer> entry : this.nodes.entrySet()) {
            entry.getKey().quit();
            if (entry.getValue() <= 0) continue;
            PatternSubexpressionPoolStmtSvc poolSvc = this.evalFollowedByNode.getContext().getStatementContext().getPatternSubexpressionPoolSvc();
            poolSvc.getEngineSvc().decreaseCount(this.evalFollowedByNode);
            poolSvc.getStmtHandler().decreaseCount();
        }
    }

    @Override
    public final Object accept(EvalStateNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public final Object childrenAccept(EvalStateNodeVisitor visitor, Object data) {
        for (EvalStateNode node : this.nodes.keySet()) {
            node.accept(visitor, data);
        }
        return data;
    }

    @Override
    public boolean isNotOperator() {
        return false;
    }

    @Override
    public boolean isFilterStateNode() {
        return false;
    }

    @Override
    public boolean isFilterChildNonQuitting() {
        return false;
    }

    public final String toString() {
        return "EvalFollowedByStateNode nodes=" + this.nodes.size();
    }
}

