/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.pattern.EvalMatchUntilNode;
import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalStateNode;
import com.espertech.esper.pattern.EvalStateNodeVisitor;
import com.espertech.esper.pattern.Evaluator;
import com.espertech.esper.pattern.MatchedEventMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EvalMatchUntilStateNode
extends EvalStateNode
implements Evaluator {
    private final HashMap<EvalStateNode, Integer> nodes = new HashMap();
    private final EvalMatchUntilNode evalMatchUntilNode;
    private final MatchedEventMap beginState;
    private final ArrayList<EventBean>[] matchedEventArrays;
    private EvalStateNode stateMatcher;
    private EvalStateNode stateUntil;
    private int numMatches;
    private Integer lowerbounds;
    private Integer upperbounds;
    private static final Log log = LogFactory.getLog(EvalMatchUntilStateNode.class);

    public EvalMatchUntilStateNode(Evaluator parentNode, EvalMatchUntilNode evalMatchUntilNode, MatchedEventMap beginState) {
        super(parentNode, null);
        this.beginState = beginState;
        this.matchedEventArrays = new ArrayList[evalMatchUntilNode.getFactoryNode().getTagsArrayed().length];
        this.evalMatchUntilNode = evalMatchUntilNode;
        EvalNode childMatcher = evalMatchUntilNode.getChildNodeSub();
        this.stateMatcher = childMatcher.newState(this, beginState, null);
        if (evalMatchUntilNode.getChildNodeUntil() != null) {
            EvalNode childUntil = evalMatchUntilNode.getChildNodeUntil();
            this.stateUntil = childUntil.newState(this, beginState, null);
        }
    }

    @Override
    public EvalNode getFactoryNode() {
        return this.evalMatchUntilNode;
    }

    @Override
    public final void start() {
        if (this.stateUntil != null) {
            this.stateUntil.start();
        }
        EventBean[] eventsPerStream = this.evalMatchUntilNode.getFactoryNode().getConvertor().convert(this.beginState);
        if (this.evalMatchUntilNode.getFactoryNode().getLowerBounds() != null) {
            this.lowerbounds = (Integer)this.evalMatchUntilNode.getFactoryNode().getLowerBounds().getExprEvaluator().evaluate(eventsPerStream, true, this.evalMatchUntilNode.getContext().getAgentInstanceContext());
        }
        if (this.evalMatchUntilNode.getFactoryNode().getUpperBounds() != null) {
            this.upperbounds = (Integer)this.evalMatchUntilNode.getFactoryNode().getUpperBounds().getExprEvaluator().evaluate(eventsPerStream, true, this.evalMatchUntilNode.getContext().getAgentInstanceContext());
        }
        if (this.upperbounds != null && this.lowerbounds != null && this.upperbounds < this.lowerbounds) {
            Integer lbounds = this.lowerbounds;
            this.lowerbounds = this.upperbounds;
            this.upperbounds = lbounds;
        }
        if (this.stateMatcher != null) {
            this.stateMatcher.start();
        }
    }

    @Override
    public final void evaluateTrue(MatchedEventMap matchEvent, EvalStateNode fromNode, boolean isQuitted) {
        MatchedEventMap consolidated;
        boolean isMatcher = false;
        if (fromNode == this.stateMatcher) {
            isMatcher = true;
            ++this.numMatches;
            String[] tags = this.evalMatchUntilNode.getFactoryNode().getTagsArrayed();
            for (int i = 0; i < tags.length; ++i) {
                Object event = matchEvent.getMatchingEventAsObject(tags[i]);
                if (event == null) continue;
                if (this.matchedEventArrays[i] == null) {
                    this.matchedEventArrays[i] = new ArrayList();
                }
                if (event instanceof EventBean) {
                    this.matchedEventArrays[i].add((EventBean)event);
                    continue;
                }
                EventBean[] arrayEvents = (EventBean[])event;
                this.matchedEventArrays[i].addAll(Arrays.asList(arrayEvents));
            }
        }
        if (isQuitted) {
            if (isMatcher) {
                this.stateMatcher = null;
            } else {
                this.stateUntil = null;
            }
        }
        if (isMatcher) {
            if (this.isTightlyBound() && this.numMatches == this.lowerbounds) {
                this.quit();
                consolidated = EvalMatchUntilStateNode.consolidate(matchEvent, this.matchedEventArrays, this.evalMatchUntilNode.getFactoryNode().getTagsArrayed());
                this.getParentEvaluator().evaluateTrue(consolidated, this, true);
            } else {
                boolean restart;
                boolean bl = restart = !this.isBounded() || this.upperbounds == null || this.upperbounds > this.numMatches;
                if (this.stateMatcher == null) {
                    if (restart) {
                        EvalNode childMatcher = this.evalMatchUntilNode.getChildNodeSub();
                        this.stateMatcher = childMatcher.newState(this, this.beginState, null);
                        this.stateMatcher.start();
                    }
                } else if (!restart) {
                    this.stateMatcher.quit();
                    this.stateMatcher = null;
                }
            }
        } else {
            this.quit();
            consolidated = EvalMatchUntilStateNode.consolidate(matchEvent, this.matchedEventArrays, this.evalMatchUntilNode.getFactoryNode().getTagsArrayed());
            if (this.lowerbounds != null && this.numMatches < this.lowerbounds) {
                this.getParentEvaluator().evaluateFalse(this);
            } else {
                this.getParentEvaluator().evaluateTrue(consolidated, this, true);
            }
        }
    }

    private static MatchedEventMap consolidate(MatchedEventMap beginState, ArrayList<EventBean>[] matchedEventList, String[] tagsArrayed) {
        if (tagsArrayed == null) {
            return beginState;
        }
        for (int i = 0; i < tagsArrayed.length; ++i) {
            if (matchedEventList[i] == null) continue;
            EventBean[] eventsForTag = matchedEventList[i].toArray(new EventBean[matchedEventList[i].size()]);
            beginState.add(tagsArrayed[i], eventsForTag);
        }
        return beginState;
    }

    @Override
    public final void evaluateFalse(EvalStateNode fromNode) {
        boolean isMatcher = false;
        if (fromNode == this.stateMatcher) {
            isMatcher = true;
        }
        if (isMatcher) {
            this.stateMatcher.quit();
            this.stateMatcher = null;
        } else {
            this.stateUntil.quit();
            this.stateUntil = null;
            this.getParentEvaluator().evaluateFalse(this);
        }
    }

    @Override
    public final void quit() {
        if (this.stateMatcher != null) {
            this.stateMatcher.quit();
            this.stateMatcher = null;
        }
        if (this.stateUntil != null) {
            this.stateUntil.quit();
            this.stateUntil = null;
        }
    }

    @Override
    public final Object accept(EvalStateNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public final Object childrenAccept(EvalStateNodeVisitor visitor, Object data) {
        for (EvalStateNode node : this.nodes.keySet()) {
            node.accept(visitor, data);
        }
        return data;
    }

    public final String toString() {
        return "EvalMatchUntilStateNode nodes=" + this.nodes.size();
    }

    @Override
    public boolean isNotOperator() {
        return false;
    }

    @Override
    public boolean isFilterStateNode() {
        return false;
    }

    @Override
    public boolean isFilterChildNonQuitting() {
        return true;
    }

    private boolean isTightlyBound() {
        return this.lowerbounds != null && this.upperbounds != null && this.upperbounds.equals(this.lowerbounds);
    }

    private boolean isBounded() {
        return this.lowerbounds != null || this.upperbounds != null;
    }
}

