/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.pattern.EvalEveryDistinctFactoryNode;
import com.espertech.esper.pattern.EvalFactoryNode;
import com.espertech.esper.pattern.EvalFilterFactoryNode;
import com.espertech.esper.pattern.EvalGuardFactoryNode;
import com.espertech.esper.pattern.EvalMatchUntilFactoryNode;
import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalNodeAnalysisResult;
import com.espertech.esper.pattern.EvalObserverFactoryNode;
import com.espertech.esper.pattern.EvalRootFactoryNode;
import com.espertech.esper.pattern.EvalRootNode;
import com.espertech.esper.pattern.PatternAgentInstanceContext;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EvalNodeUtil {
    private static final Log log = LogFactory.getLog(EvalNodeUtil.class);

    public static EvalNodeAnalysisResult recursiveAnalyzeChildNodes(EvalFactoryNode currentNode) {
        EvalNodeAnalysisResult evalNodeAnalysisResult = new EvalNodeAnalysisResult();
        EvalNodeUtil.recursiveAnalyzeChildNodes(evalNodeAnalysisResult, currentNode);
        return evalNodeAnalysisResult;
    }

    private static void recursiveAnalyzeChildNodes(EvalNodeAnalysisResult evalNodeAnalysisResult, EvalFactoryNode currentNode) {
        if (currentNode instanceof EvalFilterFactoryNode || currentNode instanceof EvalGuardFactoryNode || currentNode instanceof EvalObserverFactoryNode || currentNode instanceof EvalMatchUntilFactoryNode || currentNode instanceof EvalEveryDistinctFactoryNode) {
            evalNodeAnalysisResult.addNode(currentNode);
        }
        for (EvalFactoryNode node : currentNode.getChildNodes()) {
            EvalNodeUtil.recursiveAnalyzeChildNodes(evalNodeAnalysisResult, node);
        }
    }

    public static Set<EvalFactoryNode> recursiveGetChildNodes(EvalFactoryNode currentNode) {
        HashSet<EvalFactoryNode> result = new HashSet<EvalFactoryNode>();
        EvalNodeUtil.recursiveGetChildNodes(result, currentNode);
        return result;
    }

    private static void recursiveGetChildNodes(Set<EvalFactoryNode> set, EvalFactoryNode currentNode) {
        for (EvalFactoryNode node : currentNode.getChildNodes()) {
            set.add(node);
            EvalNodeUtil.recursiveGetChildNodes(set, node);
        }
    }

    public static EvalRootNode makeRootNodeFromFactory(EvalRootFactoryNode rootFactoryNode, PatternAgentInstanceContext patternAgentInstanceContext) {
        return (EvalRootNode)rootFactoryNode.makeEvalNode(patternAgentInstanceContext);
    }

    public static EvalNode makeEvalNodeSingleChild(List<EvalFactoryNode> childNodes, PatternAgentInstanceContext agentInstanceContext) {
        return childNodes.get(0).makeEvalNode(agentInstanceContext);
    }

    public static EvalNode[] makeEvalNodeChildren(List<EvalFactoryNode> childNodes, PatternAgentInstanceContext agentInstanceContext) {
        EvalNode[] children = new EvalNode[childNodes.size()];
        for (int i = 0; i < childNodes.size(); ++i) {
            children[i] = childNodes.get(i).makeEvalNode(agentInstanceContext);
        }
        return children;
    }
}

