/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalOrNode;
import com.espertech.esper.pattern.EvalStateNode;
import com.espertech.esper.pattern.EvalStateNodeVisitor;
import com.espertech.esper.pattern.Evaluator;
import com.espertech.esper.pattern.MatchedEventMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EvalOrStateNode
extends EvalStateNode
implements Evaluator {
    private final EvalOrNode evalOrNode;
    private final List<EvalStateNode> childNodes = new LinkedList<EvalStateNode>();
    private static final Log log = LogFactory.getLog(EvalOrStateNode.class);

    public EvalOrStateNode(Evaluator parentNode, EvalOrNode evalOrNode, MatchedEventMap beginState) {
        super(parentNode, null);
        this.evalOrNode = evalOrNode;
        for (EvalNode node : evalOrNode.getChildNodes()) {
            EvalStateNode childState = node.newState(this, beginState, null);
            this.childNodes.add(childState);
        }
    }

    @Override
    public EvalNode getFactoryNode() {
        return this.evalOrNode;
    }

    @Override
    public final void start() {
        if (this.childNodes.size() != this.evalOrNode.getChildNodes().length) {
            throw new IllegalStateException("OR state node does not have the required child state nodes");
        }
        for (EvalStateNode child : this.childNodes) {
            child.start();
        }
    }

    @Override
    public final void evaluateTrue(MatchedEventMap matchEvent, EvalStateNode fromNode, boolean isQuitted) {
        if (isQuitted) {
            this.childNodes.remove(fromNode);
            this.quit();
        }
        this.getParentEvaluator().evaluateTrue(matchEvent, this, isQuitted);
    }

    @Override
    public final void evaluateFalse(EvalStateNode fromNode) {
        this.childNodes.remove(fromNode);
        if (this.childNodes.isEmpty()) {
            this.getParentEvaluator().evaluateFalse(this);
        }
    }

    @Override
    public final void quit() {
        for (EvalStateNode child : this.childNodes) {
            child.quit();
        }
        this.childNodes.clear();
    }

    @Override
    public final Object accept(EvalStateNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public final Object childrenAccept(EvalStateNodeVisitor visitor, Object data) {
        for (EvalStateNode node : this.childNodes) {
            node.accept(visitor, data);
        }
        return data;
    }

    @Override
    public boolean isNotOperator() {
        return false;
    }

    @Override
    public boolean isFilterStateNode() {
        return false;
    }

    @Override
    public boolean isFilterChildNonQuitting() {
        return false;
    }

    public final String toString() {
        return "EvalOrStateNode nodes=" + this.childNodes.size();
    }
}

