/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalRootState;
import com.espertech.esper.pattern.EvalStateNode;
import com.espertech.esper.pattern.EvalStateNodeVisitor;
import com.espertech.esper.pattern.Evaluator;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.pattern.PatternContext;
import com.espertech.esper.pattern.PatternMatchCallback;
import com.espertech.esper.pattern.PatternStopCallback;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EvalRootStateNode
extends EvalStateNode
implements Evaluator,
PatternStopCallback,
EvalRootState {
    private EvalNode rootSingleChildNode;
    private EvalStateNode topStateNode;
    private PatternMatchCallback callback;
    private static final Log log = LogFactory.getLog(EvalRootStateNode.class);

    public EvalRootStateNode(EvalNode rootSingleChildNode, MatchedEventMap beginState, PatternContext context) {
        super(null, null);
        this.rootSingleChildNode = rootSingleChildNode;
        this.topStateNode = rootSingleChildNode.newState(this, beginState, null);
    }

    @Override
    public EvalNode getFactoryNode() {
        return this.rootSingleChildNode;
    }

    @Override
    public final void setCallback(PatternMatchCallback callback) {
        this.callback = callback;
    }

    @Override
    public final void start() {
        if (this.topStateNode == null) {
            throw new IllegalStateException("root state node is inactive");
        }
        this.topStateNode.start();
    }

    @Override
    public final void stop() {
        this.quit();
    }

    @Override
    public final void quit() {
        if (this.topStateNode != null) {
            this.topStateNode.quit();
        }
        this.topStateNode = null;
    }

    @Override
    public final void evaluateTrue(MatchedEventMap matchEvent, EvalStateNode fromNode, boolean isQuitted) {
        if (isQuitted) {
            this.topStateNode = null;
        }
        this.callback.matchFound(matchEvent.getMatchingEvents());
    }

    @Override
    public final void evaluateFalse(EvalStateNode fromNode) {
    }

    @Override
    public final Object accept(EvalStateNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public final Object childrenAccept(EvalStateNodeVisitor visitor, Object data) {
        if (this.topStateNode != null) {
            this.topStateNode.accept(visitor, data);
        }
        return data;
    }

    @Override
    public boolean isFilterStateNode() {
        return false;
    }

    @Override
    public boolean isNotOperator() {
        return false;
    }

    @Override
    public boolean isFilterChildNonQuitting() {
        return false;
    }

    public final String toString() {
        return "EvalRootStateNode topStateNode=" + this.topStateNode;
    }
}

