/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.map.MapEventBean;
import com.espertech.esper.pattern.MatchedEventConvertor;
import com.espertech.esper.pattern.MatchedEventMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class MatchedEventConvertorImpl
implements MatchedEventConvertor {
    private final EventBean[] eventsPerStream;
    private final LinkedHashMap<String, Pair<EventType, String>> filterTypes;
    private final LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes;

    public MatchedEventConvertorImpl(LinkedHashMap<String, Pair<EventType, String>> filterTypes, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, EventAdapterService eventAdapterService) {
        int size = filterTypes.size();
        if (arrayEventTypes != null) {
            size += arrayEventTypes.size();
        }
        this.eventsPerStream = new EventBean[size];
        this.filterTypes = new LinkedHashMap<String, Pair<EventType, String>>(filterTypes);
        this.arrayEventTypes = arrayEventTypes != null ? new LinkedHashMap<String, Pair<EventType, String>>(arrayEventTypes) : new LinkedHashMap();
    }

    @Override
    public EventBean[] convert(MatchedEventMap events) {
        int count = 0;
        for (Map.Entry<String, Pair<EventType, String>> entry : this.filterTypes.entrySet()) {
            EventBean event = events.getMatchingEvent(entry.getKey());
            this.eventsPerStream[count++] = event;
        }
        if (this.arrayEventTypes != null) {
            for (Map.Entry<String, Pair<EventType, String>> entry : this.arrayEventTypes.entrySet()) {
                EventBean[] eventArray = (EventBean[])events.getMatchingEventAsObject(entry.getKey());
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(entry.getKey(), eventArray);
                MapEventBean event = new MapEventBean(map, null);
                this.eventsPerStream[count++] = event;
            }
        }
        return this.eventsPerStream;
    }
}

