/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern.guard;

import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.core.service.ExtensionServicesContext;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.pattern.guard.Guard;
import com.espertech.esper.pattern.guard.Quitable;
import com.espertech.esper.schedule.ScheduleHandle;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.schedule.ScheduleSlot;

public class TimerWithinGuard
implements Guard,
ScheduleHandleCallback {
    private final long msec;
    private final Quitable quitable;
    private final ScheduleSlot scheduleSlot;
    private boolean isTimerActive;
    private EPStatementHandleCallback scheduleHandle;

    public TimerWithinGuard(long msec, Quitable quitable) {
        this.msec = msec;
        this.quitable = quitable;
        this.scheduleSlot = quitable.getContext().getPatternContext().getScheduleBucket().allocateSlot();
    }

    @Override
    public void startGuard() {
        if (this.isTimerActive) {
            throw new IllegalStateException("Timer already active");
        }
        this.scheduleHandle = new EPStatementHandleCallback(this.quitable.getContext().getAgentInstanceContext().getEpStatementAgentInstanceHandle(), this);
        this.quitable.getContext().getPatternContext().getSchedulingService().add(this.msec, (ScheduleHandle)this.scheduleHandle, this.scheduleSlot);
        this.isTimerActive = true;
    }

    @Override
    public void stopGuard() {
        if (this.isTimerActive) {
            this.quitable.getContext().getPatternContext().getSchedulingService().remove(this.scheduleHandle, this.scheduleSlot);
            this.scheduleHandle = null;
            this.isTimerActive = false;
        }
    }

    @Override
    public boolean inspect(MatchedEventMap matchEvent) {
        return true;
    }

    @Override
    public final void scheduledTrigger(ExtensionServicesContext extensionServicesContext) {
        this.isTimerActive = false;
        this.quitable.guardQuit();
    }
}

