/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern.pool;

import com.espertech.esper.client.hook.ConditionPatternEngineSubexpressionMax;
import com.espertech.esper.pattern.EvalFollowedByNode;
import com.espertech.esper.pattern.pool.PatternSubexpressionPoolStmtHandler;
import com.espertech.esper.util.ExecutionPathDebugLog;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PatternSubexpressionPoolEngineSvc {
    private static final Log log = LogFactory.getLog(PatternSubexpressionPoolEngineSvc.class);
    private volatile long maxPoolCountConfigured;
    private final boolean preventStart;
    private final AtomicLong poolCount;
    private final Set<StatementEntry> patternContexts;

    public PatternSubexpressionPoolEngineSvc(long maxPoolCountConfigured, boolean preventStart) {
        this.maxPoolCountConfigured = maxPoolCountConfigured;
        this.preventStart = preventStart;
        this.poolCount = new AtomicLong();
        this.patternContexts = Collections.synchronizedSet(new HashSet());
    }

    public void setPatternMaxSubexpressions(Long maxSubexpressions) {
        this.maxPoolCountConfigured = maxSubexpressions == null ? -1L : maxSubexpressions;
    }

    public void addPatternContext(String statementName, PatternSubexpressionPoolStmtHandler stmtCounts) {
        this.patternContexts.add(new StatementEntry(statementName, stmtCounts));
    }

    public void removeStatement(String name) {
        HashSet<StatementEntry> removed = new HashSet<StatementEntry>();
        for (StatementEntry context : this.patternContexts) {
            if (!context.getStatementName().equals(name)) continue;
            removed.add(context);
        }
        this.patternContexts.removeAll(removed);
    }

    public boolean tryIncreaseCount(EvalFollowedByNode evalFollowedByNode) {
        long newMax = this.poolCount.incrementAndGet();
        if (newMax > this.maxPoolCountConfigured && this.maxPoolCountConfigured >= 0L) {
            Map<String, Long> counts = this.getCounts();
            evalFollowedByNode.getContext().getAgentInstanceContext().getStatementContext().getExceptionHandlingService().handleCondition(new ConditionPatternEngineSubexpressionMax(this.maxPoolCountConfigured, counts), evalFollowedByNode.getContext().getAgentInstanceContext().getStatementContext().getEpStatementHandle());
            if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled() && ExecutionPathDebugLog.isTimerDebugEnabled) {
                PatternSubexpressionPoolStmtHandler stmtHandler = evalFollowedByNode.getContext().getAgentInstanceContext().getStatementContext().getPatternSubexpressionPoolSvc().getStmtHandler();
                String stmtName = evalFollowedByNode.getContext().getAgentInstanceContext().getStatementContext().getStatementName();
                log.debug((Object)(".tryIncreaseCount For statement '" + stmtName + "' pool count overflow at " + newMax + " statement count was " + stmtHandler.getCount() + " preventStart=" + this.preventStart));
            }
            if (this.preventStart) {
                this.poolCount.decrementAndGet();
                return false;
            }
            return true;
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            PatternSubexpressionPoolStmtHandler stmtHandler = evalFollowedByNode.getContext().getAgentInstanceContext().getStatementContext().getPatternSubexpressionPoolSvc().getStmtHandler();
            String stmtName = evalFollowedByNode.getContext().getAgentInstanceContext().getStatementContext().getStatementName();
            log.debug((Object)(".tryIncreaseCount For statement '" + stmtName + "' pool count increases to " + newMax + " statement count was " + stmtHandler.getCount()));
        }
        return true;
    }

    public void forceIncreaseCount(EvalFollowedByNode evalFollowedByNode) {
        long newMax = this.poolCount.incrementAndGet();
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            PatternSubexpressionPoolStmtHandler stmtHandler = evalFollowedByNode.getContext().getAgentInstanceContext().getStatementContext().getPatternSubexpressionPoolSvc().getStmtHandler();
            String stmtName = evalFollowedByNode.getContext().getAgentInstanceContext().getStatementContext().getStatementName();
            log.debug((Object)(".forceIncreaseCount For statement '" + stmtName + "' pool count increases to " + newMax + " statement count was " + stmtHandler.getCount()));
        }
    }

    public void decreaseCount(EvalFollowedByNode evalFollowedByNode) {
        long newMax = this.poolCount.decrementAndGet();
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            PatternSubexpressionPoolStmtHandler stmtHandler = evalFollowedByNode.getContext().getAgentInstanceContext().getStatementContext().getPatternSubexpressionPoolSvc().getStmtHandler();
            String stmtName = evalFollowedByNode.getContext().getAgentInstanceContext().getStatementContext().getStatementName();
            log.debug((Object)(".decreaseCount For statement '" + stmtName + "' pool count decreases to " + newMax + " statement count was " + stmtHandler.getCount()));
        }
    }

    private Map<String, Long> getCounts() {
        HashMap<String, Long> counts = new HashMap<String, Long>();
        for (StatementEntry context : this.patternContexts) {
            Long count = (Long)counts.get(context.getStatementName());
            if (count == null) {
                count = 0L;
            }
            count = count + (long)context.getStmtCounts().getCount();
            counts.put(context.getStatementName(), count);
        }
        return counts;
    }

    public static class StatementEntry {
        private final String statementName;
        private final PatternSubexpressionPoolStmtHandler stmtCounts;

        public StatementEntry(String statementName, PatternSubexpressionPoolStmtHandler stmtCounts) {
            this.statementName = statementName;
            this.stmtCounts = stmtCounts;
        }

        public String getStatementName() {
            return this.statementName;
        }

        public PatternSubexpressionPoolStmtHandler getStmtCounts() {
            return this.stmtCounts;
        }
    }
}

