/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.rowregex;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.collection.SingleEventIterator;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.core.service.ExtensionServicesContext;
import com.espertech.esper.epl.agg.AggregationServiceMatchRecognize;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprPreviousMatchRecognizeNode;
import com.espertech.esper.epl.spec.MatchRecognizeDefineItem;
import com.espertech.esper.epl.spec.MatchRecognizeMeasureItem;
import com.espertech.esper.epl.spec.MatchRecognizeSkipEnum;
import com.espertech.esper.epl.spec.MatchRecognizeSpec;
import com.espertech.esper.rowregex.EventRowRegexHelper;
import com.espertech.esper.rowregex.EventRowRegexIteratorResult;
import com.espertech.esper.rowregex.MultimatchState;
import com.espertech.esper.rowregex.RegexNFAState;
import com.espertech.esper.rowregex.RegexNFAStateEnd;
import com.espertech.esper.rowregex.RegexNFAStateEntry;
import com.espertech.esper.rowregex.RegexNFAStrandResult;
import com.espertech.esper.rowregex.RegexPartitionState;
import com.espertech.esper.rowregex.RegexPartitionStateRandomAccessGetter;
import com.espertech.esper.rowregex.RegexPartitionStateRepo;
import com.espertech.esper.rowregex.RegexPartitionStateRepoGroup;
import com.espertech.esper.rowregex.RegexPartitionStateRepoNoGroup;
import com.espertech.esper.schedule.ScheduleHandle;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.schedule.ScheduleSlot;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.ViewSupport;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventRowRegexNFAView
extends ViewSupport
implements StopCallback {
    private static final Log log = LogFactory.getLog(EventRowRegexNFAView.class);
    private static final boolean IS_DEBUG = false;
    private static final Iterator<EventBean> NULL_ITERATOR = new SingleEventIterator(null);
    private final MatchRecognizeSpec matchRecognizeSpec;
    private final boolean isUnbound;
    private final boolean isIterateOnly;
    private final boolean isSelectAsksMultimatches;
    private final EventType compositeEventType;
    private final EventType rowEventType;
    private final AgentInstanceContext agentInstanceContext;
    private final AggregationServiceMatchRecognize aggregationService;
    private final ScheduleSlot scheduleSlot;
    private final EPStatementHandleCallback handle;
    private final TreeMap<Long, Object> schedule;
    private final ExprEvaluator[] columnEvaluators;
    private final String[] columnNames;
    private final RegexNFAState[] startStates;
    private final RegexNFAState[] allStates;
    private final String[] variablesArray;
    private final LinkedHashMap<String, Pair<Integer, Boolean>> variableStreams;
    private final Map<Integer, String> streamsVariables;
    private final Set<String> variablesSingle;
    private RegexPartitionStateRepo regexPartitionStateRepo;
    private LinkedHashSet<EventBean> windowMatchedEventset;
    private int eventSequenceNumber;

    public EventRowRegexNFAView(EventType compositeEventType, EventType rowEventType, MatchRecognizeSpec matchRecognizeSpec, LinkedHashMap<String, Pair<Integer, Boolean>> variableStreams, Map<Integer, String> streamsVariables, Set<String> variablesSingle, AgentInstanceContext agentInstanceContext, TreeMap<Integer, List<ExprPreviousMatchRecognizeNode>> callbacksPerIndex, AggregationServiceMatchRecognize aggregationService, boolean isUnbound, boolean isIterateOnly, boolean isSelectAsksMultimatches) {
        RegexPartitionStateRandomAccessGetter randomAccessByIndexGetter;
        this.matchRecognizeSpec = matchRecognizeSpec;
        this.compositeEventType = compositeEventType;
        this.rowEventType = rowEventType;
        this.variableStreams = variableStreams;
        this.variablesArray = variableStreams.keySet().toArray(new String[variableStreams.keySet().size()]);
        this.streamsVariables = streamsVariables;
        this.variablesSingle = variablesSingle;
        this.aggregationService = aggregationService;
        this.isUnbound = isUnbound;
        this.isIterateOnly = isIterateOnly;
        this.agentInstanceContext = agentInstanceContext;
        this.isSelectAsksMultimatches = isSelectAsksMultimatches;
        if (matchRecognizeSpec.getInterval() != null) {
            this.scheduleSlot = agentInstanceContext.getStatementContext().getScheduleBucket().allocateSlot();
            ScheduleHandleCallback callback = new ScheduleHandleCallback(){

                @Override
                public void scheduledTrigger(ExtensionServicesContext extensionServicesContext) {
                    EventRowRegexNFAView.this.triggered();
                }
            };
            this.handle = new EPStatementHandleCallback(agentInstanceContext.getEpStatementAgentInstanceHandle(), callback);
            this.schedule = new TreeMap();
            agentInstanceContext.getTerminationCallbacks().add(this);
        } else {
            this.scheduleSlot = null;
            this.handle = null;
            this.schedule = null;
        }
        this.windowMatchedEventset = new LinkedHashSet();
        if (!callbacksPerIndex.isEmpty()) {
            int[] randomAccessIndexesRequested = new int[callbacksPerIndex.size()];
            int count = 0;
            for (Map.Entry<Integer, List<ExprPreviousMatchRecognizeNode>> entry : callbacksPerIndex.entrySet()) {
                randomAccessIndexesRequested[count] = entry.getKey();
                ++count;
            }
            randomAccessByIndexGetter = new RegexPartitionStateRandomAccessGetter(randomAccessIndexesRequested, isUnbound);
            count = 0;
            for (Map.Entry<Integer, List<ExprPreviousMatchRecognizeNode>> entry : callbacksPerIndex.entrySet()) {
                for (ExprPreviousMatchRecognizeNode callback : entry.getValue()) {
                    callback.setGetter(randomAccessByIndexGetter);
                    callback.setAssignedIndex(count);
                }
                ++count;
            }
        } else {
            randomAccessByIndexGetter = null;
        }
        LinkedHashMap<String, ExprNode> variableDefinitions = new LinkedHashMap<String, ExprNode>();
        for (MatchRecognizeDefineItem defineItem : matchRecognizeSpec.getDefines()) {
            variableDefinitions.put(defineItem.getIdentifier(), defineItem.getExpression());
        }
        RegexNFAStrandResult strand = EventRowRegexHelper.recursiveBuildStartStates(matchRecognizeSpec.getPattern(), variableDefinitions, variableStreams);
        this.startStates = strand.getStartStates().toArray(new RegexNFAState[strand.getStartStates().size()]);
        this.allStates = strand.getAllStates().toArray(new RegexNFAState[strand.getAllStates().size()]);
        if (log.isDebugEnabled()) {
            log.info((Object)("NFA tree:\n" + this.print(this.startStates)));
        }
        this.columnNames = new String[matchRecognizeSpec.getMeasures().size()];
        this.columnEvaluators = new ExprEvaluator[matchRecognizeSpec.getMeasures().size()];
        int count = 0;
        for (MatchRecognizeMeasureItem measureItem : matchRecognizeSpec.getMeasures()) {
            this.columnNames[count] = measureItem.getName();
            this.columnEvaluators[count] = measureItem.getExpr().getExprEvaluator();
            ++count;
        }
        this.regexPartitionStateRepo = this.matchRecognizeSpec.getPartitionByExpressions().isEmpty() ? new RegexPartitionStateRepoNoGroup(randomAccessByIndexGetter, matchRecognizeSpec.getInterval() != null) : new RegexPartitionStateRepoGroup(randomAccessByIndexGetter, ExprNodeUtility.getEvaluators(matchRecognizeSpec.getPartitionByExpressions()), matchRecognizeSpec.getInterval() != null, agentInstanceContext);
    }

    @Override
    public void stop() {
        if (this.handle != null) {
            this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
        }
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        if (this.isIterateOnly) {
            if (oldData != null) {
                this.regexPartitionStateRepo.removeOld(oldData, false, new boolean[oldData.length]);
            }
            if (newData != null) {
                for (EventBean newEvent : newData) {
                    RegexPartitionState partitionState = this.regexPartitionStateRepo.getState(newEvent, true);
                    if (partitionState == null || partitionState.getRandomAccess() == null) continue;
                    partitionState.getRandomAccess().newEventPrepare(newEvent);
                }
            }
            return;
        }
        if (oldData != null) {
            boolean isOutOfSequenceRemove = false;
            EventBean first = null;
            if (!this.windowMatchedEventset.isEmpty()) {
                first = (EventBean)this.windowMatchedEventset.iterator().next();
            }
            boolean[] found = new boolean[oldData.length];
            int count = 0;
            for (EventBean oldEvent : oldData) {
                boolean removed = this.windowMatchedEventset.remove(oldEvent);
                if (!removed) continue;
                if (oldEvent != first && first != null) {
                    isOutOfSequenceRemove = true;
                }
                found[count++] = true;
                if (this.windowMatchedEventset.isEmpty()) continue;
                first = (EventBean)this.windowMatchedEventset.iterator().next();
            }
            this.regexPartitionStateRepo.removeOld(oldData, this.windowMatchedEventset.isEmpty(), found);
            if (isOutOfSequenceRemove) {
                this.regexPartitionStateRepo = this.regexPartitionStateRepo.copyForIterate();
                this.windowMatchedEventset = new LinkedHashSet();
                Iterator<EventBean> parentEvents = this.getParent().iterator();
                EventRowRegexIteratorResult iteratorResult = this.processIterator(this.startStates, parentEvents, this.regexPartitionStateRepo);
                this.eventSequenceNumber = iteratorResult.getEventSequenceNum();
            }
        }
        if (newData == null) {
            return;
        }
        List<RegexNFAStateEntry> endStates = new ArrayList<RegexNFAStateEntry>();
        List<RegexNFAStateEntry> nextStates = new ArrayList<RegexNFAStateEntry>();
        for (EventBean newEvent : newData) {
            ++this.eventSequenceNumber;
            RegexPartitionState partitionState = this.regexPartitionStateRepo.getState(newEvent, true);
            List<RegexNFAStateEntry> currentStates = partitionState.getCurrentStates();
            for (RegexNFAState startState : this.startStates) {
                long time = 0L;
                if (this.matchRecognizeSpec.getInterval() != null) {
                    time = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
                }
                currentStates.add(new RegexNFAStateEntry(this.eventSequenceNumber, time, startState, new EventBean[this.variableStreams.size()], new int[this.allStates.length], null, partitionState.getOptionalKeys()));
            }
            if (partitionState.getRandomAccess() != null) {
                partitionState.getRandomAccess().newEventPrepare(newEvent);
            }
            if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
                log.info((Object)("Evaluating event " + newEvent.getUnderlying() + "\n" + "current : " + this.printStates(currentStates)));
            }
            this.step(currentStates, newEvent, nextStates, endStates, !this.isUnbound, this.eventSequenceNumber, partitionState.getOptionalKeys());
            if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
                log.info((Object)("Evaluated event " + newEvent.getUnderlying() + "\n" + "next : " + this.printStates(nextStates) + "\n" + "end : " + this.printStates(endStates)));
            }
            partitionState.setCurrentStates(nextStates);
            nextStates = currentStates;
            nextStates.clear();
        }
        if (endStates.isEmpty()) {
            return;
        }
        if (!this.matchRecognizeSpec.isAllMatches()) {
            endStates = this.rankEndStatesMultiPartition(endStates);
        }
        if (this.matchRecognizeSpec.getInterval() != null) {
            Iterator<RegexNFAStateEntry> it = endStates.iterator();
            while (it.hasNext()) {
                RegexNFAStateEntry endState = it.next();
                RegexPartitionState partitionState = this.regexPartitionStateRepo.getState(endState.getPartitionKey());
                if (partitionState == null) {
                    log.warn((Object)"Null partition state encountered, skipping row");
                    continue;
                }
                long matchBeginTime = endState.getMatchBeginEventTime();
                long current = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
                long deltaFromStart = current - matchBeginTime;
                long deltaUntil = this.matchRecognizeSpec.getInterval().getMSec() - deltaFromStart;
                if (this.schedule.containsKey(matchBeginTime)) {
                    this.scheduleCallback(deltaUntil, endState);
                    it.remove();
                    continue;
                }
                if (deltaFromStart >= deltaUntil) continue;
                this.scheduleCallback(deltaUntil, endState);
                it.remove();
            }
            if (endStates.isEmpty()) {
                return;
            }
        } else if (this.matchRecognizeSpec.getSkip().getSkip() == MatchRecognizeSkipEnum.PAST_LAST_ROW) {
            for (RegexNFAStateEntry endState : endStates) {
                RegexPartitionState partitionState = this.regexPartitionStateRepo.getState(endState.getPartitionKey());
                if (partitionState == null) {
                    log.warn((Object)"Null partition state encountered, skipping row");
                    continue;
                }
                Iterator<RegexNFAStateEntry> stateIter = partitionState.getCurrentStates().iterator();
                while (stateIter.hasNext()) {
                    RegexNFAStateEntry currentState = stateIter.next();
                    if (currentState.getMatchBeginEventSeqNo() > endState.getMatchEndEventSeqNo()) continue;
                    stateIter.remove();
                }
            }
        } else if (this.matchRecognizeSpec.getSkip().getSkip() == MatchRecognizeSkipEnum.TO_NEXT_ROW) {
            for (RegexNFAStateEntry endState : endStates) {
                RegexPartitionState partitionState = this.regexPartitionStateRepo.getState(endState.getPartitionKey());
                if (partitionState == null) {
                    log.warn((Object)"Null partition state encountered, skipping row");
                    continue;
                }
                Iterator<RegexNFAStateEntry> stateIter = partitionState.getCurrentStates().iterator();
                while (stateIter.hasNext()) {
                    RegexNFAStateEntry currentState = stateIter.next();
                    if (currentState.getMatchBeginEventSeqNo() > endState.getMatchBeginEventSeqNo()) continue;
                    stateIter.remove();
                }
            }
        }
        EventBean[] out = new EventBean[endStates.size()];
        int count = 0;
        for (RegexNFAStateEntry endState : endStates) {
            RegexPartitionState state;
            out[count++] = this.generateOutputRow(endState);
            if (endState.getPartitionKey() == null || !(state = this.regexPartitionStateRepo.getState(endState.getPartitionKey())).getCurrentStates().isEmpty() || state.getRandomAccess() != null) continue;
            this.regexPartitionStateRepo.removeState(endState.getPartitionKey());
        }
        this.updateChildren(out, null);
    }

    private RegexNFAStateEntry rankEndStates(List<RegexNFAStateEntry> endStates) {
        RegexNFAStateEntry found = null;
        int min = Integer.MAX_VALUE;
        boolean multipleMinimums = false;
        for (RegexNFAStateEntry state : endStates) {
            if (state.getMatchBeginEventSeqNo() < min) {
                found = state;
                min = state.getMatchBeginEventSeqNo();
                continue;
            }
            if (state.getMatchBeginEventSeqNo() != min) continue;
            multipleMinimums = true;
        }
        if (!multipleMinimums) {
            Collections.singletonList(found);
        }
        int[] best = null;
        found = null;
        for (RegexNFAStateEntry state : endStates) {
            if (state.getMatchBeginEventSeqNo() != min) continue;
            if (best == null) {
                best = state.getGreedycountPerState();
                found = state;
                continue;
            }
            int[] current = state.getGreedycountPerState();
            if (!this.compare(current, best)) continue;
            best = current;
            found = state;
        }
        return found;
    }

    private boolean compare(int[] current, int[] best) {
        for (RegexNFAState state : this.allStates) {
            if (state.isGreedy() == null || !(state.isGreedy() != false ? current[state.getNodeNumFlat()] > best[state.getNodeNumFlat()] : current[state.getNodeNumFlat()] < best[state.getNodeNumFlat()])) continue;
            return true;
        }
        return false;
    }

    private EventRowRegexIteratorResult processIterator(RegexNFAState[] startStates, Iterator<EventBean> events, RegexPartitionStateRepo regexPartitionStateRepo) {
        ArrayList<RegexNFAStateEntry> endStates = new ArrayList<RegexNFAStateEntry>();
        List<RegexNFAStateEntry> nextStates = new ArrayList<RegexNFAStateEntry>();
        int eventSequenceNumber = 0;
        while (events.hasNext()) {
            EventBean event = events.next();
            ++eventSequenceNumber;
            RegexPartitionState partitionState = regexPartitionStateRepo.getState(event, false);
            List<RegexNFAStateEntry> currentStates = partitionState.getCurrentStates();
            for (RegexNFAState startState : startStates) {
                long time = 0L;
                if (this.matchRecognizeSpec.getInterval() != null) {
                    time = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
                }
                currentStates.add(new RegexNFAStateEntry(eventSequenceNumber, time, startState, new EventBean[this.variableStreams.size()], new int[this.allStates.length], null, partitionState.getOptionalKeys()));
            }
            if (partitionState.getRandomAccess() != null) {
                partitionState.getRandomAccess().existingEventPrepare(event);
            }
            if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
                log.info((Object)("Evaluating event " + event.getUnderlying() + "\n" + "current : " + this.printStates(currentStates)));
            }
            this.step(currentStates, event, nextStates, endStates, false, eventSequenceNumber, partitionState.getOptionalKeys());
            if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
                log.info((Object)("Evaluating event " + event.getUnderlying() + "\n" + "next : " + this.printStates(nextStates) + "\n" + "end : " + this.printStates(endStates)));
            }
            partitionState.setCurrentStates(nextStates);
            nextStates = currentStates;
            nextStates.clear();
        }
        return new EventRowRegexIteratorResult(endStates, eventSequenceNumber);
    }

    @Override
    public EventType getEventType() {
        return this.rowEventType;
    }

    @Override
    public Iterator<EventBean> iterator() {
        RegexPartitionStateRepo regexPartitionStateRepoNew;
        if (this.isUnbound) {
            return NULL_ITERATOR;
        }
        Iterator<EventBean> it = this.parent.iterator();
        EventRowRegexIteratorResult iteratorResult = this.processIterator(this.startStates, it, regexPartitionStateRepoNew = this.regexPartitionStateRepo.copyForIterate());
        List<RegexNFAStateEntry> endStates = iteratorResult.getEndStates();
        if (endStates.isEmpty()) {
            return NULL_ITERATOR;
        }
        endStates = this.rankEndStatesMultiPartition(endStates);
        ArrayList<EventBean> output = new ArrayList<EventBean>();
        for (RegexNFAStateEntry endState : endStates) {
            output.add(this.generateOutputRow(endState));
        }
        return output.iterator();
    }

    private List<RegexNFAStateEntry> rankEndStatesMultiPartition(List<RegexNFAStateEntry> endStates) {
        List<RegexNFAStateEntry> entries;
        if (endStates.isEmpty()) {
            return endStates;
        }
        if (endStates.size() == 1) {
            return endStates;
        }
        if (this.matchRecognizeSpec.getPartitionByExpressions().isEmpty()) {
            return this.rankEndStatesWithinPartitionByStart(endStates);
        }
        LinkedHashMap<MultiKeyUntyped, Object> perPartition = new LinkedHashMap<MultiKeyUntyped, Object>();
        for (RegexNFAStateEntry endState : endStates) {
            Object value = perPartition.get(endState.getPartitionKey());
            if (value == null) {
                perPartition.put(endState.getPartitionKey(), endState);
                continue;
            }
            if (value instanceof List) {
                entries = (ArrayList<RegexNFAStateEntry>)value;
                entries.add(endState);
                continue;
            }
            entries = new ArrayList<RegexNFAStateEntry>();
            entries.add((RegexNFAStateEntry)value);
            entries.add(endState);
            perPartition.put(endState.getPartitionKey(), entries);
        }
        ArrayList<RegexNFAStateEntry> finalEndStates = new ArrayList<RegexNFAStateEntry>();
        for (Map.Entry entry : perPartition.entrySet()) {
            if (entry.getValue() instanceof RegexNFAStateEntry) {
                finalEndStates.add((RegexNFAStateEntry)entry.getValue());
                continue;
            }
            entries = (List)entry.getValue();
            finalEndStates.addAll(this.rankEndStatesWithinPartitionByStart(entries));
        }
        return finalEndStates;
    }

    private List<RegexNFAStateEntry> rankEndStatesWithinPartitionByStart(List<RegexNFAStateEntry> endStates) {
        Integer[] keys;
        if (endStates.isEmpty()) {
            return endStates;
        }
        if (endStates.size() == 1) {
            return endStates;
        }
        TreeMap<Integer, Object> endStatesPerBeginEvent = new TreeMap<Integer, Object>();
        for (RegexNFAStateEntry entry : endStates) {
            ArrayList<RegexNFAStateEntry> entries;
            Integer endNum = entry.getMatchBeginEventSeqNo();
            Object value = endStatesPerBeginEvent.get(endNum);
            if (value == null) {
                endStatesPerBeginEvent.put(endNum, entry);
                continue;
            }
            if (value instanceof List) {
                entries = (ArrayList<RegexNFAStateEntry>)value;
                entries.add(entry);
                continue;
            }
            entries = new ArrayList<RegexNFAStateEntry>();
            entries.add((RegexNFAStateEntry)value);
            entries.add(entry);
            endStatesPerBeginEvent.put(endNum, entries);
        }
        if (endStatesPerBeginEvent.size() == 1) {
            List endStatesUnranked = (List)endStatesPerBeginEvent.values().iterator().next();
            if (this.matchRecognizeSpec.isAllMatches()) {
                return endStatesUnranked;
            }
            RegexNFAStateEntry chosen = this.rankEndStates(endStatesUnranked);
            return Collections.singletonList(chosen);
        }
        ArrayList<RegexNFAStateEntry> endStatesRanked = new ArrayList<RegexNFAStateEntry>();
        Set keyset = endStatesPerBeginEvent.keySet();
        for (Integer key : keys = keyset.toArray(new Integer[keyset.size()])) {
            RegexNFAStateEntry entryTaken;
            Object value = endStatesPerBeginEvent.remove(key);
            if (value == null) continue;
            if (value instanceof List) {
                List endStatesUnranked = (List)value;
                if (endStatesUnranked.isEmpty()) continue;
                entryTaken = this.rankEndStates(endStatesUnranked);
                if (this.matchRecognizeSpec.isAllMatches()) {
                    endStatesRanked.addAll(endStatesUnranked);
                } else {
                    endStatesRanked.add(entryTaken);
                }
            } else {
                entryTaken = (RegexNFAStateEntry)value;
                endStatesRanked.add(entryTaken);
            }
            if (entryTaken == null) continue;
            if (this.matchRecognizeSpec.getSkip().getSkip() == MatchRecognizeSkipEnum.PAST_LAST_ROW) {
                int skipPastRow = entryTaken.getMatchEndEventSeqNo();
                this.removeSkippedEndStates(endStatesPerBeginEvent, skipPastRow);
                continue;
            }
            if (this.matchRecognizeSpec.getSkip().getSkip() != MatchRecognizeSkipEnum.TO_NEXT_ROW) continue;
            int skipPastRow = entryTaken.getMatchBeginEventSeqNo();
            this.removeSkippedEndStates(endStatesPerBeginEvent, skipPastRow);
        }
        return endStatesRanked;
    }

    private void removeSkippedEndStates(TreeMap<Integer, Object> endStatesPerEndEvent, int skipPastRow) {
        for (Map.Entry<Integer, Object> entry : endStatesPerEndEvent.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof List) {
                List endStatesUnranked = (List)value;
                Iterator it = endStatesUnranked.iterator();
                while (it.hasNext()) {
                    RegexNFAStateEntry endState = (RegexNFAStateEntry)it.next();
                    if (endState.getMatchBeginEventSeqNo() > skipPastRow) continue;
                    it.remove();
                }
                continue;
            }
            RegexNFAStateEntry endState = (RegexNFAStateEntry)value;
            if (endState.getMatchBeginEventSeqNo() > skipPastRow) continue;
            endStatesPerEndEvent.put(entry.getKey(), null);
        }
    }

    private void step(List<RegexNFAStateEntry> currentStates, EventBean event, List<RegexNFAStateEntry> nextStates, List<RegexNFAStateEntry> endStates, boolean isRetainEventSet, int currentEventSequenceNumber, MultiKeyUntyped partitionKey) {
        for (RegexNFAStateEntry currentState : currentStates) {
            List<RegexNFAState> nextStatesFromHere;
            EventBean[] eventsPerStream = currentState.getEventsPerStream();
            int currentStateStreamNum = currentState.getState().getStreamNum();
            eventsPerStream[currentStateStreamNum] = event;
            if (!currentState.getState().matches(eventsPerStream, this.agentInstanceContext)) continue;
            if (isRetainEventSet) {
                this.windowMatchedEventset.add(event);
            }
            boolean copy = (nextStatesFromHere = currentState.getState().getNextStates()).size() > 1;
            for (RegexNFAState next : nextStatesFromHere) {
                EventBean[] eventsForState = eventsPerStream;
                MultimatchState[] multimatches = currentState.getOptionalMultiMatches();
                int[] greedyCounts = currentState.getGreedycountPerState();
                if (copy) {
                    eventsForState = new EventBean[eventsForState.length];
                    System.arraycopy(eventsPerStream, 0, eventsForState, 0, eventsForState.length);
                    int[] greedyCountsCopy = new int[greedyCounts.length];
                    System.arraycopy(greedyCounts, 0, greedyCountsCopy, 0, greedyCounts.length);
                    greedyCounts = greedyCountsCopy;
                    if (this.isSelectAsksMultimatches) {
                        multimatches = this.deepCopy(multimatches);
                    }
                }
                if (this.isSelectAsksMultimatches && currentState.getState().isMultiple()) {
                    multimatches = this.addTag(currentState.getState().getStreamNum(), event, multimatches);
                }
                if (currentState.getState().isGreedy() != null && currentState.getState().isGreedy().booleanValue()) {
                    int n = currentState.getState().getNodeNumFlat();
                    greedyCounts[n] = greedyCounts[n] + 1;
                }
                RegexNFAStateEntry entry = new RegexNFAStateEntry(currentState.getMatchBeginEventSeqNo(), currentState.getMatchBeginEventTime(), next, eventsForState, greedyCounts, multimatches, partitionKey);
                if (next instanceof RegexNFAStateEnd) {
                    entry.setMatchEndEventSeqNo(currentEventSequenceNumber);
                    endStates.add(entry);
                    continue;
                }
                nextStates.add(entry);
            }
        }
    }

    private MultimatchState[] deepCopy(MultimatchState[] multimatchStates) {
        if (multimatchStates == null) {
            return null;
        }
        MultimatchState[] copy = new MultimatchState[multimatchStates.length];
        for (int i = 0; i < copy.length; ++i) {
            if (multimatchStates[i] == null) continue;
            copy[i] = new MultimatchState(multimatchStates[i]);
        }
        return copy;
    }

    private MultimatchState[] addTag(int streamNum, EventBean event, MultimatchState[] multimatches) {
        MultimatchState state;
        if (multimatches == null) {
            multimatches = new MultimatchState[this.variablesArray.length];
        }
        if ((state = multimatches[streamNum]) == null) {
            multimatches[streamNum] = new MultimatchState(event);
            return multimatches;
        }
        multimatches[streamNum].add(event);
        return multimatches;
    }

    private String printStates(List<RegexNFAStateEntry> states) {
        StringBuilder buf = new StringBuilder();
        String delimiter = "";
        for (RegexNFAStateEntry state : states) {
            buf.append(delimiter);
            buf.append(state.getState().getNodeNumNested());
            buf.append("{");
            EventBean[] eventsPerStream = state.getEventsPerStream();
            if (eventsPerStream == null) {
                buf.append("null");
            } else {
                String eventDelimiter = "";
                for (Map.Entry<Integer, String> streamVariable : this.streamsVariables.entrySet()) {
                    buf.append(eventDelimiter);
                    buf.append(streamVariable.getValue());
                    buf.append('=');
                    if (this.variablesSingle.contains(streamVariable.getValue())) {
                        if (eventsPerStream[streamVariable.getKey()] == null) {
                            buf.append("null");
                        } else {
                            buf.append(eventsPerStream[streamVariable.getKey()].getUnderlying());
                        }
                    } else {
                        int streamNum = state.getState().getStreamNum();
                        if (state.getOptionalMultiMatches() == null) {
                            buf.append("null-mm");
                        } else if (state.getOptionalMultiMatches()[streamNum] == null) {
                            buf.append("no-entry");
                        } else {
                            buf.append("{");
                            String arrayEventDelimiter = "";
                            EventBean[] multiMatch = state.getOptionalMultiMatches()[streamNum].getBuffer();
                            int count = state.getOptionalMultiMatches()[streamNum].getCount();
                            for (int i = 0; i < count; ++i) {
                                buf.append(arrayEventDelimiter);
                                buf.append(multiMatch[i].getUnderlying());
                                arrayEventDelimiter = ", ";
                            }
                            buf.append("}");
                        }
                    }
                    eventDelimiter = ", ";
                }
            }
            buf.append("}");
            delimiter = ", ";
        }
        return buf.toString();
    }

    private String print(RegexNFAState[] states) {
        StringWriter writer = new StringWriter();
        PrintWriter buf = new PrintWriter(writer);
        Stack<RegexNFAState> currentStack = new Stack<RegexNFAState>();
        this.print(Arrays.asList(states), buf, 0, currentStack);
        return writer.toString();
    }

    private void print(List<RegexNFAState> states, PrintWriter writer, int indent, Stack<RegexNFAState> currentStack) {
        for (RegexNFAState state : states) {
            this.indent(writer, indent);
            if (currentStack.contains(state)) {
                writer.println("(self)");
                continue;
            }
            writer.println(this.printState(state));
            currentStack.push(state);
            this.print(state.getNextStates(), writer, indent + 4, currentStack);
            currentStack.pop();
        }
    }

    private String printState(RegexNFAState state) {
        if (state instanceof RegexNFAStateEnd) {
            return "#" + state.getNodeNumNested();
        }
        return "#" + state.getNodeNumNested() + " " + state.getVariableName() + " s" + state.getStreamNum() + " defined as " + state;
    }

    private void indent(PrintWriter writer, int indent) {
        for (int i = 0; i < indent; ++i) {
            writer.append(' ');
        }
    }

    private EventBean generateOutputRow(RegexNFAStateEntry entry) {
        HashMap<String, Object> rowDataRaw = new HashMap<String, Object>();
        for (Map.Entry<String, Pair<Integer, Boolean>> variableDef : this.variableStreams.entrySet()) {
            if (variableDef.getValue().getSecond().booleanValue()) continue;
            rowDataRaw.put(variableDef.getKey(), entry.getEventsPerStream()[variableDef.getValue().getFirst()]);
        }
        if (this.aggregationService != null) {
            this.aggregationService.clearResults();
        }
        if (entry.getOptionalMultiMatches() != null) {
            MultimatchState[] multimatchState = entry.getOptionalMultiMatches();
            for (int i = 0; i < multimatchState.length; ++i) {
                if (multimatchState[i] == null) continue;
                EventBean[] multimatchEvents = multimatchState[i].getEventArray();
                rowDataRaw.put(this.variablesArray[i], multimatchEvents);
                if (this.aggregationService == null) continue;
                EventBean[] eventsPerStream = entry.getEventsPerStream();
                EventBean[] arr$ = multimatchEvents;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    EventBean multimatchEvent;
                    eventsPerStream[i] = multimatchEvent = arr$[i$];
                    this.aggregationService.applyEnter(eventsPerStream, i, this.agentInstanceContext);
                }
            }
        }
        EventBean rowRaw = this.agentInstanceContext.getStatementContext().getEventAdapterService().adapterForTypedMap(rowDataRaw, this.compositeEventType);
        HashMap<String, Object> row = new HashMap<String, Object>();
        int columnNum = 0;
        for (ExprEvaluator expression : this.columnEvaluators) {
            Object result = expression.evaluate(new EventBean[]{rowRaw}, true, this.agentInstanceContext);
            row.put(this.columnNames[columnNum], result);
            ++columnNum;
        }
        return this.agentInstanceContext.getStatementContext().getEventAdapterService().adapterForTypedMap(row, this.rowEventType);
    }

    private void scheduleCallback(long msecAfterCurrentTime, RegexNFAStateEntry endState) {
        long matchBeginTime = endState.getMatchBeginEventTime();
        if (this.schedule.isEmpty()) {
            this.schedule.put(matchBeginTime, endState);
            this.agentInstanceContext.getStatementContext().getSchedulingService().add(msecAfterCurrentTime, (ScheduleHandle)this.handle, this.scheduleSlot);
        } else {
            Object value = this.schedule.get(matchBeginTime);
            if (value == null) {
                long currentFirstKey = this.schedule.firstKey();
                if (currentFirstKey > matchBeginTime) {
                    this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
                    this.agentInstanceContext.getStatementContext().getSchedulingService().add(msecAfterCurrentTime, (ScheduleHandle)this.handle, this.scheduleSlot);
                }
                this.schedule.put(matchBeginTime, endState);
            } else if (value instanceof RegexNFAStateEntry) {
                RegexNFAStateEntry valueEntry = (RegexNFAStateEntry)value;
                ArrayList<RegexNFAStateEntry> list = new ArrayList<RegexNFAStateEntry>();
                list.add(valueEntry);
                list.add(endState);
                this.schedule.put(matchBeginTime, list);
            } else {
                List list = (List)value;
                list.add(endState);
            }
        }
    }

    private void triggered() {
        long cutOffTime;
        long firstKey;
        long currentTime = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
        if (this.schedule.isEmpty()) {
            return;
        }
        List<RegexNFAStateEntry> indicatables = new ArrayList<RegexNFAStateEntry>();
        while ((firstKey = this.schedule.firstKey().longValue()) <= (cutOffTime = currentTime - this.matchRecognizeSpec.getInterval().getMSec())) {
            Object value = this.schedule.remove(firstKey);
            if (value instanceof RegexNFAStateEntry) {
                indicatables.add((RegexNFAStateEntry)value);
            } else {
                List list = (List)value;
                indicatables.addAll(list);
            }
            if (!this.schedule.isEmpty()) continue;
            break;
        }
        if (!this.schedule.isEmpty()) {
            long msecAfterCurrentTime = this.schedule.firstKey() + this.matchRecognizeSpec.getInterval().getMSec() - this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
            this.agentInstanceContext.getStatementContext().getSchedulingService().add(msecAfterCurrentTime, (ScheduleHandle)this.handle, this.scheduleSlot);
        }
        if (!this.matchRecognizeSpec.isAllMatches()) {
            indicatables = this.rankEndStatesMultiPartition(indicatables);
        }
        EventBean[] out = new EventBean[indicatables.size()];
        int count = 0;
        for (RegexNFAStateEntry endState : indicatables) {
            out[count++] = this.generateOutputRow(endState);
        }
        this.updateChildren(out, null);
    }
}

