/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.rowregex;

import com.espertech.esper.client.EventType;
import com.espertech.esper.client.annotation.HintEnum;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.ExprEvaluatorContextStatement;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.agg.AggregationServiceAggExpressionDesc;
import com.espertech.esper.epl.agg.AggregationServiceFactoryFactory;
import com.espertech.esper.epl.agg.AggregationServiceMatchRecognize;
import com.espertech.esper.epl.agg.AggregationServiceMatchRecognizeFactoryDesc;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.expression.ExprAggregateNode;
import com.espertech.esper.epl.expression.ExprAggregateNodeUtil;
import com.espertech.esper.epl.expression.ExprConstantNodeImpl;
import com.espertech.esper.epl.expression.ExprIdentNode;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeIdentifierCollectVisitor;
import com.espertech.esper.epl.expression.ExprNodeIdentifierVisitor;
import com.espertech.esper.epl.expression.ExprNodePreviousVisitorWParent;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprNodeValidated;
import com.espertech.esper.epl.expression.ExprPreviousMatchRecognizeNode;
import com.espertech.esper.epl.expression.ExprPreviousNode;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.expression.ExprValidationPropertyException;
import com.espertech.esper.epl.spec.MatchRecognizeDefineItem;
import com.espertech.esper.epl.spec.MatchRecognizeMeasureItem;
import com.espertech.esper.epl.spec.MatchRecognizeSpec;
import com.espertech.esper.rowregex.EventRowRegexHelper;
import com.espertech.esper.rowregex.EventRowRegexNFAView;
import com.espertech.esper.util.CollectionUtil;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryChain;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewParameterException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class EventRowRegexNFAViewFactory
extends ViewFactorySupport {
    private final MatchRecognizeSpec matchRecognizeSpec;
    private final LinkedHashMap<String, Pair<Integer, Boolean>> variableStreams;
    private final Map<Integer, String> streamVariables;
    private final Set<String> variablesSingle;
    private final EventType compositeEventType;
    private final EventType rowEventType;
    private final AggregationServiceMatchRecognize aggregationService;
    private final List<AggregationServiceAggExpressionDesc> aggregationExpressions;
    private final TreeMap<Integer, List<ExprPreviousMatchRecognizeNode>> callbacksPerIndex = new TreeMap();
    private final boolean isUnbound;
    private final boolean isIterateOnly;
    private final boolean isSelectAsksMultimatches;

    public EventRowRegexNFAViewFactory(ViewFactoryChain viewChain, MatchRecognizeSpec matchRecognizeSpec, AgentInstanceContext agentInstanceContext, boolean isUnbound, Annotation[] annotations) throws ExprValidationException {
        Serializable validated;
        EventType parentViewType = viewChain.getEventType();
        this.matchRecognizeSpec = matchRecognizeSpec;
        this.isUnbound = isUnbound;
        this.isIterateOnly = HintEnum.ITERATE_ONLY.getHint(annotations) != null;
        StatementContext statementContext = agentInstanceContext.getStatementContext();
        this.variablesSingle = new LinkedHashSet<String>();
        LinkedHashSet<String> variablesMultiple = new LinkedHashSet<String>();
        EventRowRegexHelper.recursiveInspectVariables(matchRecognizeSpec.getPattern(), false, this.variablesSingle, variablesMultiple);
        int streamNum = 0;
        this.variableStreams = new LinkedHashMap();
        for (String string : this.variablesSingle) {
            this.variableStreams.put(string, new Pair<Integer, Boolean>(streamNum, false));
            ++streamNum;
        }
        for (String string : variablesMultiple) {
            this.variableStreams.put(string, new Pair<Integer, Boolean>(streamNum, true));
            ++streamNum;
        }
        this.streamVariables = new TreeMap<Integer, String>();
        for (Map.Entry entry : this.variableStreams.entrySet()) {
            this.streamVariables.put((Integer)((Pair)entry.getValue()).getFirst(), (String)entry.getKey());
        }
        String[] singleVarStreamNames = new String[this.variableStreams.size()];
        String[] stringArray = new String[this.variableStreams.size()];
        EventType[] singleVarTypes = new EventType[this.variableStreams.size()];
        EventType[] allTypes = new EventType[this.variableStreams.size()];
        streamNum = 0;
        Iterator<String> i$ = this.variablesSingle.iterator();
        while (i$.hasNext()) {
            String variableSingle;
            singleVarStreamNames[streamNum] = variableSingle = i$.next();
            singleVarTypes[streamNum] = parentViewType;
            stringArray[streamNum] = variableSingle;
            allTypes[streamNum] = parentViewType;
            ++streamNum;
        }
        i$ = variablesMultiple.iterator();
        while (i$.hasNext()) {
            String variableMultiple;
            stringArray[streamNum] = variableMultiple = i$.next();
            allTypes[streamNum] = parentViewType;
            ++streamNum;
        }
        HashSet<String> definedVariables = new HashSet<String>();
        ArrayList<ExprAggregateNode> aggregateNodes = new ArrayList<ExprAggregateNode>();
        ExprEvaluatorContextStatement exprEvaluatorContext = new ExprEvaluatorContextStatement(statementContext);
        for (MatchRecognizeDefineItem defineItem : matchRecognizeSpec.getDefines()) {
            if (definedVariables.contains(defineItem.getIdentifier())) {
                throw new ExprValidationException("Variable '" + defineItem.getIdentifier() + "' has already been defined");
            }
            definedVariables.add(defineItem.getIdentifier());
            String[] streamNamesDefine = new String[singleVarStreamNames.length];
            System.arraycopy(singleVarStreamNames, 0, streamNamesDefine, 0, singleVarStreamNames.length);
            EventType[] typesDefine = new EventType[singleVarTypes.length];
            System.arraycopy(singleVarTypes, 0, typesDefine, 0, singleVarTypes.length);
            boolean[] isIStreamOnly = new boolean[singleVarTypes.length];
            Arrays.fill(isIStreamOnly, true);
            if (!this.variableStreams.containsKey(defineItem.getIdentifier())) {
                throw new ExprValidationException("Variable '" + defineItem.getIdentifier() + "' does not occur in pattern");
            }
            int streamNumDefine = this.variableStreams.get(defineItem.getIdentifier()).getFirst();
            streamNamesDefine[streamNumDefine] = defineItem.getIdentifier();
            typesDefine[streamNumDefine] = parentViewType;
            StreamTypeServiceImpl typeServiceDefines = new StreamTypeServiceImpl(typesDefine, streamNamesDefine, isIStreamOnly, statementContext.getEngineURI(), false);
            ExprNode exprNodeResult = this.handlePreviousFunctions(defineItem.getExpression());
            ExprValidationContext validationContext = new ExprValidationContext(typeServiceDefines, statementContext.getMethodResolutionService(), null, statementContext.getSchedulingService(), statementContext.getVariableService(), exprEvaluatorContext, statementContext.getEventAdapterService(), statementContext.getStatementName(), statementContext.getStatementId(), statementContext.getAnnotations(), statementContext.getContextDescriptor());
            validated = ExprNodeUtility.getValidatedSubtree(exprNodeResult, validationContext);
            defineItem.setExpression((ExprNode)validated);
            ExprAggregateNodeUtil.getAggregatesBottomUp((ExprNode)validated, aggregateNodes);
            if (aggregateNodes.isEmpty()) continue;
            throw new ExprValidationException("An aggregate function may not appear in a DEFINE clause");
        }
        LinkedHashMap<String, Object> measureTypeDef = new LinkedHashMap<String, Object>();
        for (String variableSingle : this.variablesSingle) {
            measureTypeDef.put(variableSingle, parentViewType);
        }
        for (String variableMultiple : variablesMultiple) {
            measureTypeDef.put(variableMultiple, new EventType[]{parentViewType});
        }
        String outputEventTypeName = statementContext.getStatementId() + "_rowrecog";
        this.compositeEventType = statementContext.getEventAdapterService().createAnonymousMapType(outputEventTypeName, measureTypeDef);
        StreamTypeServiceImpl typeServiceMeasure = new StreamTypeServiceImpl(this.compositeEventType, "MATCH_RECOGNIZE", true, statementContext.getEngineURI());
        boolean measureReferencesMultivar = false;
        ArrayList<ExprAggregateNode> measureAggregateExprNodes = new ArrayList<ExprAggregateNode>();
        for (MatchRecognizeMeasureItem measureItem : matchRecognizeSpec.getMeasures()) {
            ExprAggregateNodeUtil.getAggregatesBottomUp(measureItem.getExpr(), measureAggregateExprNodes);
        }
        if (!measureAggregateExprNodes.isEmpty()) {
            boolean[] isIStreamOnly = new boolean[stringArray.length];
            Arrays.fill(isIStreamOnly, true);
            StreamTypeServiceImpl typeServiceAggregateMeasure = new StreamTypeServiceImpl(allTypes, stringArray, isIStreamOnly, statementContext.getEngineURI(), false);
            HashMap<Integer, List<ExprAggregateNode>> measureExprAggNodesPerStream = new HashMap<Integer, List<ExprAggregateNode>>();
            for (ExprAggregateNode aggregateNode : measureAggregateExprNodes) {
                int count = 0;
                ExprNodeIdentifierVisitor visitor = new ExprNodeIdentifierVisitor(true);
                ExprValidationContext validationContext = new ExprValidationContext(typeServiceAggregateMeasure, statementContext.getMethodResolutionService(), null, statementContext.getSchedulingService(), statementContext.getVariableService(), exprEvaluatorContext, statementContext.getEventAdapterService(), statementContext.getStatementName(), statementContext.getStatementId(), statementContext.getAnnotations(), statementContext.getContextDescriptor());
                for (ExprNode child : aggregateNode.getChildNodes()) {
                    ExprNode validated2 = ExprNodeUtility.getValidatedSubtree(child, validationContext);
                    validated2.accept(visitor);
                    aggregateNode.getChildNodes().set(count++, new ExprNodeValidated(validated2));
                }
                validationContext = new ExprValidationContext(typeServiceMeasure, statementContext.getMethodResolutionService(), null, statementContext.getSchedulingService(), statementContext.getVariableService(), exprEvaluatorContext, statementContext.getEventAdapterService(), statementContext.getStatementName(), statementContext.getStatementId(), statementContext.getAnnotations(), statementContext.getContextDescriptor());
                aggregateNode.validate(validationContext);
                HashSet<Integer> aggregatedStreams = new HashSet<Integer>();
                for (Pair<Integer, String> pair : visitor.getExprProperties()) {
                    aggregatedStreams.add(pair.getFirst());
                }
                Integer multipleVarStream = null;
                Iterator i$2 = aggregatedStreams.iterator();
                while (i$2.hasNext()) {
                    int streamNumAggregated = (Integer)i$2.next();
                    String variable = this.streamVariables.get(streamNumAggregated);
                    if (!variablesMultiple.contains(variable)) continue;
                    measureReferencesMultivar = true;
                    if (multipleVarStream == null) {
                        multipleVarStream = streamNumAggregated;
                        continue;
                    }
                    throw new ExprValidationException("Aggregation functions in the measure-clause must only refer to properties of exactly one group variable returning multiple events");
                }
                if (multipleVarStream == null) {
                    throw new ExprValidationException("Aggregation functions in the measure-clause must refer to one or more properties of exactly one group variable returning multiple events");
                }
                ArrayList<ExprAggregateNode> aggNodesForStream = (ArrayList<ExprAggregateNode>)measureExprAggNodesPerStream.get(multipleVarStream);
                if (aggNodesForStream == null) {
                    aggNodesForStream = new ArrayList<ExprAggregateNode>();
                    measureExprAggNodesPerStream.put(multipleVarStream, aggNodesForStream);
                }
                aggNodesForStream.add(aggregateNode);
            }
            AggregationServiceMatchRecognizeFactoryDesc factoryDesc = AggregationServiceFactoryFactory.getServiceMatchRecognize(this.streamVariables.size(), measureExprAggNodesPerStream, statementContext.getMethodResolutionService(), exprEvaluatorContext);
            this.aggregationService = factoryDesc.getAggregationServiceFactory().makeService(agentInstanceContext);
            this.aggregationExpressions = factoryDesc.getExpressions();
        } else {
            this.aggregationService = null;
            this.aggregationExpressions = Collections.emptyList();
        }
        LinkedHashMap<String, Object> rowTypeDef = new LinkedHashMap<String, Object>();
        ExprNodeIdentifierCollectVisitor streamRefVisitorNonAgg = new ExprNodeIdentifierCollectVisitor();
        for (MatchRecognizeMeasureItem measureItem : matchRecognizeSpec.getMeasures()) {
            if (measureItem.getName() == null) {
                throw new ExprValidationException("The measures clause requires that each expression utilizes the AS keyword to assign a column name");
            }
            validated = this.validateMeasureClause(measureItem.getExpr(), typeServiceMeasure, variablesMultiple, this.variablesSingle, statementContext);
            measureItem.setExpr((ExprNode)validated);
            rowTypeDef.put(measureItem.getName(), validated.getExprEvaluator().getType());
            validated.accept(streamRefVisitorNonAgg);
        }
        for (ExprIdentNode ref : streamRefVisitorNonAgg.getExprProperties()) {
            String rootPropName = ref.getResolvedPropertyNameRoot();
            if (!variablesMultiple.contains(rootPropName) && rootPropName != null) continue;
            measureReferencesMultivar = true;
            break;
        }
        this.isSelectAsksMultimatches = measureReferencesMultivar;
        String rowEventTypeName = statementContext.getStatementId() + "_rowrecogrow";
        this.rowEventType = statementContext.getEventAdapterService().createAnonymousMapType(rowEventTypeName, rowTypeDef);
        if (!matchRecognizeSpec.getPartitionByExpressions().isEmpty()) {
            StreamTypeServiceImpl typeServicePartition = new StreamTypeServiceImpl(parentViewType, "MATCH_RECOGNIZE_PARTITION", true, statementContext.getEngineURI());
            validated = new ArrayList();
            ExprValidationContext validationContext = new ExprValidationContext(typeServicePartition, statementContext.getMethodResolutionService(), null, statementContext.getSchedulingService(), statementContext.getVariableService(), exprEvaluatorContext, statementContext.getEventAdapterService(), statementContext.getStatementName(), statementContext.getStatementId(), statementContext.getAnnotations(), statementContext.getContextDescriptor());
            for (ExprNode partitionExpr : matchRecognizeSpec.getPartitionByExpressions()) {
                validated.add(ExprNodeUtility.getValidatedSubtree(partitionExpr, validationContext));
            }
            matchRecognizeSpec.setPartitionByExpressions((List<ExprNode>)((Object)validated));
        }
    }

    private ExprNode validateMeasureClause(ExprNode measureNode, StreamTypeService typeServiceMeasure, Set<String> variablesMultiple, Set<String> variablesSingle, StatementContext statementContext) throws ExprValidationException {
        try {
            ExprEvaluatorContextStatement exprEvaluatorContext = new ExprEvaluatorContextStatement(statementContext);
            ExprValidationContext validationContext = new ExprValidationContext(typeServiceMeasure, statementContext.getMethodResolutionService(), null, statementContext.getSchedulingService(), statementContext.getVariableService(), exprEvaluatorContext, statementContext.getEventAdapterService(), statementContext.getStatementName(), statementContext.getStatementId(), statementContext.getAnnotations(), statementContext.getContextDescriptor());
            return ExprNodeUtility.getValidatedSubtree(measureNode, validationContext);
        }
        catch (ExprValidationPropertyException e) {
            String grouped = CollectionUtil.toString(variablesMultiple);
            String single = CollectionUtil.toString(variablesSingle);
            String message = e.getMessage();
            if (!variablesMultiple.isEmpty()) {
                message = message + ", ensure that grouped variables (variables " + grouped + ") are accessed via index (i.e. variable[0].string) or appear within an aggregation";
            }
            if (!variablesSingle.isEmpty()) {
                message = message + ", ensure that singleton variables (variables " + single + ") are not accessed via index";
            }
            throw new ExprValidationPropertyException(message, e);
        }
    }

    private ExprNode handlePreviousFunctions(ExprNode defineItemExpression) throws ExprValidationException {
        ExprNodePreviousVisitorWParent previousVisitor = new ExprNodePreviousVisitorWParent();
        defineItemExpression.accept(previousVisitor);
        if (previousVisitor.getPrevious() == null) {
            return defineItemExpression;
        }
        for (Pair<ExprNode, ExprPreviousNode> previousNodePair : previousVisitor.getPrevious()) {
            ExprPreviousNode previousNode = previousNodePair.getSecond();
            ExprPreviousMatchRecognizeNode matchRecogPrevNode = new ExprPreviousMatchRecognizeNode();
            if (previousNodePair.getSecond().getChildNodes().size() == 1) {
                matchRecogPrevNode.addChildNode(previousNode.getChildNodes().get(0));
                matchRecogPrevNode.addChildNode(new ExprConstantNodeImpl(1));
            } else if (previousNodePair.getSecond().getChildNodes().size() == 2) {
                ExprNode first = previousNode.getChildNodes().get(0);
                ExprNode second = previousNode.getChildNodes().get(1);
                if (first.isConstantResult() && !second.isConstantResult()) {
                    matchRecogPrevNode.addChildNode(second);
                    matchRecogPrevNode.addChildNode(first);
                } else if (!first.isConstantResult() && second.isConstantResult()) {
                    matchRecogPrevNode.addChildNode(first);
                    matchRecogPrevNode.addChildNode(second);
                } else {
                    throw new ExprValidationException("PREV operator requires a constant index");
                }
            }
            if (previousNodePair.getFirst() == null) {
                defineItemExpression = matchRecogPrevNode;
            } else {
                ExprNodeUtility.replaceChildNode(previousNodePair.getFirst(), previousNodePair.getSecond(), matchRecogPrevNode);
            }
            int index = matchRecogPrevNode.getConstantIndexNumber();
            List<ExprPreviousMatchRecognizeNode> callbackList = this.callbacksPerIndex.get(index);
            if (callbackList == null) {
                callbackList = new ArrayList<ExprPreviousMatchRecognizeNode>();
                this.callbacksPerIndex.put(index, callbackList);
            }
            callbackList.add(matchRecogPrevNode);
        }
        return defineItemExpression;
    }

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> viewParameters) throws ViewParameterException {
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
    }

    @Override
    public View makeView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        return new EventRowRegexNFAView(this.compositeEventType, this.rowEventType, this.matchRecognizeSpec, this.variableStreams, this.streamVariables, this.variablesSingle, agentInstanceViewFactoryContext.getAgentInstanceContext(), this.callbacksPerIndex, this.aggregationService, this.isUnbound, this.isIterateOnly, this.isSelectAsksMultimatches);
    }

    @Override
    public EventType getEventType() {
        return this.rowEventType;
    }

    public List<AggregationServiceAggExpressionDesc> getAggregationExpressions() {
        return this.aggregationExpressions;
    }

    public AggregationServiceMatchRecognize getAggregationService() {
        return this.aggregationService;
    }
}

