/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.schedule;

import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScheduleHandleCallbackProxy
implements InvocationHandler {
    private static final Log auditLog = LogFactory.getLog((String)"com.espertech.esper.audit");
    private static Method target = JavaClassHelper.getMethodByName(ScheduleHandleCallback.class, "scheduledTrigger");
    private final String statementName;
    private final ScheduleHandleCallback scheduleHandleCallback;

    public static Object newInstance(String statementName, ScheduleHandleCallback scheduleHandleCallback) {
        return Proxy.newProxyInstance(scheduleHandleCallback.getClass().getClassLoader(), JavaClassHelper.getSuperInterfaces(scheduleHandleCallback.getClass()), (InvocationHandler)new ScheduleHandleCallbackProxy(statementName, scheduleHandleCallback));
    }

    public ScheduleHandleCallbackProxy(String statementName, ScheduleHandleCallback scheduleHandleCallback) {
        this.statementName = statementName;
        this.scheduleHandleCallback = scheduleHandleCallback;
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        if (m.getName().equals(target.getName()) && auditLog.isInfoEnabled()) {
            StringWriter message = new StringWriter();
            message.write("Statement ");
            message.write(this.statementName);
            message.write(" schedule trigger handle ");
            JavaClassHelper.writeInstance(message, this.scheduleHandleCallback, true);
            auditLog.info((Object)message);
        }
        return m.invoke((Object)this.scheduleHandleCallback, args);
    }
}

