/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.type;

import com.espertech.esper.collection.MultiKey;
import java.util.HashMap;
import java.util.Map;

public enum BitWiseOpEnum {
    BAND("&"),
    BOR("|"),
    BXOR("^");

    private static Map<MultiKey<Object>, Computer> computers;
    private String expressionText;

    private BitWiseOpEnum(String expressionText) {
        this.expressionText = expressionText;
    }

    public String getExpressionText() {
        return this.expressionText;
    }

    public Computer getComputer(Class coercedType) {
        if (coercedType != Byte.class && coercedType != Short.class && coercedType != Integer.class && coercedType != Long.class && coercedType != Boolean.class) {
            throw new IllegalArgumentException("Expected base numeric or boolean type for computation result but got type " + coercedType);
        }
        MultiKey<Object> key = new MultiKey<Object>(new Object[]{coercedType, this});
        return computers.get(key);
    }

    public String getComputeDescription() {
        return this.expressionText;
    }

    static {
        computers = new HashMap<MultiKey<Object>, Computer>();
        computers.put(new MultiKey<Object>(new Object[]{Byte.class, BAND}), new BAndByte());
        computers.put(new MultiKey<Object>(new Object[]{Short.class, BAND}), new BAndShort());
        computers.put(new MultiKey<Object>(new Object[]{Integer.class, BAND}), new BAndInt());
        computers.put(new MultiKey<Object>(new Object[]{Long.class, BAND}), new BAndLong());
        computers.put(new MultiKey<Object>(new Object[]{Boolean.class, BAND}), new BAndBoolean());
        computers.put(new MultiKey<Object>(new Object[]{Byte.class, BOR}), new BOrByte());
        computers.put(new MultiKey<Object>(new Object[]{Short.class, BOR}), new BOrShort());
        computers.put(new MultiKey<Object>(new Object[]{Integer.class, BOR}), new BOrInt());
        computers.put(new MultiKey<Object>(new Object[]{Long.class, BOR}), new BOrLong());
        computers.put(new MultiKey<Object>(new Object[]{Boolean.class, BOR}), new BOrBoolean());
        computers.put(new MultiKey<Object>(new Object[]{Byte.class, BXOR}), new BXorByte());
        computers.put(new MultiKey<Object>(new Object[]{Short.class, BXOR}), new BXorShort());
        computers.put(new MultiKey<Object>(new Object[]{Integer.class, BXOR}), new BXorInt());
        computers.put(new MultiKey<Object>(new Object[]{Long.class, BXOR}), new BXorLong());
        computers.put(new MultiKey<Object>(new Object[]{Boolean.class, BXOR}), new BXorBoolean());
    }

    public static class BXorBoolean
    implements Computer {
        @Override
        public Object compute(Object objOne, Object objTwo) {
            Boolean b1 = (Boolean)objOne;
            Boolean b2 = (Boolean)objTwo;
            return b1 ^ b2;
        }
    }

    public static class BOrBoolean
    implements Computer {
        @Override
        public Object compute(Object objOne, Object objTwo) {
            Boolean b1 = (Boolean)objOne;
            Boolean b2 = (Boolean)objTwo;
            return b1 | b2;
        }
    }

    public static class BAndBoolean
    implements Computer {
        @Override
        public Object compute(Object objOne, Object objTwo) {
            Boolean b1 = (Boolean)objOne;
            Boolean b2 = (Boolean)objTwo;
            return b1 & b2;
        }
    }

    public static class BXorLong
    implements Computer {
        @Override
        public Object compute(Object objOne, Object objTwo) {
            Long n1 = (Long)objOne;
            Long n2 = (Long)objTwo;
            return n1 ^ n2;
        }
    }

    public static class BOrLong
    implements Computer {
        @Override
        public Object compute(Object objOne, Object objTwo) {
            Long n1 = (Long)objOne;
            Long n2 = (Long)objTwo;
            return n1 | n2;
        }
    }

    public static class BAndLong
    implements Computer {
        @Override
        public Object compute(Object objOne, Object objTwo) {
            Long n1 = (Long)objOne;
            Long n2 = (Long)objTwo;
            return n1 & n2;
        }
    }

    public static class BXorInt
    implements Computer {
        @Override
        public Object compute(Object objOne, Object objTwo) {
            Integer n1 = (Integer)objOne;
            Integer n2 = (Integer)objTwo;
            return n1 ^ n2;
        }
    }

    public static class BOrInt
    implements Computer {
        @Override
        public Object compute(Object objOne, Object objTwo) {
            Integer n1 = (Integer)objOne;
            Integer n2 = (Integer)objTwo;
            return n1 | n2;
        }
    }

    public static class BAndInt
    implements Computer {
        @Override
        public Object compute(Object objOne, Object objTwo) {
            Integer n1 = (Integer)objOne;
            Integer n2 = (Integer)objTwo;
            return n1 & n2;
        }
    }

    public static class BXorShort
    implements Computer {
        @Override
        public Object compute(Object objOne, Object objTwo) {
            Short n1 = (Short)objOne;
            Short n2 = (Short)objTwo;
            return (short)(n1 ^ n2);
        }
    }

    public static class BOrShort
    implements Computer {
        @Override
        public Object compute(Object objOne, Object objTwo) {
            Short n1 = (Short)objOne;
            Short n2 = (Short)objTwo;
            return (short)(n1 | n2);
        }
    }

    public static class BAndShort
    implements Computer {
        @Override
        public Object compute(Object objOne, Object objTwo) {
            Short n1 = (Short)objOne;
            Short n2 = (Short)objTwo;
            return (short)(n1 & n2);
        }
    }

    public static class BXorByte
    implements Computer {
        @Override
        public Object compute(Object objOne, Object objTwo) {
            Byte n1 = (Byte)objOne;
            Byte n2 = (Byte)objTwo;
            return (byte)(n1 ^ n2);
        }
    }

    public static class BOrByte
    implements Computer {
        @Override
        public Object compute(Object objOne, Object objTwo) {
            Byte n1 = (Byte)objOne;
            Byte n2 = (Byte)objTwo;
            return (byte)(n1 | n2);
        }
    }

    public static class BAndByte
    implements Computer {
        @Override
        public Object compute(Object objOne, Object objTwo) {
            Byte n1 = (Byte)objOne;
            Byte n2 = (Byte)objTwo;
            return (byte)(n1 & n2);
        }
    }

    public static interface Computer {
        public Object compute(Object var1, Object var2);
    }
}

