/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.type;

import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.util.SimpleNumberBigDecimalCoercer;
import com.espertech.esper.util.SimpleNumberBigIntegerCoercer;
import com.espertech.esper.util.SimpleNumberCoercerFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public enum RelationalOpEnum {
    GT(">"),
    GE(">="),
    LT("<"),
    LE("<=");

    private static Map<MultiKey<Object>, Computer> computers;
    private String expressionText;

    private RelationalOpEnum(String expressionText) {
        this.expressionText = expressionText;
    }

    public RelationalOpEnum reversed() {
        if (GT == this) {
            return LT;
        }
        if (GE == this) {
            return LE;
        }
        if (LE == this) {
            return GE;
        }
        return GT;
    }

    public static RelationalOpEnum parse(String op) {
        if (op.equals("<")) {
            return LT;
        }
        if (op.equals(">")) {
            return GT;
        }
        if (op.equals(">=") || op.equals("=>")) {
            return GE;
        }
        if (op.equals("<=") || op.equals("=<")) {
            return LE;
        }
        throw new IllegalArgumentException("Invalid relational operator '" + op + "'");
    }

    public Computer getComputer(Class coercedType, Class typeOne, Class typeTwo) {
        if (coercedType != Double.class && coercedType != Float.class && coercedType != Integer.class && coercedType != Long.class && coercedType != String.class && coercedType != BigDecimal.class && coercedType != BigInteger.class) {
            throw new IllegalArgumentException("Unsupported type for relational op compare, type " + coercedType);
        }
        if (coercedType == BigDecimal.class) {
            return this.makeBigDecimalComputer(typeOne, typeTwo);
        }
        if (coercedType == BigInteger.class) {
            return this.makeBigIntegerComputer(typeOne, typeTwo);
        }
        MultiKey<Object> key = new MultiKey<Object>(new Object[]{coercedType, this});
        return computers.get(key);
    }

    private Computer makeBigDecimalComputer(Class typeOne, Class typeTwo) {
        if (typeOne == BigDecimal.class && typeTwo == BigDecimal.class) {
            return computers.get(new MultiKey<Object>(new Object[]{BigDecimal.class, this}));
        }
        SimpleNumberBigDecimalCoercer convertorOne = SimpleNumberCoercerFactory.getCoercerBigDecimal(typeOne);
        SimpleNumberBigDecimalCoercer convertorTwo = SimpleNumberCoercerFactory.getCoercerBigDecimal(typeTwo);
        if (this == GT) {
            return new GTBigDecConvComputer(convertorOne, convertorTwo);
        }
        if (this == LT) {
            return new LTBigDecConvComputer(convertorOne, convertorTwo);
        }
        if (this == GE) {
            return new GEBigDecConvComputer(convertorOne, convertorTwo);
        }
        return new LEBigDecConvComputer(convertorOne, convertorTwo);
    }

    private Computer makeBigIntegerComputer(Class typeOne, Class typeTwo) {
        if (typeOne == BigInteger.class && typeTwo == BigInteger.class) {
            return computers.get(new MultiKey<Object>(new Object[]{BigInteger.class, this}));
        }
        SimpleNumberBigIntegerCoercer convertorOne = SimpleNumberCoercerFactory.getCoercerBigInteger(typeOne);
        SimpleNumberBigIntegerCoercer convertorTwo = SimpleNumberCoercerFactory.getCoercerBigInteger(typeTwo);
        if (this == GT) {
            return new GTBigIntConvComputer(convertorOne, convertorTwo);
        }
        if (this == LT) {
            return new LTBigIntConvComputer(convertorOne, convertorTwo);
        }
        if (this == GE) {
            return new GEBigIntConvComputer(convertorOne, convertorTwo);
        }
        return new LEBigIntConvComputer(convertorOne, convertorTwo);
    }

    public String getExpressionText() {
        return this.expressionText;
    }

    static {
        computers = new HashMap<MultiKey<Object>, Computer>();
        computers.put(new MultiKey<Object>(new Object[]{String.class, GT}), new GTStringComputer());
        computers.put(new MultiKey<Object>(new Object[]{String.class, GE}), new GEStringComputer());
        computers.put(new MultiKey<Object>(new Object[]{String.class, LT}), new LTStringComputer());
        computers.put(new MultiKey<Object>(new Object[]{String.class, LE}), new LEStringComputer());
        computers.put(new MultiKey<Object>(new Object[]{Integer.class, GT}), new GTIntegerComputer());
        computers.put(new MultiKey<Object>(new Object[]{Integer.class, GE}), new GEIntegerComputer());
        computers.put(new MultiKey<Object>(new Object[]{Integer.class, LT}), new LTIntegerComputer());
        computers.put(new MultiKey<Object>(new Object[]{Integer.class, LE}), new LEIntegerComputer());
        computers.put(new MultiKey<Object>(new Object[]{Long.class, GT}), new GTLongComputer());
        computers.put(new MultiKey<Object>(new Object[]{Long.class, GE}), new GELongComputer());
        computers.put(new MultiKey<Object>(new Object[]{Long.class, LT}), new LTLongComputer());
        computers.put(new MultiKey<Object>(new Object[]{Long.class, LE}), new LELongComputer());
        computers.put(new MultiKey<Object>(new Object[]{Double.class, GT}), new GTDoubleComputer());
        computers.put(new MultiKey<Object>(new Object[]{Double.class, GE}), new GEDoubleComputer());
        computers.put(new MultiKey<Object>(new Object[]{Double.class, LT}), new LTDoubleComputer());
        computers.put(new MultiKey<Object>(new Object[]{Double.class, LE}), new LEDoubleComputer());
        computers.put(new MultiKey<Object>(new Object[]{Float.class, GT}), new GTFloatComputer());
        computers.put(new MultiKey<Object>(new Object[]{Float.class, GE}), new GEFloatComputer());
        computers.put(new MultiKey<Object>(new Object[]{Float.class, LT}), new LTFloatComputer());
        computers.put(new MultiKey<Object>(new Object[]{Float.class, LE}), new LEFloatComputer());
        computers.put(new MultiKey<Object>(new Object[]{BigDecimal.class, GT}), new GTBigDecComputer());
        computers.put(new MultiKey<Object>(new Object[]{BigDecimal.class, GE}), new GEBigDecComputer());
        computers.put(new MultiKey<Object>(new Object[]{BigDecimal.class, LT}), new LTBigDecComputer());
        computers.put(new MultiKey<Object>(new Object[]{BigDecimal.class, LE}), new LEBigDecComputer());
        computers.put(new MultiKey<Object>(new Object[]{BigInteger.class, GT}), new GTBigIntComputer());
        computers.put(new MultiKey<Object>(new Object[]{BigInteger.class, GE}), new GEBigIntComputer());
        computers.put(new MultiKey<Object>(new Object[]{BigInteger.class, LT}), new LTBigIntComputer());
        computers.put(new MultiKey<Object>(new Object[]{BigInteger.class, LE}), new LEBigIntComputer());
    }

    public static class LTBigDecConvComputer
    implements Computer {
        private final SimpleNumberBigDecimalCoercer convOne;
        private final SimpleNumberBigDecimalCoercer convTwo;

        public LTBigDecConvComputer(SimpleNumberBigDecimalCoercer convOne, SimpleNumberBigDecimalCoercer convTwo) {
            this.convOne = convOne;
            this.convTwo = convTwo;
        }

        @Override
        public boolean compare(Object objOne, Object objTwo) {
            BigDecimal s2;
            BigDecimal s1 = this.convOne.coerceBoxedBigDec((Number)objOne);
            return s1.compareTo(s2 = this.convTwo.coerceBoxedBigDec((Number)objTwo)) < 0;
        }
    }

    public static class LEBigDecConvComputer
    implements Computer {
        private final SimpleNumberBigDecimalCoercer convOne;
        private final SimpleNumberBigDecimalCoercer convTwo;

        public LEBigDecConvComputer(SimpleNumberBigDecimalCoercer convOne, SimpleNumberBigDecimalCoercer convTwo) {
            this.convOne = convOne;
            this.convTwo = convTwo;
        }

        @Override
        public boolean compare(Object objOne, Object objTwo) {
            BigDecimal s2;
            BigDecimal s1 = this.convOne.coerceBoxedBigDec((Number)objOne);
            return s1.compareTo(s2 = this.convTwo.coerceBoxedBigDec((Number)objTwo)) <= 0;
        }
    }

    public static class GEBigDecConvComputer
    implements Computer {
        private final SimpleNumberBigDecimalCoercer convOne;
        private final SimpleNumberBigDecimalCoercer convTwo;

        public GEBigDecConvComputer(SimpleNumberBigDecimalCoercer convOne, SimpleNumberBigDecimalCoercer convTwo) {
            this.convOne = convOne;
            this.convTwo = convTwo;
        }

        @Override
        public boolean compare(Object objOne, Object objTwo) {
            BigDecimal s2;
            BigDecimal s1 = this.convOne.coerceBoxedBigDec((Number)objOne);
            return s1.compareTo(s2 = this.convTwo.coerceBoxedBigDec((Number)objTwo)) >= 0;
        }
    }

    public static class GTBigDecConvComputer
    implements Computer {
        private final SimpleNumberBigDecimalCoercer convOne;
        private final SimpleNumberBigDecimalCoercer convTwo;

        public GTBigDecConvComputer(SimpleNumberBigDecimalCoercer convOne, SimpleNumberBigDecimalCoercer convTwo) {
            this.convOne = convOne;
            this.convTwo = convTwo;
        }

        @Override
        public boolean compare(Object objOne, Object objTwo) {
            BigDecimal s2;
            BigDecimal s1 = this.convOne.coerceBoxedBigDec((Number)objOne);
            int result = s1.compareTo(s2 = this.convTwo.coerceBoxedBigDec((Number)objTwo));
            return result > 0;
        }
    }

    public static class LTBigIntConvComputer
    implements Computer {
        private final SimpleNumberBigIntegerCoercer convOne;
        private final SimpleNumberBigIntegerCoercer convTwo;

        public LTBigIntConvComputer(SimpleNumberBigIntegerCoercer convOne, SimpleNumberBigIntegerCoercer convTwo) {
            this.convOne = convOne;
            this.convTwo = convTwo;
        }

        @Override
        public boolean compare(Object objOne, Object objTwo) {
            BigInteger s2;
            BigInteger s1 = this.convOne.coerceBoxedBigInt((Number)objOne);
            return s1.compareTo(s2 = this.convTwo.coerceBoxedBigInt((Number)objTwo)) < 0;
        }
    }

    public static class LEBigIntConvComputer
    implements Computer {
        private final SimpleNumberBigIntegerCoercer convOne;
        private final SimpleNumberBigIntegerCoercer convTwo;

        public LEBigIntConvComputer(SimpleNumberBigIntegerCoercer convOne, SimpleNumberBigIntegerCoercer convTwo) {
            this.convOne = convOne;
            this.convTwo = convTwo;
        }

        @Override
        public boolean compare(Object objOne, Object objTwo) {
            BigInteger s2;
            BigInteger s1 = this.convOne.coerceBoxedBigInt((Number)objOne);
            return s1.compareTo(s2 = this.convTwo.coerceBoxedBigInt((Number)objTwo)) <= 0;
        }
    }

    public static class GEBigIntConvComputer
    implements Computer {
        private final SimpleNumberBigIntegerCoercer convOne;
        private final SimpleNumberBigIntegerCoercer convTwo;

        public GEBigIntConvComputer(SimpleNumberBigIntegerCoercer convOne, SimpleNumberBigIntegerCoercer convTwo) {
            this.convOne = convOne;
            this.convTwo = convTwo;
        }

        @Override
        public boolean compare(Object objOne, Object objTwo) {
            BigInteger s2;
            BigInteger s1 = this.convOne.coerceBoxedBigInt((Number)objOne);
            return s1.compareTo(s2 = this.convTwo.coerceBoxedBigInt((Number)objTwo)) >= 0;
        }
    }

    public static class GTBigIntConvComputer
    implements Computer {
        private final SimpleNumberBigIntegerCoercer convOne;
        private final SimpleNumberBigIntegerCoercer convTwo;

        public GTBigIntConvComputer(SimpleNumberBigIntegerCoercer convOne, SimpleNumberBigIntegerCoercer convTwo) {
            this.convOne = convOne;
            this.convTwo = convTwo;
        }

        @Override
        public boolean compare(Object objOne, Object objTwo) {
            BigInteger s2;
            BigInteger s1 = this.convOne.coerceBoxedBigInt((Number)objOne);
            int result = s1.compareTo(s2 = this.convTwo.coerceBoxedBigInt((Number)objTwo));
            return result > 0;
        }
    }

    public static class LTBigIntComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            BigInteger s1 = (BigInteger)objOne;
            BigInteger s2 = (BigInteger)objTwo;
            return s1.compareTo(s2) < 0;
        }
    }

    public static class LEBigIntComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            BigInteger s1 = (BigInteger)objOne;
            BigInteger s2 = (BigInteger)objTwo;
            return s1.compareTo(s2) <= 0;
        }
    }

    public static class GEBigIntComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            BigInteger s1 = (BigInteger)objOne;
            BigInteger s2 = (BigInteger)objTwo;
            return s1.compareTo(s2) >= 0;
        }
    }

    public static class GTBigIntComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            BigInteger s1 = (BigInteger)objOne;
            BigInteger s2 = (BigInteger)objTwo;
            int result = s1.compareTo(s2);
            return result > 0;
        }
    }

    public static class LTBigDecComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            BigDecimal s1 = (BigDecimal)objOne;
            BigDecimal s2 = (BigDecimal)objTwo;
            return s1.compareTo(s2) < 0;
        }
    }

    public static class LEBigDecComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            BigDecimal s1 = (BigDecimal)objOne;
            BigDecimal s2 = (BigDecimal)objTwo;
            return s1.compareTo(s2) <= 0;
        }
    }

    public static class GEBigDecComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            BigDecimal s1 = (BigDecimal)objOne;
            BigDecimal s2 = (BigDecimal)objTwo;
            return s1.compareTo(s2) >= 0;
        }
    }

    public static class GTBigDecComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            BigDecimal s1 = (BigDecimal)objOne;
            BigDecimal s2 = (BigDecimal)objTwo;
            int result = s1.compareTo(s2);
            return result > 0;
        }
    }

    public static class LEFloatComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            Number s1 = (Number)objOne;
            Number s2 = (Number)objTwo;
            return s1.floatValue() <= s2.floatValue();
        }
    }

    public static class LTFloatComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            Number s1 = (Number)objOne;
            Number s2 = (Number)objTwo;
            return s1.floatValue() < s2.floatValue();
        }
    }

    public static class GEFloatComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            Number s1 = (Number)objOne;
            Number s2 = (Number)objTwo;
            return s1.floatValue() >= s2.floatValue();
        }
    }

    public static class GTFloatComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            Number s1 = (Number)objOne;
            Number s2 = (Number)objTwo;
            return s1.floatValue() > s2.floatValue();
        }
    }

    public static class LEDoubleComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            Number s1 = (Number)objOne;
            Number s2 = (Number)objTwo;
            return s1.doubleValue() <= s2.doubleValue();
        }
    }

    public static class LTDoubleComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            Number s1 = (Number)objOne;
            Number s2 = (Number)objTwo;
            return s1.doubleValue() < s2.doubleValue();
        }
    }

    public static class GEDoubleComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            Number s1 = (Number)objOne;
            Number s2 = (Number)objTwo;
            return s1.doubleValue() >= s2.doubleValue();
        }
    }

    public static class GTDoubleComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            Number s1 = (Number)objOne;
            Number s2 = (Number)objTwo;
            return s1.doubleValue() > s2.doubleValue();
        }
    }

    public static class LEIntegerComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            Number s1 = (Number)objOne;
            Number s2 = (Number)objTwo;
            return s1.intValue() <= s2.intValue();
        }
    }

    public static class LTIntegerComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            Number s1 = (Number)objOne;
            Number s2 = (Number)objTwo;
            return s1.intValue() < s2.intValue();
        }
    }

    public static class GEIntegerComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            Number s1 = (Number)objOne;
            Number s2 = (Number)objTwo;
            return s1.intValue() >= s2.intValue();
        }
    }

    public static class GTIntegerComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            Number s1 = (Number)objOne;
            Number s2 = (Number)objTwo;
            return s1.intValue() > s2.intValue();
        }
    }

    public static class LELongComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            Number s1 = (Number)objOne;
            Number s2 = (Number)objTwo;
            return s1.longValue() <= s2.longValue();
        }
    }

    public static class LTLongComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            Number s1 = (Number)objOne;
            Number s2 = (Number)objTwo;
            return s1.longValue() < s2.longValue();
        }
    }

    public static class GELongComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            Number s1 = (Number)objOne;
            Number s2 = (Number)objTwo;
            return s1.longValue() >= s2.longValue();
        }
    }

    public static class GTLongComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            Number s1 = (Number)objOne;
            Number s2 = (Number)objTwo;
            return s1.longValue() > s2.longValue();
        }
    }

    public static class LTStringComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            String s1 = (String)objOne;
            String s2 = (String)objTwo;
            return s1.compareTo(s2) < 0;
        }
    }

    public static class LEStringComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            String s1 = (String)objOne;
            String s2 = (String)objTwo;
            return s1.compareTo(s2) <= 0;
        }
    }

    public static class GEStringComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            String s1 = (String)objOne;
            String s2 = (String)objTwo;
            return s1.compareTo(s2) >= 0;
        }
    }

    public static class GTStringComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            String s1 = (String)objOne;
            String s2 = (String)objTwo;
            int result = s1.compareTo(s2);
            return result > 0;
        }
    }

    public static interface Computer {
        public boolean compare(Object var1, Object var2);
    }
}

