/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.type;

import com.espertech.esper.type.PrimitiveValueBase;
import com.espertech.esper.type.PrimitiveValueType;

public final class StringValue
extends PrimitiveValueBase {
    private String stringValue;

    public StringValue(String stringValue) {
        this.stringValue = stringValue;
    }

    public StringValue() {
    }

    @Override
    public PrimitiveValueType getType() {
        return PrimitiveValueType.STRING;
    }

    public static String[] parseString(String[] values) {
        String[] result = new String[values.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = StringValue.parseString(values[i]);
        }
        return result;
    }

    @Override
    public final void parse(String value) {
        this.stringValue = StringValue.parseString(value);
    }

    @Override
    public final Object getValueObject() {
        return this.stringValue;
    }

    @Override
    public final void setString(String x) {
        this.stringValue = x;
    }

    public final String toString() {
        if (this.stringValue == null) {
            return "null";
        }
        return this.stringValue;
    }

    public static String parseString(String value) {
        if ((value.startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'")) && value.length() > 1) {
            if (value.indexOf(92) != -1) {
                return StringValue.unescape(value.substring(1, value.length() - 1));
            }
            return value.substring(1, value.length() - 1);
        }
        throw new IllegalArgumentException("String value of '" + value + "' cannot be parsed");
    }

    private static String unescape(String s) {
        int i = 0;
        int len = s.length();
        StringBuffer sb = new StringBuffer(len);
        while (i < len) {
            char c;
            if ((c = s.charAt(i++)) == '\\' && i < len && (c = s.charAt(i++)) == 'u') {
                c = (char)Integer.parseInt(s.substring(i, i + 4), 16);
                i += 4;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

