/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.util;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.NullIterator;
import com.espertech.esper.util.StopCallback;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class CollectionUtil {
    public static final Iterator<EventBean> NULL_EVENT_ITERATOR = new NullIterator<EventBean>();
    public static final SortedMap EMPTY_SORTED_MAP = new TreeMap();
    public static final Set<MultiKey<EventBean>> EMPTY_ROW_SET = new HashSet<MultiKey<EventBean>>();
    public static final EventBean[] EVENT_PER_STREAM_EMPTY = new EventBean[0];
    public static final Set<EventBean> SINGLE_NULL_ROW_EVENT_SET = new HashSet<EventBean>();
    public static final StopCallback STOP_CALLBACK_NONE;

    public static String toString(Collection<Integer> stack, String delimiterChars) {
        if (stack.isEmpty()) {
            return "";
        }
        if (stack.size() == 1) {
            return Integer.toString(stack.iterator().next());
        }
        StringWriter writer = new StringWriter();
        String delimiter = "";
        for (Integer item : stack) {
            writer.append(delimiter);
            writer.append(Integer.toString(item));
            delimiter = delimiterChars;
        }
        return writer.toString();
    }

    public static Object expandAddElement(Object array, Object[] elementsToAdd) {
        Class<?> cl = array.getClass();
        if (!cl.isArray()) {
            return null;
        }
        int length = Array.getLength(array);
        int newLength = length + elementsToAdd.length;
        Class<?> componentType = array.getClass().getComponentType();
        Object newArray = Array.newInstance(componentType, newLength);
        System.arraycopy(array, 0, newArray, 0, length);
        for (int i = 0; i < elementsToAdd.length; ++i) {
            Array.set(newArray, length + i, elementsToAdd[i]);
        }
        return newArray;
    }

    public static int[] addValue(int[] ints, int i) {
        int[] copy = new int[ints.length + 1];
        System.arraycopy(ints, 0, copy, 0, ints.length);
        copy[ints.length] = i;
        return copy;
    }

    public static int findItem(String[] items, String item) {
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].equals(item)) continue;
            return i;
        }
        return -1;
    }

    public static int[] intArray(Set<Integer> set) {
        if (set == null) {
            return new int[0];
        }
        int[] result = new int[set.size()];
        int index = 0;
        for (Integer value : set) {
            result[index++] = value;
        }
        return result;
    }

    public static String[] copySortArray(String[] values) {
        if (values == null) {
            return null;
        }
        Object[] copy = new String[values.length];
        System.arraycopy(values, 0, copy, 0, values.length);
        Arrays.sort(copy);
        return copy;
    }

    public static boolean sortCompare(String[] valuesOne, String[] valuesTwo) {
        if (valuesOne == null) {
            return valuesTwo == null;
        }
        if (valuesTwo == null) {
            return false;
        }
        Object[] copyOne = CollectionUtil.copySortArray(valuesOne);
        Object[] copyTwo = CollectionUtil.copySortArray(valuesTwo);
        return Arrays.equals(copyOne, copyTwo);
    }

    public static <T> String toString(Set<T> set) {
        if (set == null) {
            return "null";
        }
        if (set.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        String delimiter = "";
        for (T t : set) {
            if (t == null) continue;
            buf.append(delimiter);
            buf.append(t);
            delimiter = ", ";
        }
        return buf.toString();
    }

    public static boolean compare(String[] otherIndexProps, String[] thisIndexProps) {
        if (otherIndexProps != null && thisIndexProps != null) {
            return Arrays.equals(otherIndexProps, thisIndexProps);
        }
        return otherIndexProps == null && thisIndexProps == null;
    }

    public static boolean isAllNullArray(Object array) {
        if (array == null) {
            throw new NullPointerException();
        }
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("Expected array but received " + array.getClass());
        }
        for (int i = 0; i < Array.getLength(array); ++i) {
            if (Array.get(array, i) == null) continue;
            return false;
        }
        return true;
    }

    static {
        SINGLE_NULL_ROW_EVENT_SET.add(null);
        STOP_CALLBACK_NONE = new StopCallback(){

            @Override
            public void stop() {
            }
        };
    }
}

