/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManagedReadWriteLock {
    private static final Log log = LogFactory.getLog(ManagedReadWriteLock.class);
    public static final String ACQUIRE_TEXT = "Acquire ";
    public static final String ACQUIRED_TEXT = "Got     ";
    public static final String TRY_TEXT = "Trying  ";
    public static final String RELEASE_TEXT = "Release ";
    public static final String RELEASED_TEXT = "Freed   ";
    private final ReentrantReadWriteLock lock;
    private final String name;

    public ManagedReadWriteLock(String name, boolean isFair) {
        this.name = name;
        this.lock = new ReentrantReadWriteLock(isFair);
    }

    public void acquireWriteLock() {
        this.lock.writeLock().lock();
    }

    public boolean tryWriteLock(long msec) {
        boolean result = false;
        try {
            result = this.lock.writeLock().tryLock(msec, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            log.warn((Object)"Lock wait interupted");
        }
        return result;
    }

    public void releaseWriteLock() {
        this.lock.writeLock().unlock();
    }

    public void acquireReadLock() {
        this.lock.readLock().lock();
    }

    public void releaseReadLock() {
        this.lock.readLock().unlock();
    }
}

