/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ParserTool {
    public static void main(String[] args) {
        if (args.length == 0) {
            throw new RuntimeException("Required filename parameter is not provided");
        }
        String filename = args[0];
        List<String> lines = ParserTool.readFile(filename);
        System.out.println("Read " + lines.size() + " lines read from file " + filename);
        ArrayList<String> result = new ArrayList<String>();
        for (String line : lines) {
            int indexComment = line.indexOf("// ");
            if (indexComment != -1) {
                line = line.substring(0, indexComment);
            }
            if (line.trim().length() == 0) continue;
            result.add(line);
        }
        ParserTool.transformSpecialStateTransition(result);
        Map<String, List<String>> files = ParserTool.transformDFA197Array(filename, result);
        for (Map.Entry<String, List<String>> linesPerFile : files.entrySet()) {
            String filenameToWrite = linesPerFile.getKey();
            ParserTool.writeFile(filenameToWrite, linesPerFile.getValue());
            System.out.println("Wrote " + linesPerFile.getValue().size() + " lines to file " + filenameToWrite);
        }
    }

    public static Map<String, List<String>> transformDFA197Array(String filename, List<String> lines) {
        String regexDFA = "(.*)static final String\\[\\] DFA(.*)_transitionS(.*)";
        int startDFA = ParserTool.findLineNumRegEx(lines, regexDFA, 0);
        if (startDFA == -1) {
            throw new RuntimeException("Failed to find line: " + regexDFA);
        }
        String dfaNum = lines.get(startDFA).split("DFA")[1].substring(0, 3);
        int endDFA = ParserTool.findMethodEndLine(lines, startDFA);
        if (endDFA == -1) {
            throw new RuntimeException("Failed to end of array declaration: " + regexDFA);
        }
        ArrayList<String> dfaDeclBuf = new ArrayList<String>();
        dfaDeclBuf.add("package com.espertech.esper.epl.generated;");
        dfaDeclBuf.add("public class EsperEPL2GrammarParser_DFAS {");
        List<String> dfaDeclaration = ParserTool.getLinesBetween(lines, startDFA, endDFA);
        dfaDeclBuf.addAll(dfaDeclaration);
        dfaDeclBuf.add("};");
        dfaDeclBuf.add("}");
        ParserTool.replaceLines(lines, startDFA, endDFA + 1, Collections.<String>emptyList());
        ParserTool.replaceContent(lines, "DFA" + dfaNum + "_transitionS", "EsperEPL2GrammarParser_DFAS.DFA" + dfaNum + "_transitionS");
        String[] filenameSplit = filename.split("\\.java");
        LinkedHashMap<String, List<String>> items = new LinkedHashMap<String, List<String>>();
        items.put(filename, lines);
        items.put(filenameSplit[0] + "_DFAS.java", dfaDeclBuf);
        return items;
    }

    public static String transform(String text) {
        List<String> lines = ParserTool.textToLines(text);
        ParserTool.transformSpecialStateTransition(lines);
        return ParserTool.linesToText(lines);
    }

    private static void transformSpecialStateTransition(List<String> inputbuf) {
        int caseLineNum;
        int startLineNum = ParserTool.findLineNumStartWith(inputbuf, "public int specialStateTransition", 0);
        if (startLineNum == -1) {
            return;
        }
        int endLineNum = ParserTool.findMethodEndLine(inputbuf, startLineNum);
        if (endLineNum == -1) {
            return;
        }
        int firstCaseLineNum = ParserTool.findLineNumStartWith(inputbuf, "case 0", startLineNum);
        int caseEndLineNum = ParserTool.findLineNumStartWith(inputbuf, "if (state.backtracking>0)", startLineNum);
        List<String> headerLines = ParserTool.getLinesBetween(inputbuf, startLineNum, firstCaseLineNum);
        List<String> trailerLines = ParserTool.getLinesBetween(inputbuf, caseEndLineNum, endLineNum + 1);
        ArrayList caseHandlers = new ArrayList();
        ArrayList methods = new ArrayList();
        int caseNum = 0;
        while ((caseLineNum = ParserTool.findLineNumStartWith(inputbuf, "case " + caseNum + " :", startLineNum)) != -1) {
            int breakLineNum = ParserTool.findLineNumStartWith(inputbuf, "break", caseLineNum);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("  private int sst_" + caseNum + "() {");
            arrayList.add("    int s = -1;");
            arrayList.addAll(ParserTool.getLinesBetween(inputbuf, caseLineNum + 1, breakLineNum - 1));
            arrayList.add("    return s;");
            arrayList.add("  }");
            methods.add(arrayList);
            ArrayList<String> caseHandler = new ArrayList<String>();
            caseHandler.add("  case " + caseNum + ": ");
            caseHandler.add("    s = sst_" + caseNum + "();");
            caseHandler.add("    if ( s>=0 ) return s;");
            caseHandler.add("    break;");
            caseHandlers.add(caseHandler);
            ++caseNum;
        }
        ArrayList<String> replacementMethod = new ArrayList<String>();
        replacementMethod.addAll(headerLines);
        for (List list : caseHandlers) {
            replacementMethod.addAll(list);
        }
        replacementMethod.add("  }");
        replacementMethod.addAll(trailerLines);
        for (List list : methods) {
            replacementMethod.addAll(list);
        }
        ParserTool.replaceLines(inputbuf, startLineNum, endLineNum + 1, replacementMethod);
    }

    private static void replaceContent(List<String> lines, String toReplace, String replaceWith) {
        ArrayList<String> result = new ArrayList<String>();
        for (String line : lines) {
            result.add(line.replace(toReplace, replaceWith));
        }
        lines.clear();
        lines.addAll(result);
    }

    private static void replaceLines(List<String> input, int start, int end, List<String> replacement) {
        int i;
        int count = end - start;
        for (i = 0; i < count; ++i) {
            input.remove(start);
        }
        for (i = 0; i < replacement.size(); ++i) {
            input.add(start + i, replacement.get(i));
        }
    }

    private static List<String> getLinesBetween(List<String> input, int start, int end) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = start; i < end; ++i) {
            result.add(input.get(i));
        }
        return result;
    }

    private static int findMethodEndLine(List<String> lines, int lineNum) {
        int open = 1;
        for (int current = lineNum + 1; current < lines.size(); ++current) {
            String line = lines.get(current);
            for (int c = 0; c < line.length(); ++c) {
                if (line.charAt(c) == '{') {
                    ++open;
                }
                if (line.charAt(c) != '}' || --open != 0) continue;
                return current;
            }
        }
        return -1;
    }

    private static int findLineNumStartWith(List<String> lines, String name, int startIndex) {
        for (int i = startIndex; i < lines.size(); ++i) {
            if (!lines.get(i).trim().startsWith(name)) continue;
            return i;
        }
        return -1;
    }

    private static int findLineNumRegEx(List<String> lines, String regex, int startIndex) {
        for (int i = startIndex; i < lines.size(); ++i) {
            if (!lines.get(i).trim().matches(regex)) continue;
            return i;
        }
        return -1;
    }

    private static void readFile(BufferedReader reader, List<String> list) throws IOException {
        String text;
        while ((text = reader.readLine()) != null) {
            list.add(text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readFile(InputStream is) {
        InputStreamReader isr = new InputStreamReader(is);
        try {
            List<String> list = ParserTool.readFile(isr);
            return list;
        }
        finally {
            try {
                isr.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static List<String> readFile(Reader reader) {
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(reader);
            ParserTool.readFile(bufferedReader, list);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("File not found: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException("IO Error reading file: " + e.getMessage(), e);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException e) {}
        }
        return list;
    }

    public static List<String> readFile(String file) {
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            List<String> list = ParserTool.readFile(fileReader);
            return list;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("File not found: " + e.getMessage(), e);
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static String linesToText(List<String> lines) {
        StringWriter writer = new StringWriter();
        for (String line : lines) {
            writer.append(line).append(System.getProperty("line.separator"));
        }
        return writer.toString();
    }

    public static List<String> textToLines(String input) {
        BufferedReader reader = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            reader = new BufferedReader(new StringReader(input));
            String text = null;
            while ((text = reader.readLine()) != null) {
                list.add(text);
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("File not found: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException("IO Error reading file: " + e.getMessage(), e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {}
        }
        return list;
    }

    public static void writeFile(String file, List<String> lines) {
        FileWriter writer = null;
        try {
            writer = new FileWriter(file, false);
            for (String line : lines) {
                writer.append(line).append(System.getProperty("line.separator"));
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("File write problem: " + ex.getMessage(), ex);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

