/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.View;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ViewProxy
implements InvocationHandler {
    private static final Log auditLog = LogFactory.getLog((String)"com.espertech.esper.audit");
    private static Method target = JavaClassHelper.getMethodByName(View.class, "update");
    private final String statementName;
    private final String viewName;
    private final View view;

    public static Object newInstance(String statementName, String viewName, View view) {
        return Proxy.newProxyInstance(view.getClass().getClassLoader(), JavaClassHelper.getSuperInterfaces(view.getClass()), (InvocationHandler)new ViewProxy(statementName, viewName, view));
    }

    public ViewProxy(String statementName, String viewName, View view) {
        this.statementName = statementName;
        this.viewName = viewName;
        this.view = view;
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        if (!m.equals(target)) {
            return m.invoke((Object)this.view, args);
        }
        Object result = m.invoke((Object)this.view, args);
        if (auditLog.isInfoEnabled()) {
            EventBean[] newData = (EventBean[])args[0];
            EventBean[] oldData = (EventBean[])args[1];
            auditLog.info((Object)("Statement " + this.statementName + " view " + this.viewName + " insert {" + EventBeanUtility.summarize(newData) + "} remove {" + EventBeanUtility.summarize(oldData) + "}"));
        }
        return result;
    }
}

