/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ArrayEventIterator;
import com.espertech.esper.collection.SingleEventIterator;
import com.espertech.esper.view.EventStream;
import com.espertech.esper.view.View;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ZeroDepthStream
implements EventStream {
    private final LinkedList<View> children = new LinkedList();
    private final EventType eventType;
    private EventBean lastInsertedEvent;
    private EventBean[] lastInsertedEvents;
    private static final Log log = LogFactory.getLog(ZeroDepthStream.class);

    public ZeroDepthStream(EventType eventType) {
        this.eventType = eventType;
    }

    @Override
    public void insert(EventBean[] events) {
        for (View childView : this.children) {
            childView.update(events, null);
        }
        this.lastInsertedEvents = events;
    }

    @Override
    public final void insert(EventBean event) {
        EventBean[] row = new EventBean[]{event};
        for (View childView : this.children) {
            childView.update(row, null);
        }
        this.lastInsertedEvent = event;
    }

    @Override
    public final EventType getEventType() {
        return this.eventType;
    }

    @Override
    public final Iterator<EventBean> iterator() {
        if (this.lastInsertedEvents != null) {
            return new ArrayEventIterator(this.lastInsertedEvents);
        }
        return new SingleEventIterator(this.lastInsertedEvent);
    }

    @Override
    public final View addView(View view) {
        this.children.add(view);
        view.setParent(this);
        return view;
    }

    @Override
    public final List<View> getViews() {
        return this.children;
    }

    @Override
    public final boolean removeView(View view) {
        boolean isRemoved = this.children.remove(view);
        view.setParent(null);
        return isRemoved;
    }

    @Override
    public final boolean hasViews() {
        return !this.children.isEmpty();
    }

    @Override
    public void removeAllViews() {
        this.children.clear();
    }
}

