/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.ext;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.util.MetaDefItem;
import com.espertech.esper.util.MultiKeyCollatingComparator;
import com.espertech.esper.util.MultiKeyComparator;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.DataWindowView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.ext.IStreamSortedRandomAccess;
import com.espertech.esper.view.ext.SortWindowIterator;
import com.espertech.esper.view.ext.SortWindowViewFactory;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SortWindowView
extends ViewSupport
implements DataWindowView,
CloneableView {
    private final SortWindowViewFactory sortWindowViewFactory;
    private final ExprEvaluator[] sortCriteriaEvaluators;
    private final ExprNode[] sortCriteriaExpressions;
    private final EventBean[] eventsPerStream = new EventBean[1];
    private final boolean[] isDescendingValues;
    private final int sortWindowSize;
    private final IStreamSortedRandomAccess optionalSortedRandomAccess;
    private final AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext;
    private TreeMap<MultiKeyUntyped, LinkedList<EventBean>> sortedEvents;
    private int eventCount;
    private static final Log log = LogFactory.getLog(SortWindowView.class);

    public SortWindowView(SortWindowViewFactory sortWindowViewFactory, ExprNode[] sortCriteriaExpressions, ExprEvaluator[] sortCriteriaEvaluators, boolean[] descendingValues, int sortWindowSize, IStreamSortedRandomAccess optionalSortedRandomAccess, boolean isSortUsingCollator, AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        this.sortWindowViewFactory = sortWindowViewFactory;
        this.sortCriteriaExpressions = sortCriteriaExpressions;
        this.sortCriteriaEvaluators = sortCriteriaEvaluators;
        this.isDescendingValues = descendingValues;
        this.sortWindowSize = sortWindowSize;
        this.optionalSortedRandomAccess = optionalSortedRandomAccess;
        this.agentInstanceViewFactoryContext = agentInstanceViewFactoryContext;
        boolean hasStringTypes = false;
        boolean[] stringTypes = new boolean[sortCriteriaExpressions.length];
        int count = 0;
        for (ExprEvaluator node : sortCriteriaEvaluators) {
            if (node.getType() == String.class) {
                hasStringTypes = true;
                stringTypes[count] = true;
            }
            ++count;
        }
        MetaDefItem comparator = !hasStringTypes || !isSortUsingCollator ? new MultiKeyComparator(this.isDescendingValues) : new MultiKeyCollatingComparator(this.isDescendingValues, stringTypes);
        this.sortedEvents = new TreeMap((Comparator<MultiKeyUntyped>)((Object)comparator));
    }

    protected final ExprNode[] getSortCriteriaExpressions() {
        return this.sortCriteriaExpressions;
    }

    protected final boolean[] getIsDescendingValues() {
        return this.isDescendingValues;
    }

    protected final int getSortWindowSize() {
        return this.sortWindowSize;
    }

    protected IStreamSortedRandomAccess getOptionalSortedRandomAccess() {
        return this.optionalSortedRandomAccess;
    }

    @Override
    public View cloneView() {
        return this.sortWindowViewFactory.makeView(this.agentInstanceViewFactoryContext);
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        MultiKeyUntyped sortValues;
        int i;
        LinkedList<EventBean> removedEvents = new LinkedList<EventBean>();
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                sortValues = this.getSortValues(oldData[i]);
                boolean result = this.remove(sortValues, oldData[i]);
                if (!result) continue;
                --this.eventCount;
                removedEvents.add(oldData[i]);
            }
        }
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                sortValues = this.getSortValues(newData[i]);
                this.add(sortValues, newData[i]);
                ++this.eventCount;
            }
        }
        if (this.eventCount > this.sortWindowSize) {
            int removeCount = this.eventCount - this.sortWindowSize;
            for (int i2 = 0; i2 < removeCount; ++i2) {
                MultiKeyUntyped lastKey = this.sortedEvents.lastKey();
                LinkedList<EventBean> events = this.sortedEvents.get(lastKey);
                EventBean event = events.removeLast();
                --this.eventCount;
                if (events.isEmpty()) {
                    this.sortedEvents.remove(lastKey);
                }
                removedEvents.add(event);
            }
        }
        if (this.optionalSortedRandomAccess != null) {
            this.optionalSortedRandomAccess.refresh(this.sortedEvents, this.eventCount, this.sortWindowSize);
        }
        if (this.hasViews()) {
            EventBean[] expiredArr = null;
            if (!removedEvents.isEmpty()) {
                expiredArr = removedEvents.toArray(new EventBean[removedEvents.size()]);
            }
            this.updateChildren(newData, expiredArr);
        }
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return new SortWindowIterator(this.sortedEvents);
    }

    public final String toString() {
        return this.getClass().getName() + " sortFieldName=" + Arrays.toString(this.sortCriteriaExpressions) + " isDescending=" + Arrays.toString(this.isDescendingValues) + " sortWindowSize=" + this.sortWindowSize;
    }

    private void add(MultiKeyUntyped key, EventBean bean) {
        LinkedList<EventBean> listOfBeans = this.sortedEvents.get(key);
        if (listOfBeans != null) {
            listOfBeans.addFirst(bean);
            return;
        }
        listOfBeans = new LinkedList();
        listOfBeans.add(bean);
        this.sortedEvents.put(key, listOfBeans);
    }

    private boolean remove(MultiKeyUntyped key, EventBean bean) {
        LinkedList<EventBean> listOfBeans = this.sortedEvents.get(key);
        if (listOfBeans == null) {
            return false;
        }
        boolean result = listOfBeans.remove(bean);
        if (listOfBeans.isEmpty()) {
            this.sortedEvents.remove(key);
        }
        return result;
    }

    private MultiKeyUntyped getSortValues(EventBean event) {
        this.eventsPerStream[0] = event;
        Object[] result = new Object[this.sortCriteriaExpressions.length];
        int count = 0;
        for (ExprEvaluator expr : this.sortCriteriaEvaluators) {
            result[count++] = expr.evaluate(this.eventsPerStream, true, this.agentInstanceViewFactoryContext);
        }
        return new MultiKeyUntyped(result);
    }

    public boolean isEmpty() {
        if (this.sortedEvents == null) {
            return true;
        }
        return this.sortedEvents.isEmpty();
    }
}

