/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.ext;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.ExprEvaluatorContextStatement;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.DataWindowViewFactory;
import com.espertech.esper.view.DataWindowViewWithPrevious;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.ViewServiceHelper;
import com.espertech.esper.view.ext.IStreamTimeOrderRandomAccess;
import com.espertech.esper.view.ext.TimeOrderView;
import com.espertech.esper.view.window.RandomAccessByIndexGetter;
import java.util.List;

public class TimeOrderViewFactory
implements DataWindowViewFactory,
DataWindowViewWithPrevious {
    private List<ExprNode> viewParameters;
    protected ExprNode timestampExpression;
    protected long intervalSize;
    private EventType eventType;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> expressionParameters) throws ViewParameterException {
        this.viewParameters = expressionParameters;
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
        ExprNode[] validated = ViewFactorySupport.validate("Time order view", parentEventType, statementContext, this.viewParameters, true);
        String errorMessage = "Time order view requires the expression supplying timestamp values, and a numeric or time period parameter for interval size";
        if (this.viewParameters.size() != 2) {
            throw new ViewParameterException(errorMessage);
        }
        if (!JavaClassHelper.isNumeric(validated[0].getExprEvaluator().getType())) {
            throw new ViewParameterException(errorMessage);
        }
        this.timestampExpression = validated[0];
        ExprEvaluatorContextStatement exprEvaluatorContext = new ExprEvaluatorContextStatement(statementContext);
        Object parameter = ViewFactorySupport.evaluateAssertNoProperties("Externally-timed window", validated[1], 1, exprEvaluatorContext);
        if (!(parameter instanceof Number)) {
            throw new ViewParameterException(errorMessage);
        }
        Number param = (Number)parameter;
        this.intervalSize = JavaClassHelper.isFloatingPointNumber(param) ? Math.round(1000.0 * param.doubleValue()) : 1000L * param.longValue();
        if (this.intervalSize < 1L) {
            throw new ViewParameterException("Time order view requires a size of at least 1 msec");
        }
        this.eventType = parentEventType;
    }

    @Override
    public Object makePreviousGetter() {
        return new RandomAccessByIndexGetter();
    }

    @Override
    public View makeView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        IStreamTimeOrderRandomAccess sortedRandomAccess = ViewServiceHelper.getOptPreviousExprTimeOrderAccess(agentInstanceViewFactoryContext);
        return new TimeOrderView(agentInstanceViewFactoryContext, this, this.timestampExpression, this.timestampExpression.getExprEvaluator(), this.intervalSize, sortedRandomAccess);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view) {
        if (!(view instanceof TimeOrderView)) {
            return false;
        }
        TimeOrderView other = (TimeOrderView)view;
        if (other.getIntervalSize() != this.intervalSize || !ExprNodeUtility.deepEquals(other.getTimestampExpression(), this.timestampExpression)) {
            return false;
        }
        return other.isEmpty();
    }
}

