/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.ext;

import com.espertech.esper.client.EventBean;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedMap;

public final class TimeOrderViewIterator
implements Iterator<EventBean> {
    private final SortedMap<Long, ArrayList<EventBean>> window;
    private final Iterator<Long> keyIterator;
    private Iterator<EventBean> currentListIterator;

    public TimeOrderViewIterator(SortedMap<Long, ArrayList<EventBean>> window) {
        this.window = window;
        this.keyIterator = window.keySet().iterator();
        if (this.keyIterator.hasNext()) {
            Long key = this.keyIterator.next();
            ArrayList list = (ArrayList)window.get(key);
            while (list.isEmpty() && this.keyIterator.hasNext()) {
                key = this.keyIterator.next();
                list = (ArrayList)window.get(key);
            }
            this.currentListIterator = list.iterator();
        }
    }

    @Override
    public final EventBean next() {
        if (this.currentListIterator == null) {
            throw new NoSuchElementException();
        }
        EventBean eventBean = this.currentListIterator.next();
        if (!this.currentListIterator.hasNext()) {
            this.currentListIterator = null;
            if (this.keyIterator.hasNext()) {
                Long key = this.keyIterator.next();
                ArrayList list = (ArrayList)this.window.get(key);
                while (list.isEmpty() && this.keyIterator.hasNext()) {
                    key = this.keyIterator.next();
                    list = (ArrayList)this.window.get(key);
                }
                this.currentListIterator = list.iterator();
            }
        }
        return eventBean;
    }

    @Override
    public final boolean hasNext() {
        if (this.currentListIterator == null) {
            return false;
        }
        if (this.currentListIterator.hasNext()) {
            return true;
        }
        this.currentListIterator = null;
        return this.keyIterator.hasNext();
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }
}

