/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.internal;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.StoppableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.internal.IntersectViewFactory;
import com.espertech.esper.view.internal.LastPostObserver;
import com.espertech.esper.view.internal.LastPostObserverView;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IntersectAsymetricView
extends ViewSupport
implements LastPostObserver,
CloneableView,
StoppableView {
    private static final Log log = LogFactory.getLog(IntersectAsymetricView.class);
    private final AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext;
    private final IntersectViewFactory intersectViewFactory;
    private final EventType eventType;
    private final View[] views;
    private final EventBean[][] oldEventsPerView;
    private final Set<EventBean> removalEvents = new HashSet<EventBean>();
    private final ArrayDeque<EventBean> newEvents = new ArrayDeque();
    private EventBean[] newDataChildView;
    private boolean isHasRemovestreamData;
    private boolean isRetainObserverEvents;
    private boolean isDiscardObserverEvents;
    private Set<EventBean> oldEvents = new HashSet<EventBean>();

    public IntersectAsymetricView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext, IntersectViewFactory factory, EventType eventType, List<View> viewList) {
        this.agentInstanceViewFactoryContext = agentInstanceViewFactoryContext;
        this.intersectViewFactory = factory;
        this.eventType = eventType;
        this.views = viewList.toArray(new View[viewList.size()]);
        this.oldEventsPerView = new EventBean[viewList.size()][];
        for (int i = 0; i < viewList.size(); ++i) {
            LastPostObserverView view = new LastPostObserverView(i);
            this.views[i].removeAllViews();
            this.views[i].addView(view);
            view.setObserver(this);
        }
    }

    @Override
    public View cloneView() {
        return this.intersectViewFactory.makeView(this.agentInstanceViewFactoryContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        int i;
        this.oldEvents.clear();
        EventBean[] newDataPosted = null;
        if (oldData != null) {
            this.isDiscardObserverEvents = true;
            try {
                for (View view : this.views) {
                    view.update(null, oldData);
                }
            }
            finally {
                this.isDiscardObserverEvents = false;
            }
            for (i = 0; i < oldData.length; ++i) {
                this.oldEvents.add(oldData[i]);
            }
        }
        if (newData != null) {
            this.removalEvents.clear();
            this.isHasRemovestreamData = false;
            this.isRetainObserverEvents = true;
            try {
                for (View view : this.views) {
                    int i2;
                    this.newDataChildView = null;
                    view.update(newData, oldData);
                    if (this.newDataChildView != null) {
                        for (i2 = 0; i2 < newData.length; ++i2) {
                            boolean found = false;
                            for (int j = 0; j < this.newDataChildView.length; ++j) {
                                if (this.newDataChildView[i2] != newData[i2]) continue;
                                found = true;
                                break;
                            }
                            if (found) continue;
                            this.removalEvents.add(newData[i2]);
                        }
                        continue;
                    }
                    for (i2 = 0; i2 < newData.length; ++i2) {
                        this.removalEvents.add(newData[i2]);
                    }
                }
            }
            finally {
                this.isRetainObserverEvents = false;
            }
            if (!this.removalEvents.isEmpty()) {
                this.isDiscardObserverEvents = true;
                EventBean[] viewOldData = this.removalEvents.toArray(new EventBean[this.removalEvents.size()]);
                try {
                    for (int j = 0; j < this.views.length; ++j) {
                        this.views[j].update(null, viewOldData);
                    }
                }
                finally {
                    this.isDiscardObserverEvents = false;
                }
            }
            if (this.isHasRemovestreamData) {
                for (int i3 = 0; i3 < this.oldEventsPerView.length; ++i3) {
                    if (this.oldEventsPerView[i3] == null) continue;
                    EventBean[] viewOldData = this.oldEventsPerView[i3];
                    this.oldEventsPerView[i3] = null;
                    this.removalEvents.addAll(Arrays.asList(viewOldData));
                    this.isDiscardObserverEvents = true;
                    try {
                        for (int j = 0; j < this.views.length; ++j) {
                            if (i3 == j) continue;
                            this.views[j].update(null, viewOldData);
                        }
                        continue;
                    }
                    finally {
                        this.isDiscardObserverEvents = false;
                    }
                }
                this.oldEvents.addAll(this.removalEvents);
            }
            this.newEvents.clear();
            for (i = 0; i < newData.length; ++i) {
                if (this.removalEvents.contains(newData[i])) continue;
                this.newEvents.add(newData[i]);
            }
            if (!this.newEvents.isEmpty()) {
                newDataPosted = this.newEvents.toArray(new EventBean[this.newEvents.size()]);
            }
        }
        EventBean[] oldDataPosted = null;
        if (!this.oldEvents.isEmpty()) {
            oldDataPosted = this.oldEvents.toArray(new EventBean[this.oldEvents.size()]);
        }
        if (newDataPosted != null || oldDataPosted != null) {
            this.updateChildren(newDataPosted, oldDataPosted);
        }
        this.oldEvents.clear();
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public Iterator<EventBean> iterator() {
        return this.views[0].iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newData(int streamId, EventBean[] newEvents, EventBean[] oldEvents) {
        this.newDataChildView = newEvents;
        if (oldEvents == null || this.isDiscardObserverEvents) {
            return;
        }
        if (this.isRetainObserverEvents) {
            this.oldEventsPerView[streamId] = oldEvents;
            this.isHasRemovestreamData = true;
            return;
        }
        this.isDiscardObserverEvents = true;
        try {
            for (int i = 0; i < this.views.length; ++i) {
                if (i == streamId) continue;
                this.views[i].update(null, oldEvents);
            }
        }
        finally {
            this.isDiscardObserverEvents = false;
        }
        this.updateChildren(null, oldEvents);
    }

    @Override
    public void stopView() {
        for (View view : this.views) {
            if (!(view instanceof StoppableView)) continue;
            ((StoppableView)((Object)view)).stopView();
        }
    }
}

