/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.stat;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.SingleEventIterator;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.stat.BaseStatisticsBean;
import com.espertech.esper.view.stat.StatViewAdditionalProps;
import java.util.Iterator;

public abstract class BaseBivariateStatisticsView
extends ViewSupport {
    protected BaseStatisticsBean statisticsBean = new BaseStatisticsBean();
    private final ExprNode expressionX;
    private final ExprNode expressionY;
    private final ExprEvaluator expressionXEval;
    private final ExprEvaluator expressionYEval;
    private final EventBean[] eventsPerStream = new EventBean[1];
    protected final AgentInstanceContext agentInstanceContext;
    protected final StatViewAdditionalProps additionalProps;
    protected final EventType eventType;
    private Object[] lastValuesEventNew;
    private EventBean lastNewEvent;

    protected abstract EventBean populateMap(BaseStatisticsBean var1, EventAdapterService var2, EventType var3, StatViewAdditionalProps var4, Object[] var5);

    public BaseBivariateStatisticsView(AgentInstanceContext agentInstanceContext, ExprNode expressionX, ExprNode expressionY, EventType eventType, StatViewAdditionalProps additionalProps) {
        this.agentInstanceContext = agentInstanceContext;
        this.expressionX = expressionX;
        this.expressionXEval = expressionX.getExprEvaluator();
        this.expressionY = expressionY;
        this.expressionYEval = expressionY.getExprEvaluator();
        this.eventType = eventType;
        this.additionalProps = additionalProps;
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        double Y;
        double X;
        Number ynum;
        Number xnum;
        int i;
        EventBean oldValues = null;
        if (this.lastNewEvent == null && this.hasViews()) {
            oldValues = this.populateMap(this.statisticsBean, this.agentInstanceContext.getStatementContext().getEventAdapterService(), this.eventType, this.additionalProps, null);
        }
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                this.eventsPerStream[0] = newData[i];
                xnum = (Number)this.expressionXEval.evaluate(this.eventsPerStream, true, this.agentInstanceContext);
                ynum = (Number)this.expressionYEval.evaluate(this.eventsPerStream, true, this.agentInstanceContext);
                if (xnum == null || ynum == null) continue;
                X = xnum.doubleValue();
                Y = ynum.doubleValue();
                this.statisticsBean.addPoint(X, Y);
            }
            if (this.additionalProps != null && newData.length != 0) {
                if (this.lastValuesEventNew == null) {
                    this.lastValuesEventNew = new Object[this.additionalProps.getAdditionalExpr().length];
                }
                for (int val = 0; val < this.additionalProps.getAdditionalExpr().length; ++val) {
                    this.lastValuesEventNew[val] = this.additionalProps.getAdditionalExpr()[val].evaluate(this.eventsPerStream, true, this.agentInstanceContext);
                }
            }
        }
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                this.eventsPerStream[0] = oldData[i];
                xnum = (Number)this.expressionXEval.evaluate(this.eventsPerStream, true, this.agentInstanceContext);
                ynum = (Number)this.expressionYEval.evaluate(this.eventsPerStream, true, this.agentInstanceContext);
                if (xnum == null || ynum == null) continue;
                X = xnum.doubleValue();
                Y = ynum.doubleValue();
                this.statisticsBean.removePoint(X, Y);
            }
        }
        if (this.hasViews()) {
            EventBean newDataMap = this.populateMap(this.statisticsBean, this.agentInstanceContext.getStatementContext().getEventAdapterService(), this.eventType, this.additionalProps, this.lastValuesEventNew);
            if (this.lastNewEvent == null) {
                this.updateChildren(new EventBean[]{newDataMap}, new EventBean[]{oldValues});
            } else {
                this.updateChildren(new EventBean[]{newDataMap}, new EventBean[]{this.lastNewEvent});
            }
            this.lastNewEvent = newDataMap;
        }
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return new SingleEventIterator(this.populateMap(this.statisticsBean, this.agentInstanceContext.getStatementContext().getEventAdapterService(), this.eventType, this.additionalProps, this.lastValuesEventNew));
    }

    public final ExprNode getExpressionX() {
        return this.expressionX;
    }

    public final ExprNode getExpressionY() {
        return this.expressionY;
    }
}

