/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.stat;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.SingleEventIterator;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFieldEnum;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.stat.StatViewAdditionalProps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class WeightedAverageView
extends ViewSupport
implements CloneableView {
    private final EventType eventType;
    private final AgentInstanceContext agentInstanceContext;
    private final ExprNode fieldNameX;
    private final ExprEvaluator fieldNameXEvaluator;
    private final ExprNode fieldNameWeight;
    private final ExprEvaluator fieldNameWeightEvaluator;
    private final StatViewAdditionalProps additionalProps;
    private EventBean[] eventsPerStream = new EventBean[1];
    private double sumXtimesW = Double.NaN;
    private double sumW = Double.NaN;
    private double currentValue = Double.NaN;
    private Object[] lastValuesEventNew;
    private EventBean lastNewEvent;

    public WeightedAverageView(AgentInstanceContext agentInstanceContext, ExprNode fieldNameX, ExprNode fieldNameWeight, EventType eventType, StatViewAdditionalProps additionalProps) {
        this.fieldNameX = fieldNameX;
        this.fieldNameXEvaluator = fieldNameX.getExprEvaluator();
        this.fieldNameWeight = fieldNameWeight;
        this.fieldNameWeightEvaluator = fieldNameWeight.getExprEvaluator();
        this.agentInstanceContext = agentInstanceContext;
        this.eventType = eventType;
        this.additionalProps = additionalProps;
    }

    @Override
    public View cloneView() {
        return new WeightedAverageView(this.agentInstanceContext, this.fieldNameX, this.fieldNameWeight, this.eventType, this.additionalProps);
    }

    public final ExprNode getFieldNameX() {
        return this.fieldNameX;
    }

    public final ExprNode getFieldNameWeight() {
        return this.fieldNameWeight;
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        double weight;
        double point;
        Number weightnum;
        Number pointnum;
        int i;
        double oldValue = this.currentValue;
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                this.eventsPerStream[0] = newData[i];
                pointnum = (Number)this.fieldNameXEvaluator.evaluate(this.eventsPerStream, true, this.agentInstanceContext);
                weightnum = (Number)this.fieldNameWeightEvaluator.evaluate(this.eventsPerStream, true, this.agentInstanceContext);
                if (pointnum == null || weightnum == null) continue;
                point = pointnum.doubleValue();
                weight = weightnum.doubleValue();
                if (Double.valueOf(this.sumXtimesW).isNaN()) {
                    this.sumXtimesW = point * weight;
                    this.sumW = weight;
                    continue;
                }
                this.sumXtimesW += point * weight;
                this.sumW += weight;
            }
            if (this.additionalProps != null && newData.length != 0) {
                if (this.lastValuesEventNew == null) {
                    this.lastValuesEventNew = new Object[this.additionalProps.getAdditionalExpr().length];
                }
                for (int val = 0; val < this.additionalProps.getAdditionalExpr().length; ++val) {
                    this.lastValuesEventNew[val] = this.additionalProps.getAdditionalExpr()[val].evaluate(this.eventsPerStream, true, this.agentInstanceContext);
                }
            }
        }
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                this.eventsPerStream[0] = oldData[i];
                pointnum = (Number)this.fieldNameXEvaluator.evaluate(this.eventsPerStream, true, this.agentInstanceContext);
                weightnum = (Number)this.fieldNameWeightEvaluator.evaluate(this.eventsPerStream, true, this.agentInstanceContext);
                if (pointnum == null || weightnum == null) continue;
                point = pointnum.doubleValue();
                weight = weightnum.doubleValue();
                this.sumXtimesW -= point * weight;
                this.sumW -= weight;
            }
        }
        this.currentValue = this.sumW != 0.0 ? this.sumXtimesW / this.sumW : Double.NaN;
        if (this.hasViews()) {
            HashMap<String, Object> newDataMap = new HashMap<String, Object>();
            newDataMap.put(ViewFieldEnum.WEIGHTED_AVERAGE__AVERAGE.getName(), this.currentValue);
            this.addProperties(newDataMap);
            EventBean newDataEvent = this.agentInstanceContext.getStatementContext().getEventAdapterService().adapterForTypedMap(newDataMap, this.eventType);
            if (this.lastNewEvent == null) {
                HashMap<String, Object> oldDataMap = new HashMap<String, Object>();
                oldDataMap.put(ViewFieldEnum.WEIGHTED_AVERAGE__AVERAGE.getName(), oldValue);
                EventBean oldDataEvent = this.agentInstanceContext.getStatementContext().getEventAdapterService().adapterForTypedMap(oldDataMap, this.eventType);
                this.updateChildren(new EventBean[]{newDataEvent}, new EventBean[]{oldDataEvent});
            } else {
                this.updateChildren(new EventBean[]{newDataEvent}, new EventBean[]{this.lastNewEvent});
            }
            this.lastNewEvent = newDataEvent;
        }
    }

    private void addProperties(Map<String, Object> newDataMap) {
        if (this.additionalProps == null) {
            return;
        }
        this.additionalProps.addProperties(newDataMap, this.lastValuesEventNew);
    }

    @Override
    public final EventType getEventType() {
        return this.eventType;
    }

    @Override
    public final Iterator<EventBean> iterator() {
        HashMap<String, Object> newDataMap = new HashMap<String, Object>();
        newDataMap.put(ViewFieldEnum.WEIGHTED_AVERAGE__AVERAGE.getName(), this.currentValue);
        this.addProperties(newDataMap);
        return new SingleEventIterator(this.agentInstanceContext.getStatementContext().getEventAdapterService().adapterForTypedMap(newDataMap, this.eventType));
    }

    public final String toString() {
        return this.getClass().getName() + " fieldName=" + this.fieldNameX + " fieldNameWeight=" + this.fieldNameWeight;
    }

    public static EventType createEventType(StatementContext statementContext, StatViewAdditionalProps additionalProps, int streamNum) {
        HashMap<String, Object> schemaMap = new HashMap<String, Object>();
        schemaMap.put(ViewFieldEnum.WEIGHTED_AVERAGE__AVERAGE.getName(), Double.class);
        StatViewAdditionalProps.addCheckDupProperties(schemaMap, additionalProps, ViewFieldEnum.WEIGHTED_AVERAGE__AVERAGE);
        String outputEventTypeName = statementContext.getStatementId() + "_wavgview_" + streamNum;
        return statementContext.getEventAdapterService().createAnonymousMapType(outputEventTypeName, schemaMap);
    }
}

