/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.std;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.StoppableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.std.GroupByView;
import com.espertech.esper.view.std.GroupByViewAgedEntry;
import com.espertech.esper.view.std.GroupByViewImpl;
import com.espertech.esper.view.std.MergeView;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class GroupByViewReclaimAged
extends ViewSupport
implements CloneableView,
GroupByView {
    private final ExprNode[] criteriaExpressions;
    private final ExprEvaluator[] criteriaEvaluators;
    private final AgentInstanceViewFactoryChainContext agentInstanceContext;
    private final long reclaimMaxAge;
    private final long reclaimFrequency;
    private EventBean[] eventsPerStream = new EventBean[1];
    private String[] propertyNames;
    private final Map<MultiKey<Object>, GroupByViewAgedEntry> subViewsPerKey = new HashMap<MultiKey<Object>, GroupByViewAgedEntry>();
    private final HashMap<GroupByViewAgedEntry, Pair<List<EventBean>, List<EventBean>>> groupedEvents = new HashMap();
    private Long nextSweepTime = null;
    private static final Log log = LogFactory.getLog(GroupByViewReclaimAged.class);

    public GroupByViewReclaimAged(AgentInstanceViewFactoryChainContext agentInstanceContext, ExprNode[] criteriaExpressions, ExprEvaluator[] criteriaEvaluators, double reclaimMaxAge, double reclaimFrequency) {
        this.agentInstanceContext = agentInstanceContext;
        this.criteriaExpressions = criteriaExpressions;
        this.criteriaEvaluators = criteriaEvaluators;
        this.reclaimMaxAge = (long)(reclaimMaxAge * 1000.0);
        this.reclaimFrequency = (long)(reclaimFrequency * 1000.0);
        this.propertyNames = new String[criteriaExpressions.length];
        for (int i = 0; i < criteriaExpressions.length; ++i) {
            this.propertyNames[i] = criteriaExpressions[i].toExpressionString();
        }
    }

    @Override
    public View cloneView() {
        return new GroupByViewReclaimAged(this.agentInstanceContext, this.criteriaExpressions, this.criteriaEvaluators, this.reclaimMaxAge, this.reclaimFrequency);
    }

    @Override
    public ExprNode[] getCriteriaExpressions() {
        return this.criteriaExpressions;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        long currentTime = this.agentInstanceContext.getTimeProvider().getTime();
        if (this.nextSweepTime == null || this.nextSweepTime <= currentTime) {
            if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
                log.debug((Object)("Reclaiming groups older then " + this.reclaimMaxAge + " msec and every " + this.reclaimFrequency + "msec in frequency"));
            }
            this.nextSweepTime = currentTime + this.reclaimFrequency;
            this.sweep(currentTime);
        }
        if (newData != null && oldData == null && newData.length == 1) {
            EventBean event = newData[0];
            EventBean[] newDataToPost = new EventBean[]{event};
            Object[] groupByValues = new Object[this.criteriaExpressions.length];
            this.eventsPerStream[0] = event;
            for (int i = 0; i < this.criteriaEvaluators.length; ++i) {
                groupByValues[i] = this.criteriaEvaluators[i].evaluate(this.eventsPerStream, true, this.agentInstanceContext);
            }
            MultiKey<Object> groupByValuesKey = new MultiKey<Object>(groupByValues);
            GroupByViewAgedEntry subViews = this.subViewsPerKey.get(groupByValuesKey);
            if (subViews == null) {
                List<View> subviewsList = GroupByViewImpl.makeSubViews(this, this.propertyNames, groupByValuesKey.getArray(), this.agentInstanceContext);
                subViews = new GroupByViewAgedEntry(subviewsList, currentTime);
                this.subViewsPerKey.put(groupByValuesKey, subViews);
            } else {
                subViews.setLastUpdateTime(currentTime);
            }
            ViewSupport.updateChildren(subViews.getSubviews(), newDataToPost, null);
        } else {
            if (newData != null) {
                for (EventBean newValue : newData) {
                    this.handleEvent(newValue, true);
                }
            }
            if (oldData != null) {
                for (EventBean oldValue : oldData) {
                    this.handleEvent(oldValue, false);
                }
            }
            for (Map.Entry<GroupByViewAgedEntry, Pair<List<EventBean>, List<EventBean>>> entry : this.groupedEvents.entrySet()) {
                EventBean[] newEvents = EventBeanUtility.toArray(entry.getValue().getFirst());
                EventBean[] oldEvents = EventBeanUtility.toArray(entry.getValue().getSecond());
                ViewSupport.updateChildren(entry.getKey().getSubviews(), newEvents, oldEvents);
            }
            this.groupedEvents.clear();
        }
    }

    private void handleEvent(EventBean event, boolean isNew) {
        Object[] groupByValues = new Object[this.criteriaExpressions.length];
        this.eventsPerStream[0] = event;
        for (int i = 0; i < this.criteriaEvaluators.length; ++i) {
            groupByValues[i] = this.criteriaEvaluators[i].evaluate(this.eventsPerStream, true, this.agentInstanceContext);
        }
        MultiKey<Object> groupByValuesKey = new MultiKey<Object>(groupByValues);
        GroupByViewAgedEntry subViews = this.subViewsPerKey.get(groupByValuesKey);
        if (subViews == null) {
            List<View> subviewsList = GroupByViewImpl.makeSubViews(this, this.propertyNames, groupByValuesKey.getArray(), this.agentInstanceContext);
            long currentTime = this.agentInstanceContext.getStatementContext().getTimeProvider().getTime();
            subViews = new GroupByViewAgedEntry(subviewsList, currentTime);
            this.subViewsPerKey.put(groupByValuesKey, subViews);
        } else {
            subViews.setLastUpdateTime(this.agentInstanceContext.getStatementContext().getTimeProvider().getTime());
        }
        Pair<List<EventBean>, List<EventBean>> pair = this.groupedEvents.get(subViews);
        if (pair == null) {
            LinkedList listNew = new LinkedList();
            LinkedList listOld = new LinkedList();
            pair = new Pair(listNew, listOld);
            this.groupedEvents.put(subViews, pair);
        }
        if (isNew) {
            pair.getFirst().add(event);
        } else {
            pair.getSecond().add(event);
        }
    }

    @Override
    public final Iterator<EventBean> iterator() {
        throw new UnsupportedOperationException("Cannot iterate over group view, this operation is not supported");
    }

    public final String toString() {
        return this.getClass().getName() + " groupFieldNames=" + Arrays.toString(this.criteriaExpressions);
    }

    private void sweep(long currentTime) {
        ArrayDeque<MultiKey<Object>> removed = new ArrayDeque<MultiKey<Object>>();
        for (Map.Entry<MultiKey<Object>, GroupByViewAgedEntry> entry : this.subViewsPerKey.entrySet()) {
            long age = currentTime - entry.getValue().getLastUpdateTime();
            if (age <= this.reclaimMaxAge) continue;
            removed.add(entry.getKey());
        }
        for (MultiKey multiKey : removed) {
            GroupByViewAgedEntry entry = this.subViewsPerKey.remove(multiKey);
            for (View view : entry.getSubviews()) {
                view.setParent(null);
                this.recursiveMergeViewRemove(view);
                if (!(view instanceof StoppableView)) continue;
                ((StoppableView)((Object)view)).stopView();
            }
        }
    }

    private void recursiveMergeViewRemove(View view) {
        for (View child : view.getViews()) {
            if (child instanceof StoppableView) {
                ((StoppableView)((Object)child)).stopView();
            }
            if (child instanceof MergeView) {
                MergeView mergeView = (MergeView)child;
                mergeView.removeParentView(view);
                continue;
            }
            this.recursiveMergeViewRemove(child);
        }
    }
}

