/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.std;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.std.GroupByViewFactoryMarker;
import com.espertech.esper.view.std.MergeView;
import java.util.HashMap;
import java.util.List;

public class MergeViewFactory
implements ViewFactory {
    private List<ExprNode> viewParameters;
    private int streamNumber;
    private ExprNode[] criteriaExpressions;
    private EventType eventType;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> expressionParameters) throws ViewParameterException {
        this.viewParameters = expressionParameters;
        this.streamNumber = viewFactoryContext.getStreamNum();
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
        GroupByViewFactoryMarker groupByViewFactory = null;
        ExprNode[] unvalidated = this.viewParameters.toArray(new ExprNode[this.viewParameters.size()]);
        for (ViewFactory parentView : parentViewFactories) {
            GroupByViewFactoryMarker candidateGroupByView;
            if (!(parentView instanceof GroupByViewFactoryMarker) || !ExprNodeUtility.deepEquals((candidateGroupByView = (GroupByViewFactoryMarker)((Object)parentView)).getCriteriaExpressions(), unvalidated)) continue;
            groupByViewFactory = candidateGroupByView;
        }
        if (groupByViewFactory == null) {
            throw new ViewParameterException("Groupwin view for this merge view could not be found among parent views");
        }
        this.criteriaExpressions = groupByViewFactory.getCriteriaExpressions();
        Class[] fieldTypes = new Class[this.criteriaExpressions.length];
        for (int i = 0; i < fieldTypes.length; ++i) {
            fieldTypes[i] = this.criteriaExpressions[i].getExprEvaluator().getType();
        }
        boolean parentContainsMergeKeys = true;
        String[] fieldNames = new String[this.criteriaExpressions.length];
        for (int i = 0; i < this.criteriaExpressions.length; ++i) {
            String name;
            fieldNames[i] = name = this.criteriaExpressions[i].toExpressionString();
            if (parentEventType.isProperty(name)) continue;
            parentContainsMergeKeys = false;
        }
        if (parentContainsMergeKeys) {
            this.eventType = parentEventType;
        } else {
            HashMap<String, Object> additionalProps = new HashMap<String, Object>();
            for (int i = 0; i < fieldNames.length; ++i) {
                additionalProps.put(fieldNames[i], fieldTypes[i]);
            }
            String outputEventTypeName = statementContext.getStatementId() + "_mergeview_" + this.streamNumber;
            this.eventType = statementContext.getEventAdapterService().createAnonymousWrapperType(outputEventTypeName, parentEventType, additionalProps);
        }
    }

    @Override
    public View makeView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        return new MergeView(agentInstanceViewFactoryContext, this.criteriaExpressions, this.eventType);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view) {
        if (!(view instanceof MergeView)) {
            return false;
        }
        MergeView myView = (MergeView)view;
        return ExprNodeUtility.deepEquals(myView.getGroupFieldNames(), this.criteriaExpressions);
    }
}

