/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.std;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.SingleEventIterator;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFieldEnum;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.stat.StatViewAdditionalProps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class SizeView
extends ViewSupport
implements CloneableView {
    private final AgentInstanceContext agentInstanceContext;
    private final EventType eventType;
    private final StatViewAdditionalProps additionalProps;
    private long size = 0L;
    private EventBean lastSizeEvent;
    private Object[] lastValuesEventNew;

    public SizeView(AgentInstanceContext agentInstanceContext, EventType eventType, StatViewAdditionalProps additionalProps) {
        this.agentInstanceContext = agentInstanceContext;
        this.eventType = eventType;
        this.additionalProps = additionalProps;
    }

    @Override
    public View cloneView() {
        return new SizeView(this.agentInstanceContext, this.eventType, this.additionalProps);
    }

    @Override
    public final EventType getEventType() {
        return this.eventType;
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        long priorSize = this.size;
        if (newData != null) {
            this.size += (long)newData.length;
            if (this.additionalProps != null && newData.length != 0) {
                if (this.lastValuesEventNew == null) {
                    this.lastValuesEventNew = new Object[this.additionalProps.getAdditionalExpr().length];
                }
                for (int val = 0; val < this.additionalProps.getAdditionalExpr().length; ++val) {
                    this.lastValuesEventNew[val] = this.additionalProps.getAdditionalExpr()[val].evaluate(new EventBean[]{newData[newData.length - 1]}, true, this.agentInstanceContext);
                }
            }
        }
        if (oldData != null) {
            this.size -= (long)oldData.length;
        }
        if (this.hasViews() && priorSize != this.size) {
            HashMap<String, Object> postNewData = new HashMap<String, Object>();
            postNewData.put(ViewFieldEnum.SIZE_VIEW__SIZE.getName(), this.size);
            this.addProperties(postNewData);
            EventBean newEvent = this.agentInstanceContext.getStatementContext().getEventAdapterService().adapterForTypedMap(postNewData, this.eventType);
            if (this.lastSizeEvent != null) {
                this.updateChildren(new EventBean[]{newEvent}, new EventBean[]{this.lastSizeEvent});
            } else {
                HashMap<String, Object> postOldData = new HashMap<String, Object>();
                postOldData.put(ViewFieldEnum.SIZE_VIEW__SIZE.getName(), priorSize);
                EventBean oldEvent = this.agentInstanceContext.getStatementContext().getEventAdapterService().adapterForTypedMap(postOldData, this.eventType);
                this.updateChildren(new EventBean[]{newEvent}, new EventBean[]{oldEvent});
            }
            this.lastSizeEvent = newEvent;
        }
    }

    @Override
    public final Iterator<EventBean> iterator() {
        HashMap<String, Object> current = new HashMap<String, Object>();
        current.put(ViewFieldEnum.SIZE_VIEW__SIZE.getName(), this.size);
        this.addProperties(current);
        return new SingleEventIterator(this.agentInstanceContext.getStatementContext().getEventAdapterService().adapterForTypedMap(current, this.eventType));
    }

    public final String toString() {
        return this.getClass().getName();
    }

    public static EventType createEventType(StatementContext statementContext, StatViewAdditionalProps additionalProps, int streamNum) {
        HashMap<String, Object> schemaMap = new HashMap<String, Object>();
        schemaMap.put(ViewFieldEnum.SIZE_VIEW__SIZE.getName(), Long.TYPE);
        StatViewAdditionalProps.addCheckDupProperties(schemaMap, additionalProps, ViewFieldEnum.SIZE_VIEW__SIZE);
        String outputEventTypeName = statementContext.getStatementId() + "_sizeview_" + streamNum;
        return statementContext.getEventAdapterService().createAnonymousMapType(outputEventTypeName, schemaMap);
    }

    private void addProperties(Map<String, Object> newDataMap) {
        if (this.additionalProps == null) {
            return;
        }
        this.additionalProps.addProperties(newDataMap, this.lastValuesEventNew);
    }
}

