/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.std;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.OneEventCollection;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewSupport;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class UniqueByPropertyView
extends ViewSupport
implements CloneableView {
    private final ExprNode[] criteriaExpressions;
    private final ExprEvaluator[] criteriaExpressionsEvals;
    private final int numKeys;
    private final Map<MultiKey<Object>, EventBean> mostRecentEvents = new LinkedHashMap<MultiKey<Object>, EventBean>();
    private final EventBean[] eventsPerStream = new EventBean[1];
    private final AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext;
    private static final Log log = LogFactory.getLog(UniqueByPropertyView.class);

    public UniqueByPropertyView(ExprNode[] criteriaExpressions, AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        this.criteriaExpressions = criteriaExpressions;
        this.criteriaExpressionsEvals = ExprNodeUtility.getEvaluators(criteriaExpressions);
        this.agentInstanceViewFactoryContext = agentInstanceViewFactoryContext;
        this.numKeys = criteriaExpressions.length;
    }

    @Override
    public View cloneView() {
        return new UniqueByPropertyView(this.criteriaExpressions, this.agentInstanceViewFactoryContext);
    }

    public final ExprNode[] getCriteriaExpressions() {
        return this.criteriaExpressions;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        EventBean lastValue;
        MultiKey<Object> key;
        int i;
        OneEventCollection postOldData = null;
        if (this.hasViews()) {
            postOldData = new OneEventCollection();
        }
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                key = this.getUniqueKey(newData[i]);
                if (!this.hasViews()) {
                    this.mostRecentEvents.put(key, newData[i]);
                    continue;
                }
                lastValue = this.mostRecentEvents.get(key);
                if (lastValue != null) {
                    postOldData.add(lastValue);
                }
                this.mostRecentEvents.put(key, newData[i]);
            }
        }
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                key = this.getUniqueKey(oldData[i]);
                lastValue = this.mostRecentEvents.get(key);
                if (lastValue != oldData[i]) continue;
                postOldData.add(lastValue);
                this.mostRecentEvents.remove(key);
            }
        }
        if (this.hasViews()) {
            if (postOldData.isEmpty()) {
                this.updateChildren(newData, null);
            } else {
                this.updateChildren(newData, postOldData.toArray());
            }
        }
    }

    public boolean isEmpty() {
        return this.mostRecentEvents.isEmpty();
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.mostRecentEvents.values().iterator();
    }

    public final String toString() {
        return this.getClass().getName() + " uniqueFieldNames=" + Arrays.toString(this.criteriaExpressions);
    }

    private MultiKey<Object> getUniqueKey(EventBean event) {
        this.eventsPerStream[0] = event;
        Object[] values = new Object[this.numKeys];
        for (int i = 0; i < this.numKeys; ++i) {
            values[i] = this.criteriaExpressionsEvals[i].evaluate(this.eventsPerStream, true, this.agentInstanceViewFactoryContext);
        }
        return new MultiKey<Object>(values);
    }
}

