/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.stream;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.annotation.Audit;
import com.espertech.esper.client.annotation.AuditEnum;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.filter.FilterSpecCompiled;
import com.espertech.esper.filter.FilterSpecParam;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.EventStream;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventStreamProxy
implements InvocationHandler {
    private static final Log auditLog = LogFactory.getLog((String)"com.espertech.esper.audit");
    private final String statementName;
    private final String eventTypeAndFilter;
    private final EventStream eventStream;

    public static EventStream getAuditProxy(String statementName, Annotation[] annotations, FilterSpecCompiled filterSpec, EventStream designated) {
        Audit audit = AuditEnum.STREAM.getAudit(annotations);
        if (audit == null) {
            return designated;
        }
        StringWriter filterAndParams = new StringWriter();
        filterAndParams.write(filterSpec.getFilterForEventType().getName());
        if (filterSpec.getParameters() != null && !filterSpec.getParameters().isEmpty()) {
            filterAndParams.write(40);
            String delimiter = "";
            for (FilterSpecParam param : filterSpec.getParameters()) {
                filterAndParams.write(delimiter);
                filterAndParams.write(param.getPropertyName());
                filterAndParams.write(param.getFilterOperator().getTextualOp());
                filterAndParams.write("...");
                delimiter = ",";
            }
            filterAndParams.write(41);
        }
        return (EventStream)EventStreamProxy.newInstance(statementName, filterAndParams.toString(), designated);
    }

    public static Object newInstance(String statementName, String eventTypeAndFilter, EventStream eventStream) {
        return Proxy.newProxyInstance(eventStream.getClass().getClassLoader(), JavaClassHelper.getSuperInterfaces(eventStream.getClass()), (InvocationHandler)new EventStreamProxy(statementName, eventTypeAndFilter, eventStream));
    }

    public EventStreamProxy(String statementName, String eventTypeAndFilter, EventStream eventStream) {
        this.statementName = statementName;
        this.eventTypeAndFilter = eventTypeAndFilter;
        this.eventStream = eventStream;
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        if (m.getName().equals("insert") && auditLog.isInfoEnabled()) {
            Object arg = args[0];
            String events = "(undefined)";
            if (arg instanceof EventBean[]) {
                events = EventBeanUtility.summarize((EventBean[])arg);
            } else if (arg instanceof EventBean) {
                events = EventBeanUtility.summarize((EventBean)arg);
            }
            auditLog.info((Object)("Statement " + this.statementName + " stream " + this.eventTypeAndFilter + " inserted " + events));
        }
        return m.invoke((Object)this.eventStream, args);
    }
}

