/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.OneEventCollection;
import com.espertech.esper.collection.ViewUpdatedCollection;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.core.service.ExtensionServicesContext;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.variable.VariableChangeCallback;
import com.espertech.esper.epl.variable.VariableReader;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.event.map.MapEventBean;
import com.espertech.esper.schedule.ScheduleHandle;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.schedule.ScheduleSlot;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.DataWindowView;
import com.espertech.esper.view.StoppableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.window.ExpressionWindowViewFactory;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Set;

public final class ExpressionWindowView
extends ViewSupport
implements DataWindowView,
CloneableView,
StoppableView,
VariableChangeCallback,
StopCallback {
    public static final String CURRENT_COUNT = "current_count";
    public static final String OLDEST_TIMESTAMP = "oldest_timestamp";
    public static final String NEWEST_TIMESTAMP = "newest_timestamp";
    public static final String EXPIRED_COUNT = "expired_count";
    public static final String VIEW_REFERENCE = "view_reference";
    private final ExpressionWindowViewFactory dataWindowViewFactory;
    private final ViewUpdatedCollection viewUpdatedCollection;
    private final ArrayDeque<TimestampEventPair> window = new ArrayDeque();
    private final ExprEvaluator expiryExpression;
    private final MapEventBean builtinEventProps;
    private final EventBean[] eventsPerStream;
    private final Set<String> variableNames;
    private final AgentInstanceViewFactoryChainContext agentInstanceContext;
    private final ScheduleSlot scheduleSlot;
    private final EPStatementHandleCallback scheduleHandle;

    public ExpressionWindowView(ExpressionWindowViewFactory dataWindowViewFactory, ViewUpdatedCollection viewUpdatedCollection, ExprEvaluator expiryExpression, MapEventBean builtinEventProps, Set<String> variableNames, AgentInstanceViewFactoryChainContext agentInstanceContext) {
        this.dataWindowViewFactory = dataWindowViewFactory;
        this.viewUpdatedCollection = viewUpdatedCollection;
        this.expiryExpression = expiryExpression;
        this.builtinEventProps = builtinEventProps;
        this.eventsPerStream = new EventBean[]{null, builtinEventProps};
        this.variableNames = variableNames;
        this.agentInstanceContext = agentInstanceContext;
        if (variableNames != null && !variableNames.isEmpty()) {
            for (String variable : variableNames) {
                final VariableService variableService = agentInstanceContext.getStatementContext().getVariableService();
                final VariableReader reader = variableService.getReader(variable);
                agentInstanceContext.getStatementContext().getVariableService().registerCallback(reader.getVariableNumber(), this);
                agentInstanceContext.getTerminationCallbacks().add(new StopCallback(){

                    @Override
                    public void stop() {
                        variableService.unregisterCallback(reader.getVariableNumber(), ExpressionWindowView.this);
                    }
                });
            }
            ScheduleHandleCallback callback = new ScheduleHandleCallback(){

                @Override
                public void scheduledTrigger(ExtensionServicesContext extensionServicesContext) {
                    ExpressionWindowView.this.expire(null, null);
                }
            };
            this.scheduleSlot = agentInstanceContext.getStatementContext().getScheduleBucket().allocateSlot();
            this.scheduleHandle = new EPStatementHandleCallback(agentInstanceContext.getEpStatementAgentInstanceHandle(), callback);
            agentInstanceContext.getTerminationCallbacks().add(this);
        } else {
            this.scheduleSlot = null;
            this.scheduleHandle = null;
        }
    }

    @Override
    public View cloneView() {
        return this.dataWindowViewFactory.makeView(this.agentInstanceContext);
    }

    public boolean isEmpty() {
        return this.window.isEmpty();
    }

    public ViewUpdatedCollection getViewUpdatedCollection() {
        return this.viewUpdatedCollection;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        if (newData != null) {
            for (EventBean newEvent : newData) {
                this.window.add(new TimestampEventPair(this.agentInstanceContext.getTimeProvider().getTime(), newEvent));
            }
        }
        if (oldData != null) {
            Iterator<TimestampEventPair> it = this.window.iterator();
            block1: while (it.hasNext()) {
                TimestampEventPair pair = it.next();
                for (EventBean anOldData : oldData) {
                    if (pair.getEvent() != anOldData) continue;
                    it.remove();
                    continue block1;
                }
            }
        }
        this.expire(newData, oldData);
    }

    private void expire(EventBean[] newData, EventBean[] oldData) {
        OneEventCollection expired = null;
        if (oldData != null) {
            expired = new OneEventCollection();
            expired.add(oldData);
        }
        int expiredCount = 0;
        if (!this.window.isEmpty()) {
            TimestampEventPair first;
            boolean pass;
            TimestampEventPair newest = this.window.getLast();
            while (!(pass = this.checkEvent(first = this.window.getFirst(), newest, expiredCount))) {
                if (expired == null) {
                    expired = new OneEventCollection();
                }
                expired.add(this.window.removeFirst().getEvent());
                ++expiredCount;
                if (!this.window.isEmpty()) continue;
                break;
            }
        }
        EventBean[] expiredArr = null;
        if (expired != null) {
            expiredArr = expired.toArray();
        }
        if (this.viewUpdatedCollection != null) {
            this.viewUpdatedCollection.update(newData, expiredArr);
        }
        if (this.hasViews()) {
            this.updateChildren(newData, expiredArr);
        }
    }

    private boolean checkEvent(TimestampEventPair pair, TimestampEventPair newest, int numExpired) {
        this.builtinEventProps.getProperties().put(CURRENT_COUNT, this.window.size());
        this.builtinEventProps.getProperties().put(OLDEST_TIMESTAMP, pair.getTimestamp());
        this.builtinEventProps.getProperties().put(NEWEST_TIMESTAMP, newest.getTimestamp());
        this.builtinEventProps.getProperties().put(VIEW_REFERENCE, this);
        this.builtinEventProps.getProperties().put(EXPIRED_COUNT, numExpired);
        this.eventsPerStream[0] = pair.getEvent();
        Boolean result = (Boolean)this.expiryExpression.evaluate(this.eventsPerStream, true, this.agentInstanceContext);
        if (result == null) {
            return false;
        }
        return result;
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return new TimestampEventPairIterator(this.window.iterator());
    }

    public final String toString() {
        return this.getClass().getName();
    }

    @Override
    public void stopView() {
        this.stopScheduleAndVar();
        this.agentInstanceContext.getTerminationCallbacks().remove(this);
    }

    @Override
    public void stop() {
        this.stopScheduleAndVar();
    }

    public void stopScheduleAndVar() {
        if (this.variableNames != null && !this.variableNames.isEmpty()) {
            for (String variable : this.variableNames) {
                VariableReader reader = this.agentInstanceContext.getStatementContext().getVariableService().getReader(variable);
                if (reader == null) continue;
                this.agentInstanceContext.getStatementContext().getVariableService().unregisterCallback(reader.getVariableNumber(), this);
            }
            if (this.agentInstanceContext.getStatementContext().getSchedulingService().isScheduled(this.scheduleHandle)) {
                this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.scheduleHandle, this.scheduleSlot);
            }
        }
    }

    @Override
    public void update(Object newValue, Object oldValue) {
        if (!this.agentInstanceContext.getStatementContext().getSchedulingService().isScheduled(this.scheduleHandle)) {
            this.agentInstanceContext.getStatementContext().getSchedulingService().add(0L, (ScheduleHandle)this.scheduleHandle, this.scheduleSlot);
        }
    }

    private static class TimestampEventPairIterator
    implements Iterator<EventBean> {
        private final Iterator<TimestampEventPair> events;

        private TimestampEventPairIterator(Iterator<TimestampEventPair> events) {
            this.events = events;
        }

        @Override
        public boolean hasNext() {
            return this.events.hasNext();
        }

        @Override
        public EventBean next() {
            return this.events.next().getEvent();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class TimestampEventPair {
        private final long timestamp;
        private final EventBean event;

        private TimestampEventPair(long timestamp, EventBean event) {
            this.timestamp = timestamp;
            this.event = event;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public EventBean getEvent() {
            return this.event;
        }
    }
}

